/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.api.manager.ICleanable;
import su.nexmedia.engine.api.manager.IListener;
import su.nexmedia.engine.utils.FileUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.api.store.IPointStore;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.store.listener.StoreListener;
import su.nightexpress.gamepoints.store.menu.StoreMenuConfirmation;
import su.nightexpress.gamepoints.store.menu.StoreMenuMain;
import su.nightexpress.gamepoints.store.object.PointStore;
import su.nightexpress.gamepoints.store.task.BalanceTopTask;

public class StoreManager
extends AbstractManager<GamePoints> {
    private Map<String, IPointStore> stores;
    private List<Map.Entry<String, Integer>> balanceTop;
    private StoreMenuMain storeMenuMain;
    private StoreMenuConfirmation storeMenuConfirmation;
    private BalanceTopTask topTask;
    public static final String DIR_STORES = "/stores/";

    public StoreManager(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin);
    }

    protected void onLoad() {
        ((GamePoints)this.plugin).getConfigManager().extractResources(DIR_STORES);
        this.stores = new HashMap<String, IPointStore>();
        this.balanceTop = new ArrayList<Map.Entry<String, Integer>>();
        for (File dir : FileUtil.getFolders((String)(((GamePoints)this.plugin).getDataFolder() + DIR_STORES))) {
            JYML cfg = new JYML(dir.getAbsolutePath(), dir.getName() + ".yml");
            PointStore store = new PointStore((GamePoints)this.plugin, cfg);
            this.stores.put(store.getId(), store);
        }
        ((GamePoints)this.plugin).info("Stores Loaded: " + this.stores.size());
        this.storeMenuMain = new StoreMenuMain((GamePoints)this.plugin);
        this.storeMenuConfirmation = new StoreMenuConfirmation((GamePoints)this.plugin);
        this.addListener((IListener)new StoreListener(this));
        if (Config.GENERAL_TOP_UPDATE_MIN > 0) {
            this.topTask = new BalanceTopTask((GamePoints)this.plugin);
            this.topTask.start();
        }
    }

    protected void onShutdown() {
        if (this.topTask != null) {
            this.topTask.stop();
            this.topTask = null;
        }
        if (this.stores != null) {
            this.stores.values().forEach(ICleanable::clear);
            this.stores.clear();
            this.stores = null;
        }
        if (this.storeMenuMain != null) {
            this.storeMenuMain.clear();
            this.storeMenuMain = null;
        }
    }

    @NotNull
    public StoreMenuMain getStoreMainMenu() {
        return this.storeMenuMain;
    }

    @NotNull
    public StoreMenuConfirmation getStoreConfirmation() {
        return this.storeMenuConfirmation;
    }

    @NotNull
    public List<String> getStoreIds() {
        return new ArrayList<String>(this.stores.keySet());
    }

    @Nullable
    public IPointStore getStore(@NotNull String id) {
        return this.stores.get(id.toLowerCase());
    }

    @NotNull
    public Collection<IPointStore> getStores() {
        return this.stores.values();
    }

    @NotNull
    public List<Map.Entry<String, Integer>> getBalanceTop() {
        return this.balanceTop;
    }
}

