/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.data;

import com.google.gson.reflect.TypeToken;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.data.AbstractUserDataHandler;
import su.nexmedia.engine.api.data.UserDataHolder;
import su.nexmedia.engine.api.data.sql.SQLColumn;
import su.nexmedia.engine.api.data.sql.SQLValue;
import su.nexmedia.engine.api.data.sql.column.ColumnType;
import su.nexmedia.engine.api.data.sql.executor.SelectQueryExecutor;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.data.PointUser;

public class PointsDataHandler
extends AbstractUserDataHandler<GamePoints, PointUser> {
    private static PointsDataHandler instance;
    private final Function<ResultSet, PointUser> userFunction = resultSet -> {
        try {
            UUID uuid = UUID.fromString(resultSet.getString(COLUMN_USER_ID.getName()));
            String name = resultSet.getString(COLUMN_USER_NAME.getName());
            long dateCreated = resultSet.getLong(COLUMN_USER_DATE_CREATED.getName());
            long lastOnline = resultSet.getLong(COLUMN_USER_LAST_ONLINE.getName());
            int balance = resultSet.getInt(COLUMN_BALANCE.getName());
            Map items = (Map)this.gson.fromJson(resultSet.getString(COLUMN_PURCHASES.getName()), new TypeToken<Map<String, Map<String, Long>>>(){}.getType());
            return new PointUser(plugin, uuid, name, dateCreated, lastOnline, balance, items);
        }
        catch (SQLException e) {
            return null;
        }
    };
    private static final SQLColumn COLUMN_BALANCE;
    private static final SQLColumn COLUMN_PURCHASES;

    PointsDataHandler(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, (UserDataHolder)plugin);
    }

    @NotNull
    public static PointsDataHandler getInstance(@NotNull GamePoints plugin) {
        if (instance == null) {
            instance = new PointsDataHandler(plugin);
        }
        return instance;
    }

    protected void onShutdown() {
        super.onShutdown();
        instance = null;
    }

    public void onSynchronize() {
        ((GamePoints)this.plugin).getUserManager().getUsersLoaded().forEach(this::updateUserBalance);
    }

    protected void createUserTable() {
        super.createUserTable();
        this.dropColumn(this.tableUsers, new SQLColumn[]{SQLColumn.of((String)"items", (ColumnType)ColumnType.STRING)});
    }

    public void updateUserBalance(@NotNull PointUser user) {
        PointUser fromDb = (PointUser)this.getUser(user.getId());
        if (fromDb == null) {
            return;
        }
        user.setBalanceRaw(fromDb.getBalance());
    }

    @NotNull
    public Map<String, Integer> getUserBalance() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Function<ResultSet, Void> function = resultSet -> {
            try {
                String name = resultSet.getString(COLUMN_USER_NAME.getName());
                int balance = resultSet.getInt(COLUMN_BALANCE.getName());
                map.put(name, balance);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            return null;
        };
        SelectQueryExecutor.builder((String)this.tableUsers, function).columns(new SQLColumn[]{COLUMN_USER_NAME, COLUMN_BALANCE}).execute(this.getConnector());
        return map;
    }

    @NotNull
    protected List<SQLColumn> getExtraColumns() {
        return Arrays.asList(COLUMN_BALANCE, COLUMN_PURCHASES);
    }

    @NotNull
    protected List<SQLValue> getSaveColumns(@NotNull PointUser user) {
        return Arrays.asList(COLUMN_BALANCE.toValue((Object)user.getBalance()), COLUMN_PURCHASES.toValue((Object)this.gson.toJson(user.getPurchases())));
    }

    @NotNull
    protected Function<ResultSet, PointUser> getFunctionToUser() {
        return this.userFunction;
    }

    static {
        COLUMN_BALANCE = SQLColumn.of((String)"balance", (ColumnType)ColumnType.INTEGER);
        COLUMN_PURCHASES = SQLColumn.of((String)"purchases", (ColumnType)ColumnType.STRING);
    }
}

