/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.conversion.converter;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.UUID;
import org.black_ixx.playerpoints.PlayerPoints;
import org.black_ixx.playerpoints.manager.DataManager;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.conversion.DataConverter;
import su.nightexpress.gamepoints.conversion.converter.AbstractDataConverter;
import su.nightexpress.gamepoints.data.PointUser;

public class PlayerPointsConverter
extends AbstractDataConverter {
    public PlayerPointsConverter(@NotNull GamePoints plugin) {
        super(plugin, DataConverter.PLAYER_POINTS.getPluginName());
    }

    @Override
    public void convert() {
        PlayerPoints playerPoints = (PlayerPoints)this.getTargetPlugin();
        if (playerPoints == null) {
            return;
        }
        HashMap<UUID, Integer> pointsMap = new HashMap<UUID, Integer>();
        HashMap nameMap = new HashMap();
        DataManager dataManager = (DataManager)playerPoints.getManager(DataManager.class);
        try {
            dataManager.getDatabaseConnector().connect(connection -> {
                UUID uuid;
                String query = "SELECT * FROM " + dataManager.getTablePrefix() + "points";
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery(query);
                while (resultSet.next()) {
                    uuid = UUID.fromString(resultSet.getString("uuid"));
                    int points = resultSet.getInt("points");
                    pointsMap.put(uuid, points);
                }
                statement.close();
                query = "SELECT * FROM " + dataManager.getTablePrefix() + "username_cache";
                statement = connection.createStatement();
                resultSet = statement.executeQuery(query);
                while (resultSet.next()) {
                    uuid = UUID.fromString(resultSet.getString("uuid"));
                    String name = resultSet.getString("username");
                    nameMap.put(uuid, name);
                }
                statement.close();
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pointsMap.keySet().removeIf(uuid -> !nameMap.containsKey(uuid));
        pointsMap.values().removeIf(points -> points == 0);
        pointsMap.forEach((uuid, points) -> {
            String name = (String)nameMap.get(uuid);
            PointUser user = new PointUser(this.plugin, (UUID)uuid, name);
            user.setBalanceRaw((int)points);
            this.plugin.getData().addUser(user);
        });
        this.plugin.info("Converted " + pointsMap.size() + " user datas from " + this.getPluginName());
    }
}

