/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.conversion;

import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.hooks.Hooks;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.api.GamePointsAPI;
import su.nightexpress.gamepoints.conversion.converter.AbstractDataConverter;
import su.nightexpress.gamepoints.conversion.converter.PlayerPointsConverter;

public enum DataConverter {
    PLAYER_POINTS("PlayerPoints", PlayerPointsConverter.class);

    private final String pluginName;
    private final Class<? extends AbstractDataConverter> clazz;

    private DataConverter(String pluginName, Class<? extends AbstractDataConverter> clazz) {
        this.pluginName = pluginName;
        this.clazz = clazz;
    }

    @NotNull
    public String getPluginName() {
        return this.pluginName;
    }

    @Nullable
    public AbstractDataConverter getConverter() {
        try {
            return this.clazz.getConstructor(GamePoints.class).newInstance(new Object[]{GamePointsAPI.PLUGIN});
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static AbstractDataConverter getConverter(@NotNull String pluginName) {
        return Stream.of(DataConverter.values()).filter(type -> Hooks.hasPlugin((String)type.getPluginName())).filter(type -> type.getPluginName().equalsIgnoreCase(pluginName)).map(DataConverter::getConverter).findFirst().orElse(null);
    }
}

