/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.config;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.utils.Colorizer;
import su.nightexpress.gamepoints.GamePoints;

public class Config {
    public static String POINTS_NAME;
    public static boolean GENERAL_CONVERSION_ENABLED;
    public static String GENERAL_CONVERSION_FROM;
    public static int GENERAL_START_BALANCE;
    public static int GENERAL_TOP_UPDATE_MIN;
    public static List<String> STORE_PRODUCT_DISPLAY_FORMAT;
    public static List<String> STORE_PRODUCT_PURCHASE_FORMAT_ALREADY_HAVE;
    public static List<String> STORE_PRODUCT_PURCHASE_FORMAT_COOLDOWN;
    public static List<String> STORE_PRODUCT_PURCHASE_FORMAT_AVAILABLE;
    public static String TRANSACTION_LOGS_FORMAT;
    public static DateTimeFormatter TRANSACTION_LOGS_DATE;
    public static boolean TRANSACTION_LOGS_TO_CONSOLE;
    public static boolean TRANSACTION_LOGS_TO_FILE;
    public static String TRANSACTION_LOGS_FILENAME;
    public static final String PLACEHOLDER_POINTS_NAME = "%points_name%";

    @NotNull
    public static UnaryOperator<String> replacePlaceholders() {
        return str -> str.replace(PLACEHOLDER_POINTS_NAME, POINTS_NAME);
    }

    public static void load(@NotNull GamePoints plugin) {
        JYML cfg = plugin.getConfig();
        String path = "General.";
        cfg.addMissing(path + "Conversion.Enabled", (Object)false);
        cfg.addMissing(path + "Conversion.From", (Object)"none");
        POINTS_NAME = Colorizer.apply((String)cfg.getString(path + "Points_Name", "Game Points"));
        GENERAL_CONVERSION_ENABLED = cfg.getBoolean(path + "Conversion.Enabled");
        GENERAL_CONVERSION_FROM = cfg.getString(path + "Conversion.From");
        GENERAL_START_BALANCE = cfg.getInt(path + "Start_Balance", 0);
        GENERAL_TOP_UPDATE_MIN = cfg.getInt(path + "Balance_Top.Update_Interval", 20);
        path = "Store.Product.";
        STORE_PRODUCT_DISPLAY_FORMAT = Colorizer.apply((List)cfg.getStringList(path + "Display.Format"));
        STORE_PRODUCT_PURCHASE_FORMAT_ALREADY_HAVE = Colorizer.apply((List)cfg.getStringList(path + "Purchase.Format.Already_Have"));
        STORE_PRODUCT_PURCHASE_FORMAT_COOLDOWN = Colorizer.apply((List)cfg.getStringList(path + "Purchase.Format.Cooldown"));
        STORE_PRODUCT_PURCHASE_FORMAT_AVAILABLE = Colorizer.apply((List)cfg.getStringList(path + "Purchase.Format.Available"));
        path = "Transaction_Logs.";
        TRANSACTION_LOGS_TO_CONSOLE = cfg.getBoolean(path + "Console");
        TRANSACTION_LOGS_TO_FILE = cfg.getBoolean(path + "File");
        if (TRANSACTION_LOGS_TO_CONSOLE || TRANSACTION_LOGS_TO_FILE) {
            TRANSACTION_LOGS_FORMAT = cfg.getString(path + "Format", "%user_name% bought ''%product_id%'' in ''%store_id%'' store for %product_price_inherited% points.");
            TRANSACTION_LOGS_DATE = DateTimeFormatter.ofPattern(cfg.getString(path + "Date", "dd/MM/yyyy HH:mm:ss"));
        }
    }

    public static void disableConversion(@NotNull GamePoints plugin) {
        plugin.getConfig().set("General.Conversion.Enabled", (Object)false);
        plugin.getConfig().save();
    }

    static {
        TRANSACTION_LOGS_FILENAME = "transactions.log";
    }
}

