/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.data.PointUser;
import su.nightexpress.gamepoints.lang.Lang;

public class TakeCommand
extends AbstractCommand<GamePoints> {
    public TakeCommand(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, new String[]{"take"}, "gamepoints.command.take");
    }

    @NotNull
    public String getDescription() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_TAKE_DESC).getLocalized();
    }

    @NotNull
    public String getUsage() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_TAKE_USAGE).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int arg, @NotNull String[] args) {
        if (arg == 1) {
            return CollectionsUtil.playerNames((Player)player);
        }
        if (arg == 2) {
            return Arrays.asList("<amount>", "1", "10", "50", "100");
        }
        return super.getTab(player, arg, args);
    }

    public void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        if (args.length != 3) {
            this.printUsage(sender);
            return;
        }
        String userName = args[1];
        int amount = StringUtil.getInteger((String)args[2], (int)0);
        if (amount <= 0) {
            this.errorNumber(sender, args[2]);
            return;
        }
        PointUser user = (PointUser)((GamePoints)this.plugin).getUserManager().getUserData(userName);
        if (user == null) {
            this.errorPlayer(sender);
            return;
        }
        user.takePoints(amount);
        ((GamePoints)this.plugin).getMessage(Lang.COMMAND_TAKE_DONE_SENDER).replace(Config.replacePlaceholders()).replace("%amount%", (Object)amount).replace(user.replacePlaceholders()).send(sender);
        Player player = ((GamePoints)this.plugin).getServer().getPlayer(user.getName());
        if (player != null) {
            ((GamePoints)this.plugin).getMessage(Lang.COMMAND_TAKE_DONE_USER).replace(Config.replacePlaceholders()).replace("%amount%", (Object)amount).send((CommandSender)player);
        }
    }
}

