/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.command;

import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.api.store.IPointStore;
import su.nightexpress.gamepoints.lang.Lang;

public class StoreCommand
extends AbstractCommand<GamePoints> {
    public StoreCommand(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, new String[]{"store"}, "gamepoints.command.store");
    }

    @NotNull
    public String getDescription() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_STORE_DESC).getLocalized();
    }

    @NotNull
    public String getUsage() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_STORE_USAGE).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int arg, @NotNull String[] args) {
        if (arg == 1) {
            return ((GamePoints)this.plugin).getStoreManager().getStoreIds();
        }
        if (arg == 2) {
            return CollectionsUtil.playerNames((Player)player);
        }
        return super.getTab(player, arg, args);
    }

    public void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        if (args.length < 3 && !(sender instanceof Player) || args.length > 3) {
            this.printUsage(sender);
            return;
        }
        if (args.length < 2) {
            Player player = (Player)sender;
            ((GamePoints)this.plugin).getStoreManager().getStoreMainMenu().open(player, 1);
            return;
        }
        String storeName = args[1];
        IPointStore store = ((GamePoints)this.plugin).getStoreManager().getStore(storeName);
        if (store == null) {
            ((GamePoints)this.plugin).getMessage(Lang.STORE_ERROR_INVALID).send(sender);
            return;
        }
        if (args.length >= 3 && !sender.hasPermission("gamepoints.admin")) {
            this.errorPermission(sender);
            return;
        }
        String userName = args.length == 3 ? args[2] : sender.getName();
        Player player = ((GamePoints)this.plugin).getServer().getPlayer(userName);
        if (player == null) {
            this.errorPlayer(sender);
            return;
        }
        store.open(player);
    }
}

