/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.data.PointUser;
import su.nightexpress.gamepoints.lang.Lang;

public class SetCommand
extends AbstractCommand<GamePoints> {
    public SetCommand(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, new String[]{"set"}, "gamepoints.command.set");
    }

    @NotNull
    public String getDescription() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_SET_DESC).getLocalized();
    }

    @NotNull
    public String getUsage() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_SET_USAGE).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return CollectionsUtil.playerNames((Player)player);
        }
        if (i == 2) {
            return Arrays.asList("<amount>", "1", "10", "50", "100");
        }
        return super.getTab(player, i, args);
    }

    public void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        if (args.length != 3) {
            this.printUsage(sender);
            return;
        }
        String userName = args[1];
        PointUser user = (PointUser)((GamePoints)this.plugin).getUserManager().getUserData(userName);
        if (user == null) {
            this.errorPlayer(sender);
            return;
        }
        int amount = StringUtil.getInteger((String)args[2], (int)user.getBalance());
        user.setBalance(amount);
        ((GamePoints)this.plugin).getMessage(Lang.COMMAND_SET_DONE_SENDER).replace(Config.replacePlaceholders()).replace("%amount%", (Object)amount).replace(user.replacePlaceholders()).send(sender);
        Player player = user.getPlayer();
        if (player != null) {
            ((GamePoints)this.plugin).getMessage(Lang.COMMAND_SET_DONE_USER).replace(Config.replacePlaceholders()).replace("%amount%", (Object)amount).send((CommandSender)player);
        }
    }
}

