/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.command;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.lang.EngineLang;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.data.PointUser;
import su.nightexpress.gamepoints.lang.Lang;

public class PayCommand
extends AbstractCommand<GamePoints> {
    public PayCommand(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, new String[]{"pay"}, "gamepoints.command.pay");
    }

    @NotNull
    public String getDescription() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_PAY_DESC).getLocalized();
    }

    @NotNull
    public String getUsage() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_PAY_USAGE).getLocalized();
    }

    public boolean isPlayerOnly() {
        return true;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return CollectionsUtil.playerNames((Player)player);
        }
        if (i == 2) {
            return Arrays.asList("<amount>", "1", "10", "50", "100");
        }
        return super.getTab(player, i, args);
    }

    public void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        if (args.length != 3) {
            this.printUsage(sender);
            return;
        }
        String userName = args[1];
        if (userName.equalsIgnoreCase(sender.getName())) {
            ((GamePoints)this.plugin).getMessage(EngineLang.ERROR_COMMAND_SELF).send(sender);
            return;
        }
        PointUser userTarget = (PointUser)((GamePoints)this.plugin).getUserManager().getUserData(userName);
        if (userTarget == null) {
            this.errorPlayer(sender);
            return;
        }
        Player from = (Player)sender;
        PointUser userFrom = (PointUser)((GamePoints)this.plugin).getUserManager().getUserData(from);
        int amount = StringUtil.getInteger((String)args[2], (int)0);
        if (amount <= 0) {
            ((GamePoints)this.plugin).getMessage(EngineLang.ERROR_NUMBER_INVALID).replace("%num%", (Object)args[2]).send(sender);
            return;
        }
        if (amount > userFrom.getBalance()) {
            ((GamePoints)this.plugin).getMessage(Lang.COMMAND_PAY_ERROR_NO_MONEY).send((CommandSender)from);
            return;
        }
        userTarget.addPoints(amount);
        userFrom.takePoints(amount);
        ((GamePoints)this.plugin).getMessage(Lang.COMMAND_PAY_DONE_SENDER).replace(Config.replacePlaceholders()).replace("%amount%", (Object)amount).replace("%player%", (Object)userTarget.getName()).send(sender);
        Player pTarget = ((GamePoints)this.plugin).getServer().getPlayer(userTarget.getName());
        if (pTarget != null) {
            ((GamePoints)this.plugin).getMessage(Lang.COMMAND_PAY_DONE_USER).replace(Config.replacePlaceholders()).replace("%amount%", (Object)amount).replace("%player%", (Object)userFrom.getName()).send((CommandSender)pTarget);
        }
    }
}

