/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.lang.Lang;

public class BalanceTopCommand
extends AbstractCommand<GamePoints> {
    public BalanceTopCommand(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, new String[]{"top", "balancetop", "baltop"}, "gamepoints.command.balancetop");
    }

    @NotNull
    public String getDescription() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_BALANCE_TOP_DESC).getLocalized();
    }

    @NotNull
    public String getUsage() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_BALANCE_TOP_USAGE).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        if (i == 1) {
            return Arrays.asList("1", "2", "<page>");
        }
        return super.getTab(player, i, args);
    }

    public void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        List total;
        int pages;
        int page = args.length >= 2 ? StringUtil.getInteger((String)args[1], (int)1) - 1 : 0;
        if (page >= (pages = (total = CollectionsUtil.split(((GamePoints)this.plugin).getStoreManager().getBalanceTop(), (int)10)).size())) {
            page = pages - 1;
        }
        if (page < 0) {
            page = 0;
        }
        List list = pages > 0 ? (List)total.get(page) : new ArrayList();
        int pos = 1 + 10 * page;
        for (String line : ((GamePoints)this.plugin).getMessage(Lang.COMMAND_BALANCE_TOP_LIST).replace(Config.replacePlaceholders()).replace("%page_min%", (Object)(page + 1)).replace("%page_max%", (Object)pages).asList()) {
            if (line.contains("%user_name%")) {
                for (Map.Entry entry : list) {
                    sender.sendMessage(line.replace("%pos%", String.valueOf(pos++)).replace("%user_balance%", String.valueOf(entry.getValue())).replace("%user_name%", (CharSequence)entry.getKey()));
                }
                continue;
            }
            sender.sendMessage(line);
        }
    }
}

