/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.command;

import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.data.PointUser;
import su.nightexpress.gamepoints.lang.Lang;

public class BalanceCommand
extends AbstractCommand<GamePoints> {
    public BalanceCommand(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, new String[]{"balance", "bal"}, "gamepoints.command.balance");
    }

    @NotNull
    public String getDescription() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_BALANCE_DESC).getLocalized();
    }

    @NotNull
    public String getUsage() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_BALANCE_USAGE).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public @NotNull List<@NotNull String> getTab(@NotNull Player player, int arg, @NotNull String[] args) {
        if (arg == 1 && player.hasPermission("gamepoints.command.balance.others")) {
            return CollectionsUtil.playerNames((Player)player);
        }
        return super.getTab(player, arg, args);
    }

    public void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        if (args.length < 2 && !(sender instanceof Player) || args.length > 2) {
            this.printUsage(sender);
            return;
        }
        if (args.length >= 2 && !sender.hasPermission("gamepoints.command.balance.others")) {
            this.errorPermission(sender);
            return;
        }
        String userName = args.length == 2 ? args[1] : sender.getName();
        PointUser user = (PointUser)((GamePoints)this.plugin).getUserManager().getUserData(userName);
        if (user == null) {
            this.errorPlayer(sender);
            return;
        }
        ((GamePoints)this.plugin).getMessage(Lang.COMMAND_BALANCE_DONE).replace(Config.replacePlaceholders()).replace(user.replacePlaceholders()).send(sender);
    }
}

