/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints.command;

import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nightexpress.gamepoints.GamePoints;
import su.nightexpress.gamepoints.api.store.IPointProduct;
import su.nightexpress.gamepoints.api.store.IPointStore;
import su.nightexpress.gamepoints.data.PointUser;
import su.nightexpress.gamepoints.lang.Lang;

public class AddPurchaseCommand
extends AbstractCommand<GamePoints> {
    public AddPurchaseCommand(@NotNull GamePoints plugin) {
        super((NexPlugin)plugin, new String[]{"addpurchase"}, "gamepoints.command.addpurchase");
    }

    @NotNull
    public String getUsage() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_ADD_PURCHASE_USAGE).getLocalized();
    }

    @NotNull
    public String getDescription() {
        return ((GamePoints)this.plugin).getMessage(Lang.COMMAND_ADD_PURCHASE_DESC).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int i, @NotNull String[] args) {
        IPointStore store;
        if (i == 1) {
            return CollectionsUtil.playerNames((Player)player);
        }
        if (i == 2) {
            return ((GamePoints)this.plugin).getStoreManager().getStoreIds();
        }
        if (i == 3 && (store = ((GamePoints)this.plugin).getStoreManager().getStore(args[2])) != null) {
            return store.getProducts().stream().map(IPointProduct::getId).toList();
        }
        return super.getTab(player, i, args);
    }

    protected void onExecute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args, @NotNull Map<String, String> flags) {
        if (args.length != 4) {
            this.printUsage(sender);
            return;
        }
        PointUser user = (PointUser)((GamePoints)this.plugin).getUserManager().getUserData(args[1]);
        if (user == null) {
            this.errorPlayer(sender);
            return;
        }
        String storeId = args[2];
        IPointStore store = ((GamePoints)this.plugin).getStoreManager().getStore(storeId);
        if (store == null) {
            ((GamePoints)this.plugin).getMessage(Lang.STORE_ERROR_INVALID).send(sender);
            return;
        }
        String productId = args[3];
        IPointProduct product = store.getProduct(productId);
        if (product == null) {
            ((GamePoints)this.plugin).getMessage(Lang.STORE_ERROR_PRODUCT_INVALID).send(sender);
            return;
        }
        if (product.getPurchaseCooldown() == 0L) {
            ((GamePoints)this.plugin).getMessage(Lang.COMMAND_ADD_PURCHASE_ERROR_NO_COOLDOWN).send(sender);
            return;
        }
        long cooldown = product.getPurchaseNextTime();
        user.getPurchases(store).put(product.getId(), cooldown);
        ((GamePoints)this.plugin).getMessage(Lang.COMMAND_ADD_PURCHASE_DONE_USER).send(sender);
    }
}

