/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.gamepoints;

import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.GeneralCommand;
import su.nexmedia.engine.api.data.UserDataHolder;
import su.nexmedia.engine.command.list.ReloadSubCommand;
import su.nexmedia.engine.hooks.Hooks;
import su.nightexpress.gamepoints.command.AddCommand;
import su.nightexpress.gamepoints.command.AddPurchaseCommand;
import su.nightexpress.gamepoints.command.BalanceCommand;
import su.nightexpress.gamepoints.command.BalanceTopCommand;
import su.nightexpress.gamepoints.command.PayCommand;
import su.nightexpress.gamepoints.command.RemovePurchaseCommand;
import su.nightexpress.gamepoints.command.SetCommand;
import su.nightexpress.gamepoints.command.StoreCommand;
import su.nightexpress.gamepoints.command.TakeCommand;
import su.nightexpress.gamepoints.config.Config;
import su.nightexpress.gamepoints.conversion.DataConverter;
import su.nightexpress.gamepoints.conversion.converter.AbstractDataConverter;
import su.nightexpress.gamepoints.data.PointUser;
import su.nightexpress.gamepoints.data.PointsDataHandler;
import su.nightexpress.gamepoints.data.PointsUserManager;
import su.nightexpress.gamepoints.hook.PlaceholderAPIHook;
import su.nightexpress.gamepoints.lang.Lang;
import su.nightexpress.gamepoints.store.StoreManager;

public class GamePoints
extends NexPlugin<GamePoints>
implements UserDataHolder<GamePoints, PointUser> {
    private StoreManager storeManager;
    private PointsDataHandler pointsDataHandler;
    private PointsUserManager pointsUserManager;

    @NotNull
    protected GamePoints getSelf() {
        return this;
    }

    public void enable() {
        if (Config.GENERAL_CONVERSION_ENABLED) {
            AbstractDataConverter converter = DataConverter.getConverter(Config.GENERAL_CONVERSION_FROM);
            if (converter == null) {
                this.error("Could not setup data converter for '" + Config.GENERAL_CONVERSION_FROM + "'.");
            } else {
                converter.convert();
                Config.disableConversion(this);
            }
        }
        this.storeManager = new StoreManager(this);
        this.storeManager.setup();
        if (Hooks.hasPlaceholderAPI()) {
            PlaceholderAPIHook.setup();
        }
    }

    public void disable() {
        if (Hooks.hasPlaceholderAPI()) {
            PlaceholderAPIHook.shutdown();
        }
        if (this.storeManager != null) {
            this.storeManager.shutdown();
            this.storeManager = null;
        }
    }

    public boolean setupDataHandlers() {
        this.pointsDataHandler = PointsDataHandler.getInstance(this);
        this.pointsDataHandler.setup();
        this.pointsUserManager = new PointsUserManager(this);
        this.pointsUserManager.setup();
        return true;
    }

    public void loadConfig() {
        Config.load(this);
    }

    public void loadLang() {
        this.getLangManager().loadMissing(Lang.class);
    }

    public void registerCommands(@NotNull GeneralCommand<GamePoints> mainCommand) {
        mainCommand.addChildren((AbstractCommand)new AddCommand(this));
        mainCommand.addChildren((AbstractCommand)new AddPurchaseCommand(this));
        mainCommand.addChildren((AbstractCommand)new BalanceCommand(this));
        mainCommand.addChildren((AbstractCommand)new BalanceTopCommand(this));
        mainCommand.addChildren((AbstractCommand)new PayCommand(this));
        mainCommand.addChildren((AbstractCommand)new SetCommand(this));
        mainCommand.addChildren((AbstractCommand)new StoreCommand(this));
        mainCommand.addChildren((AbstractCommand)new TakeCommand(this));
        mainCommand.addChildren((AbstractCommand)new RemovePurchaseCommand(this));
        mainCommand.addChildren((AbstractCommand)new ReloadSubCommand((NexPlugin)this, "gamepoints.admin"));
    }

    public void registerHooks() {
    }

    public void registerPermissions() {
    }

    @NotNull
    public StoreManager getStoreManager() {
        return this.storeManager;
    }

    @NotNull
    public PointsDataHandler getData() {
        return this.pointsDataHandler;
    }

    @NotNull
    public PointsUserManager getUserManager() {
        return this.pointsUserManager;
    }
}

