/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.wrappers;

import com.loohp.interactivechat.utils.FilledMapUtils;
import com.loohp.interactivechatdiscordsrvaddon.api.events.MapDataLookupEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;

public class ItemMapWrapper {
    private static final Comparator<MapCursor> ICON_ORDER;
    private ItemStack itemStack;
    private byte[] colors;
    private List<MapCursor> icons;

    public ItemMapWrapper(ItemStack itemStack, Player player) {
        this.itemStack = itemStack;
        this.update(player);
    }

    public void update(Player player) {
        List icons;
        byte[] colors;
        if (!FilledMapUtils.isFilledMap((ItemStack)this.itemStack)) {
            throw new IllegalArgumentException("Provided item is not a filled map");
        }
        int mapId = FilledMapUtils.getMapId((ItemStack)this.itemStack);
        MapView mapView = FilledMapUtils.getMapView((ItemStack)this.itemStack);
        if (mapView == null) {
            colors = null;
            icons = null;
        } else {
            colors = FilledMapUtils.getColors((MapView)mapView, (Player)player);
            icons = FilledMapUtils.getCursors((MapView)mapView, (Player)player).stream().sorted(ICON_ORDER).collect(Collectors.toList());
        }
        MapDataLookupEvent event = new MapDataLookupEvent(player, mapId, mapView, colors, icons);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.colors = event.getColors();
        this.icons = event.getMapCursors();
    }

    public byte[] getColors() {
        return this.colors;
    }

    public List<MapCursor> getMapCursors() {
        return this.icons;
    }

    static {
        Comparator<MapCursor> first = Comparator.comparing(each -> each.getRawType());
        Comparator<MapCursor> second = Collections.reverseOrder(Comparator.comparing(each -> each.getY()));
        Comparator<MapCursor> third = Collections.reverseOrder(Comparator.comparing(each -> each.getX()));
        ICON_ORDER = first.thenComparing(second).thenComparing(third);
    }
}

