/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.wrappers;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Pair;
import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechat.utils.MCVersion;
import com.loohp.interactivechat.utils.NMSUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageFrame;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.listeners.InboundToGameEvents;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.MapMeta;
import org.bukkit.map.MapPalette;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GraphicsToPacketMapWrapper {
    public static final short MAP_ID = Short.MAX_VALUE;
    private static Class<?> nmsMapIconClass;
    private static Class<?> nmsWorldMapClass;
    private static Class<?> nmsWorldMapBClass;
    private static Constructor<?> nmsWorldMapBClassConstructor;
    private volatile boolean done;
    private List<ImageFrame> frames;
    private List<byte[]> colors;
    private ItemStack mapItem;
    private int totalTime;
    private boolean playbackBar;
    private Color backgroundColor;

    public GraphicsToPacketMapWrapper(List<ImageFrame> frames, boolean playbackBar, Color backgroundColor) {
        this.done = true;
        this.frames = frames;
        this.playbackBar = playbackBar;
        this.backgroundColor = backgroundColor;
        this.update();
    }

    public GraphicsToPacketMapWrapper(BufferedImage image, Color backgroundColor) {
        this(Collections.singletonList(new ImageFrame(image)), false, backgroundColor);
    }

    public GraphicsToPacketMapWrapper(boolean playbackBar, Color backgroundColor) {
        this.done = false;
        this.frames = null;
        this.playbackBar = playbackBar;
        this.backgroundColor = backgroundColor;
    }

    public boolean futureCompleted() {
        return this.done;
    }

    public boolean futureCancelled() {
        return this.done && this.frames == null;
    }

    public synchronized void completeFuture(List<ImageFrame> frames) {
        if (this.done) {
            return;
        }
        this.frames = frames;
        this.done = true;
        this.update();
    }

    public void update() {
        int currentFrame;
        if (!this.done) {
            throw new IllegalStateException("Future has not complete!");
        }
        this.colors = new ArrayList<byte[]>();
        this.mapItem = XMaterial.FILLED_MAP.parseItem();
        if (InteractiveChat.version.isLegacy()) {
            this.mapItem.setDurability((short)Short.MAX_VALUE);
        } else {
            MapMeta meta = (MapMeta)this.mapItem.getItemMeta();
            meta.setMapId(Short.MAX_VALUE);
            this.mapItem.setItemMeta((ItemMeta)meta);
        }
        int totalTime = 0;
        for (ImageFrame frame : this.frames) {
            totalTime += frame.getDelay();
        }
        this.totalTime = totalTime;
        for (int currentTime = 0; currentTime <= totalTime && (currentFrame = this.getFrameAt(currentTime)) >= 0; currentTime += 50) {
            BufferedImage processedFrame = ImageUtils.resizeImageQuality(ImageUtils.squarify(this.frames.get(currentFrame).getImage()), 128, 128);
            if (this.playbackBar) {
                Graphics2D g = processedFrame.createGraphics();
                g.setColor(InteractiveChatDiscordSrvAddon.plugin.playbackBarEmptyColor);
                g.fillRect(0, 126, 128, 2);
                g.setColor(InteractiveChatDiscordSrvAddon.plugin.playbackBarFilledColor);
                g.fillRect(0, 126, (int)((double)currentTime / (double)totalTime * 128.0), 2);
                g.dispose();
            }
            if (this.backgroundColor != null) {
                BufferedImage background = new BufferedImage(processedFrame.getWidth(), processedFrame.getHeight(), 2);
                Graphics2D g = background.createGraphics();
                g.setColor(this.backgroundColor);
                g.fillRect(0, 0, background.getWidth(), background.getHeight());
                g.drawImage((Image)processedFrame, 0, 0, null);
                g.dispose();
                processedFrame = background;
            }
            this.colors.add(MapPalette.imageToBytes((Image)processedFrame));
        }
    }

    public List<ImageFrame> getImageFrame() {
        return this.frames;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public int getFrameAt(int ms) {
        int current = 0;
        int i = 0;
        for (ImageFrame frame : this.frames) {
            if ((current += frame.getDelay()) >= ms) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public List<byte[]> getColors() {
        return this.colors;
    }

    public void show(final Player player) {
        PacketContainer packet1;
        if (!this.done) {
            throw new IllegalStateException("Future has not complete!");
        }
        InteractiveChatDiscordSrvAddon.plugin.imagesViewedCounter.incrementAndGet();
        InboundToGameEvents.MAP_VIEWERS.put(player, this);
        final ProtocolManager protocollib = ProtocolLibrary.getProtocolManager();
        if (InteractiveChat.version.isOld()) {
            packet1 = protocollib.createPacket(PacketType.Play.Server.SET_SLOT);
            packet1.getIntegers().write(0, (Object)0);
            packet1.getIntegers().write(1, (Object)(player.getInventory().getHeldItemSlot() + 36));
            packet1.getItemModifier().write(0, (Object)this.mapItem);
        } else {
            packet1 = protocollib.createPacket(PacketType.Play.Server.ENTITY_EQUIPMENT);
            packet1.getIntegers().write(0, (Object)player.getEntityId());
            if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16)) {
                ArrayList<Pair> list = new ArrayList<Pair>();
                list.add(new Pair((Object)EnumWrappers.ItemSlot.MAINHAND, (Object)this.mapItem));
                packet1.getSlotStackPairLists().write(0, list);
            } else {
                packet1.getItemSlots().write(0, (Object)EnumWrappers.ItemSlot.MAINHAND);
                packet1.getItemModifier().write(0, (Object)this.mapItem);
            }
        }
        final PacketContainer packet2 = protocollib.createPacket(PacketType.Play.Server.MAP);
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_17)) {
            packet2.getIntegers().write(0, (Object)Short.MAX_VALUE);
            packet2.getBytes().write(0, (Object)0);
            packet2.getBooleans().write(0, (Object)false);
        } else {
            int mapIconFieldPos = 2;
            packet2.getIntegers().write(0, (Object)Short.MAX_VALUE);
            packet2.getBytes().write(0, (Object)0);
            if (!InteractiveChat.version.isOld()) {
                packet2.getBooleans().write(0, (Object)false);
                ++mapIconFieldPos;
            }
            if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_14)) {
                packet2.getBooleans().write(1, (Object)false);
                ++mapIconFieldPos;
            }
            packet2.getModifier().write(mapIconFieldPos, Array.newInstance(nmsMapIconClass, 0));
            packet2.getIntegers().write(1, (Object)0);
            packet2.getIntegers().write(2, (Object)0);
            packet2.getIntegers().write(3, (Object)128);
            packet2.getIntegers().write(4, (Object)128);
        }
        protocollib.sendServerPacket(player, packet1);
        final GraphicsToPacketMapWrapper ref = this;
        new BukkitRunnable(){
            int index = 0;

            public void run() {
                GraphicsToPacketMapWrapper wrapper = InboundToGameEvents.MAP_VIEWERS.get(player);
                if (wrapper != null && wrapper.equals(ref)) {
                    try {
                        byte[] colorArray = (byte[])GraphicsToPacketMapWrapper.this.colors.get(this.index);
                        if (colorArray == null) {
                            throw new IllegalStateException("Color Array at index " + this.index + " is null!");
                        }
                        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_17)) {
                            packet2.getModifier().write(4, nmsWorldMapBClassConstructor.newInstance(0, 0, 128, 128, colorArray));
                        } else {
                            packet2.getByteArrays().write(0, (Object)colorArray);
                        }
                        protocollib.sendServerPacket(player, packet2);
                    }
                    catch (FieldAccessException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                        e.printStackTrace();
                    }
                } else {
                    this.cancel();
                }
                if (++this.index >= GraphicsToPacketMapWrapper.this.colors.size()) {
                    this.index = 0;
                }
            }
        }.runTaskTimer((Plugin)InteractiveChatDiscordSrvAddon.plugin, 0L, 1L);
    }

    static {
        try {
            nmsMapIconClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.MapIcon", (String[])new String[]{"net.minecraft.world.level.saveddata.maps.MapIcon"});
            nmsWorldMapClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.WorldMap", (String[])new String[]{"net.minecraft.world.level.saveddata.maps.WorldMap"});
            if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_17)) {
                nmsWorldMapBClass = Arrays.stream(nmsWorldMapClass.getClasses()).filter(each -> each.getName().endsWith("$b")).findFirst().get();
                nmsWorldMapBClassConstructor = nmsWorldMapBClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, byte[].class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

