/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.wrappers;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.utils.MCVersion;
import com.loohp.interactivechat.utils.NMSUtils;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.FieldAccessor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.OptionalLong;
import org.bukkit.World;

public class DimensionManagerWrapper {
    private static Class<?> craftWorldClass;
    private static Method getHandleMethod;
    private static Class<?> worldServerClass;
    private static Class<?> dimensionManagerClass;
    private static Method getDimensionManagerMethod;
    private static FieldAccessor<OptionalLong> fixedTimeField;
    private static FieldAccessor<Boolean> hasSkylightField;
    private static FieldAccessor<Boolean> hasCeilingField;
    private static FieldAccessor<Boolean> ultraWarmField;
    private static FieldAccessor<Boolean> naturalField;
    private static FieldAccessor<Double> coordinateScaleField;
    private static FieldAccessor<Boolean> createDragonFightField;
    private static FieldAccessor<Boolean> piglinSafeField;
    private static FieldAccessor<Boolean> bedWorksField;
    private static FieldAccessor<Boolean> respawnAnchorWorksField;
    private static FieldAccessor<Boolean> hasRaidsField;
    private static FieldAccessor<Integer> minYField;
    private static FieldAccessor<Integer> heightField;
    private static FieldAccessor<Integer> logicalHeightField;
    private static FieldAccessor<String> infiniburnField;
    private static FieldAccessor<String> effectsLocationField;
    private static FieldAccessor<Float> ambientLightField;
    private static Method tagKeyGetMinecraftKeyMethod;
    private Object nmsDimensionManager;
    private World.Environment environment;

    public DimensionManagerWrapper(World world) {
        if (InteractiveChat.version.isOlderThan(MCVersion.V1_16)) {
            throw new RuntimeException("DimensionManagerWrapper can only be used on Minecraft version 1.16 or above");
        }
        try {
            Object craftWorldObject = craftWorldClass.cast(world);
            Object nmsWorldServerObject = getHandleMethod.invoke(craftWorldObject, new Object[0]);
            this.nmsDimensionManager = getDimensionManagerMethod.invoke(nmsWorldServerObject, new Object[0]);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        this.environment = world.getEnvironment();
    }

    public boolean hasFixedTime() {
        return this.getFixedTime().isPresent();
    }

    public OptionalLong getFixedTime() {
        return fixedTimeField.getOrDefault(this.nmsDimensionManager);
    }

    public float timeOfDay(long i) {
        long i0;
        double d0;
        double d1 = 0.5 - Math.cos((d0 -= (double)((d0 = (double)this.getFixedTime().orElse(i) / 24000.0 - 0.25) < (double)(i0 = (long)d0) ? i0 - 1L : i0)) * Math.PI) / 2.0;
        return (float)(d0 * 2.0 + d1) / 3.0f;
    }

    public boolean hasSkyLight() {
        return hasSkylightField.getOrDefault(this.nmsDimensionManager);
    }

    public boolean hasCeiling() {
        return hasCeilingField.getOrDefault(this.nmsDimensionManager);
    }

    public boolean ultraWarm() {
        return ultraWarmField.getOrDefault(this.nmsDimensionManager);
    }

    public boolean natural() {
        return naturalField.getOrDefault(this.nmsDimensionManager);
    }

    public double coordinateScale() {
        return coordinateScaleField.getOrDefault(this.nmsDimensionManager);
    }

    public boolean createDragonFight() {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_19)) {
            return this.environment.equals((Object)World.Environment.THE_END);
        }
        return createDragonFightField.getOrDefault(this.nmsDimensionManager);
    }

    public boolean piglinSafe() {
        return piglinSafeField.getOrDefault(this.nmsDimensionManager);
    }

    public boolean bedWorks() {
        return bedWorksField.getOrDefault(this.nmsDimensionManager);
    }

    public boolean respawnAnchorWorks() {
        return respawnAnchorWorksField.getOrDefault(this.nmsDimensionManager);
    }

    public boolean hasRaids() {
        return hasRaidsField.getOrDefault(this.nmsDimensionManager);
    }

    public int minY() {
        return minYField.getOrDefault(this.nmsDimensionManager);
    }

    public int height() {
        return heightField.getOrDefault(this.nmsDimensionManager);
    }

    public int logicalHeight() {
        return logicalHeightField.getOrDefault(this.nmsDimensionManager);
    }

    public String infiniburn() {
        return infiniburnField.getOrDefault(this.nmsDimensionManager);
    }

    public String effectsLocation() {
        return effectsLocationField.getOrDefault(this.nmsDimensionManager);
    }

    public float ambientLight() {
        return ambientLightField.getOrDefault(this.nmsDimensionManager).floatValue();
    }

    static {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16)) {
            try {
                craftWorldClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.CraftWorld", (String[])new String[0]);
                getHandleMethod = craftWorldClass.getMethod("getHandle", new Class[0]);
                worldServerClass = getHandleMethod.getReturnType();
                dimensionManagerClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.DimensionManager", (String[])new String[]{"net.minecraft.world.level.dimension.DimensionManager"});
                getDimensionManagerMethod = Arrays.stream(worldServerClass.getMethods()).filter(each -> each.getReturnType().equals(dimensionManagerClass)).findFirst().get();
                if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_19)) {
                    fixedTimeField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("k"));
                    hasSkylightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("l"));
                    hasCeilingField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("m"));
                    ultraWarmField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("n"));
                    naturalField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("o"));
                    coordinateScaleField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("p"));
                    bedWorksField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("q"));
                    respawnAnchorWorksField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("r"));
                    minYField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("s"));
                    heightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("t"));
                    logicalHeightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("u"));
                    if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_18_2)) {
                        infiniburnField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("v"), obj -> {
                            try {
                                return tagKeyGetMinecraftKeyMethod.invoke(obj, new Object[0]).toString();
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                throw new RuntimeException(e);
                            }
                        });
                    }
                    effectsLocationField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("w"), obj -> obj.toString());
                    ambientLightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("x"));
                    tagKeyGetMinecraftKeyMethod = infiniburnField.getField().getType().getMethod("b", new Class[0]);
                    Class<?> monstersSettingClass = dimensionManagerClass.getDeclaredField("y").getType();
                    Field piglinSafeSubField = monstersSettingClass.getDeclaredField("b");
                    Field hasRaidsSubField = monstersSettingClass.getDeclaredField("c");
                    createDragonFightField = null;
                    piglinSafeField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("y"), obj -> {
                        piglinSafeSubField.setAccessible(true);
                        try {
                            return (boolean)((Boolean)piglinSafeSubField.get(obj));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    hasRaidsField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("y"), obj -> {
                        hasRaidsSubField.setAccessible(true);
                        try {
                            return (boolean)((Boolean)hasRaidsSubField.get(obj));
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    });
                } else if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_18)) {
                    fixedTimeField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("w"));
                    hasSkylightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("x"));
                    hasCeilingField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("y"));
                    ultraWarmField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("z"));
                    naturalField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("A"));
                    coordinateScaleField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("B"));
                    createDragonFightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("C"));
                    piglinSafeField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("D"));
                    bedWorksField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("E"));
                    respawnAnchorWorksField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("F"));
                    hasRaidsField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("G"));
                    minYField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("H"));
                    heightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("I"));
                    logicalHeightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("J"));
                    infiniburnField = InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_18_2) ? FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("K"), obj -> {
                        try {
                            return tagKeyGetMinecraftKeyMethod.invoke(obj, new Object[0]).toString();
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }) : FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("K"), obj -> obj.toString());
                    effectsLocationField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("L"), obj -> obj.toString());
                    ambientLightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("M"));
                    tagKeyGetMinecraftKeyMethod = infiniburnField.getField().getType().getMethod("b", new Class[0]);
                } else if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_17)) {
                    fixedTimeField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("u"));
                    hasSkylightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("v"));
                    hasCeilingField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("w"));
                    ultraWarmField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("x"));
                    naturalField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("y"));
                    coordinateScaleField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("z"));
                    createDragonFightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("A"));
                    piglinSafeField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("B"));
                    bedWorksField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("C"));
                    respawnAnchorWorksField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("D"));
                    hasRaidsField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("E"));
                    minYField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("F"));
                    heightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("G"));
                    logicalHeightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("H"));
                    infiniburnField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("J"), obj -> obj.toString());
                    effectsLocationField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("K"), obj -> obj.toString());
                    ambientLightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("L"));
                } else if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16)) {
                    fixedTimeField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("fixedTime"));
                    hasSkylightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("hasSkylight"));
                    hasCeilingField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("hasCeiling"));
                    ultraWarmField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("ultraWarm"));
                    naturalField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("natural"));
                    coordinateScaleField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("shrunk"));
                    createDragonFightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("createDragonBattle"));
                    piglinSafeField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("piglinSafe"));
                    bedWorksField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("bedWorks"));
                    respawnAnchorWorksField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("respawnAnchorWorks"));
                    hasRaidsField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("hasRaids"));
                    minYField = FieldAccessor.ofValue(0);
                    heightField = FieldAccessor.ofValue(256);
                    logicalHeightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("logicalHeight"));
                    infiniburnField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("infiniburn"), obj -> obj.toString());
                    effectsLocationField = InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16_2) ? FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("effects"), obj -> obj.toString()) : FieldAccessor.ofValue("");
                    ambientLightField = FieldAccessor.fromField(dimensionManagerClass.getDeclaredField("ambientLight"));
                }
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
    }
}

