/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.utils.MCVersion;
import com.loohp.interactivechat.utils.NMSUtils;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.BiomePrecipitation;
import com.loohp.interactivechatdiscordsrvaddon.wrappers.DimensionManagerWrapper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Location;
import org.bukkit.World;

public class WorldUtils {
    private static Class<?> craftWorldClass;
    private static Method getHandleMethod;
    private static Class<?> worldServerClass;
    private static Method getWorldTypeKeyMethod;
    private static Method getMinecraftKeyMethod;
    private static Method getBiomeAtMethod;
    private static Method holderGetMethod;
    private static Method getPrecipitationMethod;

    public static String getNamespacedKey(World world) {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16)) {
            try {
                Object craftWorldObject = craftWorldClass.cast(world);
                Object nmsWorldServerObject = getHandleMethod.invoke(craftWorldObject, new Object[0]);
                Object nmsResourceKeyObject = getWorldTypeKeyMethod.invoke(nmsWorldServerObject, new Object[0]);
                return getMinecraftKeyMethod.invoke(nmsResourceKeyObject, new Object[0]).toString();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            if (world.getEnvironment().equals((Object)World.Environment.NORMAL)) {
                return "minecraft:overworld";
            }
            if (world.getEnvironment().equals((Object)World.Environment.NETHER)) {
                return "minecraft:the_nether";
            }
            if (world.getEnvironment().equals((Object)World.Environment.THE_END)) {
                return "minecraft:the_end";
            }
            return "minecraft:custom";
        }
        return null;
    }

    public static boolean isNatural(World world) {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_19)) {
            return world.isNatural();
        }
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16)) {
            return new DimensionManagerWrapper(world).natural();
        }
        return world.getEnvironment().equals((Object)World.Environment.NORMAL);
    }

    public static BiomePrecipitation getPrecipitation(Location location) {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16)) {
            try {
                Object craftWorldObject = craftWorldClass.cast(location.getWorld());
                Object nmsWorldServerObject = getHandleMethod.invoke(craftWorldObject, new Object[0]);
                Object biomeBaseObject = getBiomeAtMethod.invoke(nmsWorldServerObject, location.getBlockX(), location.getBlockY(), location.getBlockZ());
                if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_18)) {
                    biomeBaseObject = holderGetMethod.invoke(biomeBaseObject, new Object[0]);
                }
                return BiomePrecipitation.fromName(((Enum)getPrecipitationMethod.invoke(biomeBaseObject, new Object[0])).name());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            double temperature = location.getWorld().getTemperature(location.getBlockX(), location.getBlockZ());
            if (temperature > 0.95) {
                return BiomePrecipitation.NONE;
            }
            if (temperature < 0.15) {
                return BiomePrecipitation.SNOW;
            }
            return BiomePrecipitation.RAIN;
        }
        return null;
    }

    static {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16)) {
            try {
                Class<?> biomeBaseClass;
                craftWorldClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.CraftWorld", (String[])new String[0]);
                getHandleMethod = craftWorldClass.getMethod("getHandle", new Class[0]);
                worldServerClass = getHandleMethod.getReturnType();
                getWorldTypeKeyMethod = worldServerClass.getMethod("getTypeKey", new Class[0]);
                getMinecraftKeyMethod = getWorldTypeKeyMethod.getReturnType().getMethod("a", new Class[0]);
                getBiomeAtMethod = worldServerClass.getMethod("a", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_18)) {
                    holderGetMethod = getBiomeAtMethod.getReturnType().getMethod("a", new Class[0]);
                    biomeBaseClass = Class.forName("net.minecraft.world.level.biome.BiomeBase");
                } else {
                    biomeBaseClass = getBiomeAtMethod.getReturnType();
                }
                getPrecipitationMethod = InteractiveChat.version.isOlderThan(MCVersion.V1_17) ? biomeBaseClass.getMethod("d", new Class[0]) : biomeBaseClass.getMethod("c", new Class[0]);
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
        }
    }
}

