/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.utils.ThrowingSupplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.regex.Pattern;

public class URLRequestUtils {
    public static final Pattern IMAGE_URL_PATTERN = Pattern.compile("https?:/(?:/[^/]+?)+\\.(gif\\.png|jpg|jpeg|gif|png|apng)(?:\\?.*)*");

    public static InputStream getInputStream(String link) throws IOException {
        InputStream stream = URLRequestUtils.getInputStream0(link);
        return stream == null ? new ByteArrayInputStream(new byte[0]) : stream;
    }

    public static InputStream getInputStream0(String link) throws IOException {
        URLConnection connection = new URL(link).openConnection();
        connection.setUseCaches(false);
        connection.setDefaultUseCaches(false);
        connection.addRequestProperty("User-Agent", "Mozilla/5.0");
        connection.addRequestProperty("Cache-Control", "no-cache, no-store, must-revalidate");
        connection.addRequestProperty("Pragma", "no-cache");
        return connection.getInputStream();
    }

    public static InputStream retrieveInputStreamUntilSuccessful(List<ThrowingSupplier<InputStream>> sources) {
        InputStream stream = null;
        boolean success = false;
        for (int i = 0; !success && i < sources.size(); ++i) {
            try {
                stream = sources.get(i).get();
                if (stream == null) continue;
                success = true;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return stream;
    }

    public static boolean isAllowed(String url) {
        if (!InteractiveChatDiscordSrvAddon.plugin.imageWhitelistEnabled) {
            return true;
        }
        for (String possiblyAllowedUrl : InteractiveChatDiscordSrvAddon.plugin.whitelistedImageUrls) {
            if (!url.startsWith(possiblyAllowedUrl)) continue;
            return true;
        }
        return false;
    }
}

