/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechat.libs.io.github.bananapuncher714.nbteditor.NBTEditor;
import com.loohp.interactivechat.libs.org.apache.commons.text.WordUtils;
import com.loohp.interactivechat.utils.MCVersion;
import com.loohp.interactivechat.utils.NMSUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackType;
import com.loohp.interactivechatdiscordsrvaddon.utils.FishUtils;
import com.loohp.interactivechatdiscordsrvaddon.wrappers.PatternTypeWrapper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.potion.PotionEffectType;

public class TranslationKeyUtils {
    private static Method bukkitEnchantmentGetIdMethod;
    private static Class<?> nmsEnchantmentClass;
    private static Method getEnchantmentByIdMethod;
    private static Method getEnchantmentKeyMethod;
    private static Class<?> nmsMobEffectListClass;
    private static Field nmsMobEffectByIdField;
    private static Method getEffectFromIdMethod;
    private static Method getEffectKeyMethod;
    private static Class<?> craftItemStackClass;
    private static Class<?> nmsItemStackClass;
    private static Method asNMSCopyMethod;
    private static Method nmsGetItemMethod;
    private static Class<?> nmsItemRecordClass;
    private static Field nmsItemRecordTranslationKeyField;

    public static String getOldIncompatiblePack() {
        if (InteractiveChat.version.isLegacy()) {
            return "resourcePack.incompatible.old";
        }
        return "pack.incompatible.old";
    }

    public static String getNewIncompatiblePack() {
        if (InteractiveChat.version.isLegacy()) {
            return "resourcePack.incompatible.new";
        }
        return "pack.incompatible.new";
    }

    public static String getServerResourcePack() {
        return "addServer.resourcePack";
    }

    public static String getServerResourcePackType(ResourcePackType type) {
        if (InteractiveChat.version.isLegacy()) {
            switch (type) {
                case BUILT_IN: {
                    return "built-in";
                }
                case WORLD: {
                    return "world";
                }
                case LOCAL: {
                    return "local";
                }
                case SERVER: {
                    return "server";
                }
            }
        } else {
            switch (type) {
                case BUILT_IN: {
                    return "pack.source.builtin";
                }
                case WORLD: {
                    return "pack.source.world";
                }
                case LOCAL: {
                    return "pack.source.local";
                }
                case SERVER: {
                    return "pack.source.server";
                }
            }
        }
        return "";
    }

    public static String getWorldSpecificResources() {
        if (InteractiveChat.version.isLegacy()) {
            return "addServer.resourcePack";
        }
        return "resourcePack.server.name";
    }

    public static String getFilledMapId() {
        return "filled_map.id";
    }

    public static String getFilledMapScale() {
        return "filled_map.scale";
    }

    public static String getFilledMapLevel() {
        return "filled_map.level";
    }

    public static String getNoEffect() {
        return "effect.none";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getEffect(PotionEffectType type) {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_18)) {
            NamespacedKey namespacedKey = type.getKey();
            return "effect." + namespacedKey.getNamespace() + "." + namespacedKey.getKey();
        }
        if (!InteractiveChat.version.isLegacy()) {
            try {
                int id = type.getId();
                Object nmsMobEffectListObject = getEffectFromIdMethod.invoke(null, id);
                if (nmsMobEffectListObject == null) return "";
                return getEffectKeyMethod.invoke(nmsMobEffectListObject, new Object[0]).toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return "";
            }
        }
        try {
            Object nmsMobEffectListObject;
            int id = type.getId();
            if (InteractiveChat.version.isOlderOrEqualTo(MCVersion.V1_8_4)) {
                Object nmsMobEffectListArray = nmsMobEffectByIdField.get(null);
                if (Array.getLength(nmsMobEffectListArray) <= id) return "";
                nmsMobEffectListObject = Array.get(nmsMobEffectListArray, id);
            } else {
                nmsMobEffectListObject = getEffectFromIdMethod.invoke(null, id);
            }
            if (nmsMobEffectListObject == null) return "";
            String str = getEffectKeyMethod.invoke(nmsMobEffectListObject, new Object[0]).toString();
            return "effect." + str.substring(str.indexOf(".") + 1);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getEffectLevel(int level) {
        return "potion.potency." + level;
    }

    public static String getPotionWhenDrunk() {
        return "potion.whenDrank";
    }

    public static String getPotionWithAmplifier() {
        return "potion.withAmplifier";
    }

    public static String getPotionWithDuration() {
        return "potion.withDuration";
    }

    public static String getEnchantment(Enchantment enchantment) {
        if (!InteractiveChat.version.isLegacy()) {
            NamespacedKey namespacedKey = enchantment.getKey();
            return "enchantment." + namespacedKey.getNamespace() + "." + namespacedKey.getKey();
        }
        try {
            Object nmsEnchantmentObject = getEnchantmentByIdMethod.invoke(null, bukkitEnchantmentGetIdMethod.invoke((Object)enchantment, new Object[0]));
            if (nmsEnchantmentObject != null) {
                return getEnchantmentKeyMethod.invoke(nmsEnchantmentObject, new Object[0]).toString();
            }
            return "";
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getEnchantmentLevel(int level) {
        return "enchantment.level." + level;
    }

    public static String getDyeColor() {
        return "item.color";
    }

    public static String getUnbreakable() {
        return "item.unbreakable";
    }

    public static String getDurability() {
        return "item.durability";
    }

    public static String getCrossbowProjectile() {
        return "item.minecraft.crossbow.projectile";
    }

    public static String getCopyToClipboard() {
        return "chat.copy";
    }

    public static String getOpenUrl() {
        return "chat.link.open";
    }

    public static String getRocketFlightDuration() {
        if (InteractiveChat.version.isLegacy()) {
            return "item.fireworks.flight";
        }
        return "item.minecraft.firework_rocket.flight";
    }

    public static String getLevelTranslation(int level) {
        if (level == 1) {
            return "container.enchant.level.one";
        }
        return "container.enchant.level.many";
    }

    public static String getMusicDiscName(ItemStack disc) {
        if (InteractiveChat.version.isLegacy()) {
            try {
                Object nmsItemStackObject = asNMSCopyMethod.invoke(null, disc);
                Object nmsItemObject = nmsGetItemMethod.invoke(nmsItemStackObject, new Object[0]);
                Object nmsItemRecordObject = nmsItemRecordClass.cast(nmsItemObject);
                nmsItemRecordTranslationKeyField.setAccessible(true);
                if (InteractiveChat.version.isOld()) {
                    return "item.record." + nmsItemRecordTranslationKeyField.get(nmsItemRecordObject).toString() + ".desc";
                }
                return nmsItemRecordTranslationKeyField.get(nmsItemRecordObject).toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return "";
            }
        }
        NamespacedKey namespacedKey = disc.getType().getKey();
        return "item." + namespacedKey.getNamespace() + "." + namespacedKey.getKey() + ".desc";
    }

    public static String getDiscFragmentName(ItemStack fragment) {
        NamespacedKey namespacedKey = fragment.getType().getKey();
        return "item." + namespacedKey.getNamespace() + "." + namespacedKey.getKey() + ".desc";
    }

    public static String getBannerPatternItemName(XMaterial material) {
        return "item.minecraft." + material.name().toLowerCase() + ".desc";
    }

    public static List<String> getTropicalFishBucketName(ItemStack bucket) {
        ArrayList<String> list = new ArrayList<String>();
        if (!InteractiveChat.version.isLegacy() && NBTEditor.contains((Object)bucket, (Object[])new Object[]{"BucketVariantTag"})) {
            int variance = NBTEditor.getInt((Object)bucket, (Object[])new Object[]{"BucketVariantTag"});
            int predefinedType = FishUtils.getPredefinedType(variance);
            if (predefinedType >= 0) {
                list.add("entity.minecraft.tropical_fish.predefined." + predefinedType);
            } else {
                DyeColor baseColor = FishUtils.getTropicalFishBaseColor(variance);
                DyeColor patternColor = FishUtils.getTropicalFishPatternColor(variance);
                list.add("entity.minecraft.tropical_fish.type." + FishUtils.getTropicalFishTypeName(variance));
                list.add("color.minecraft." + baseColor.toString().toLowerCase());
                if (!baseColor.equals((Object)patternColor)) {
                    list.add("color.minecraft." + patternColor.toString().toLowerCase());
                }
            }
        }
        return list;
    }

    public static String getBannerPatternName(PatternTypeWrapper type, DyeColor color) {
        if (InteractiveChat.version.isLegacy()) {
            String colorName = WordUtils.capitalizeFully((String)color.name().toLowerCase().replace("_", " ")).replace(" ", "");
            colorName = colorName.substring(0, 1).toLowerCase() + colorName.substring(1);
            return "item.banner." + type.getAssetName() + "." + colorName;
        }
        return "block.minecraft.banner." + type.getAssetName() + "." + color.name().toLowerCase();
    }

    public static String getAttributeKey(String attributeName) {
        return "attribute.name." + attributeName;
    }

    public static String getAttributeModifierKey(double amount, int operation) {
        if (amount > 0.0) {
            return "attribute.modifier.plus." + operation;
        }
        if (amount < 0.0) {
            return "attribute.modifier.take." + operation;
        }
        return "attribute.modifier.equals." + operation;
    }

    public static String getModifierSlotKey(EquipmentSlot slot) {
        switch (slot) {
            case HEAD: {
                return "item.modifiers.head";
            }
            case CHEST: {
                return "item.modifiers.chest";
            }
            case LEGS: {
                return "item.modifiers.legs";
            }
            case FEET: {
                return "item.modifiers.feet";
            }
            case HAND: {
                return "item.modifiers.mainhand";
            }
            case OFF_HAND: {
                return "item.modifiers.offhand";
            }
        }
        return "item.modifiers." + slot.toString().toLowerCase();
    }

    public static String getCanDestroy() {
        return "item.canBreak";
    }

    public static String getCanPlace() {
        return "item.canPlace";
    }

    public static String getBookAuthor() {
        return "book.byAuthor";
    }

    public static String getBookGeneration(BookMeta.Generation generation) {
        switch (generation) {
            case COPY_OF_ORIGINAL: {
                return "book.generation.1";
            }
            case COPY_OF_COPY: {
                return "book.generation.2";
            }
            case TATTERED: {
                return "book.generation.3";
            }
        }
        return "book.generation.0";
    }

    public static String getBookPageIndicator() {
        return "book.pageIndicator";
    }

    public static String getDefaultContainerTitle() {
        return "container.inventory";
    }

    public static String getEnderChestContainerTitle() {
        return "container.enderchest";
    }

    public static String getBundleFullness() {
        return "item.minecraft.bundle.fullness";
    }

    public static String getFireworkType(FireworkEffect.Type type) {
        if (InteractiveChat.version.isLegacy()) {
            switch (type) {
                case BALL: {
                    return "item.fireworksCharge.type.0";
                }
                case BALL_LARGE: {
                    return "item.fireworksCharge.type.1";
                }
                case STAR: {
                    return "item.fireworksCharge.type.2";
                }
                case CREEPER: {
                    return "item.fireworksCharge.type.3";
                }
                case BURST: {
                    return "item.fireworksCharge.type.4";
                }
            }
            return "item.fireworksCharge.type";
        }
        switch (type) {
            case BALL: {
                return "item.minecraft.firework_star.shape.small_ball";
            }
            case BALL_LARGE: {
                return "item.minecraft.firework_star.shape.large_ball";
            }
            case STAR: {
                return "item.minecraft.firework_star.shape.star";
            }
            case CREEPER: {
                return "item.minecraft.firework_star.shape.creeper";
            }
            case BURST: {
                return "item.minecraft.firework_star.shape.burst";
            }
        }
        return "item.minecraft.firework_star.shape";
    }

    public static String getFireworkTrail() {
        if (InteractiveChat.version.isLegacy()) {
            return "item.fireworksCharge.trail";
        }
        return "item.minecraft.firework_star.trail";
    }

    public static String getFireworkFlicker() {
        if (InteractiveChat.version.isLegacy()) {
            return "item.fireworksCharge.flicker";
        }
        return "item.minecraft.firework_star.flicker";
    }

    public static String getFireworkFade() {
        if (InteractiveChat.version.isLegacy()) {
            return "item.fireworksCharge.fadeTo";
        }
        return "item.minecraft.firework_star.fade_to";
    }

    public static String getFireworkColor(Color color) {
        DyeColor dyeColor = DyeColor.getByFireworkColor((Color)color);
        if (InteractiveChat.version.isLegacy()) {
            if (dyeColor == null) {
                return "item.fireworksCharge.customColor";
            }
            String colorName = WordUtils.capitalizeFully((String)dyeColor.name().toLowerCase().replace("_", " ")).replace(" ", "");
            colorName = colorName.substring(0, 1).toLowerCase() + colorName.substring(1);
            return "item.fireworksCharge." + colorName;
        }
        if (dyeColor == null) {
            return "item.minecraft.firework_star.custom_color";
        }
        return "item.minecraft.firework_star." + dyeColor.name().toLowerCase();
    }

    public static String getGoatHornInstrument(NamespacedKey instrument) {
        return "instrument." + instrument.getNamespace() + "." + instrument.getKey();
    }

    static {
        if (InteractiveChat.version.isLegacy()) {
            try {
                bukkitEnchantmentGetIdMethod = Enchantment.class.getMethod("getId", new Class[0]);
                nmsEnchantmentClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.Enchantment", (String[])new String[]{"net.minecraft.world.item.enchantment.Enchantment"});
                getEnchantmentByIdMethod = InteractiveChat.version.isOld() ? nmsEnchantmentClass.getMethod("getById", Integer.TYPE) : nmsEnchantmentClass.getMethod("c", Integer.TYPE);
                getEnchantmentKeyMethod = nmsEnchantmentClass.getMethod("a", new Class[0]);
                nmsMobEffectListClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.MobEffectList", (String[])new String[]{"net.minecraft.world.effect.MobEffectList"});
                if (InteractiveChat.version.isOld()) {
                    nmsMobEffectByIdField = nmsMobEffectListClass.getField("byId");
                } else {
                    getEffectFromIdMethod = nmsMobEffectListClass.getMethod("fromId", Integer.TYPE);
                }
                getEffectKeyMethod = nmsMobEffectListClass.getMethod("a", new Class[0]);
                nmsItemRecordClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.ItemRecord", (String[])new String[]{"net.minecraft.world.item.ItemRecord"});
                nmsItemRecordTranslationKeyField = (Field)NMSUtils.reflectiveLookup(Field.class, () -> nmsItemRecordClass.getDeclaredField("c"), (NMSUtils.ReflectionLookupSupplier[])new NMSUtils.ReflectionLookupSupplier[]{() -> nmsItemRecordClass.getDeclaredField("a")});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (InteractiveChat.version.isOlderOrEqualTo(MCVersion.V1_17)) {
                    nmsMobEffectListClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.MobEffectList", (String[])new String[]{"net.minecraft.world.effect.MobEffectList"});
                    getEffectFromIdMethod = (Method)NMSUtils.reflectiveLookup(Method.class, () -> nmsMobEffectListClass.getMethod("fromId", Integer.TYPE), (NMSUtils.ReflectionLookupSupplier[])new NMSUtils.ReflectionLookupSupplier[]{() -> nmsMobEffectListClass.getMethod("byId", Integer.TYPE)});
                    getEffectKeyMethod = InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_19) ? nmsMobEffectListClass.getMethod("d", new Class[0]) : nmsMobEffectListClass.getMethod("c", new Class[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            craftItemStackClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.inventory.CraftItemStack", (String[])new String[0]);
            nmsItemStackClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.ItemStack", (String[])new String[]{"net.minecraft.world.item.ItemStack"});
            asNMSCopyMethod = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class);
            nmsGetItemMethod = (Method)NMSUtils.reflectiveLookup(Method.class, () -> nmsItemStackClass.getMethod("getItem", new Class[0]), (NMSUtils.ReflectionLookupSupplier[])new NMSUtils.ReflectionLookupSupplier[]{() -> nmsItemStackClass.getMethod("c", new Class[0])});
        }
        catch (ReflectiveOperationException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

