/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntSupplier;
import java.util.stream.IntStream;

public class TintUtils {
    public static final float DEFAULT_TEMPERATURE = 0.8f;
    public static final float DEFAULT_DOWNFALL = 0.4f;
    public static final float DEFAULT2_TEMPERATURE = 0.5f;
    public static final float DEFAULT2_DOWNFALL = 1.0f;
    public static final int FOLIAGE_SPRUCE_COLOR = 0x619961;
    public static final int FOLIAGE_BIRCH_COLOR = 8431445;
    public static final int FOLIAGE_MANGROVE_COLOR = 9619016;
    public static final int FOLIAGE_DEFAULT_COLOR = 4764952;
    public static final int LILY_PAD_COLOR = 2129968;
    private static final Map<String, TintIndexData> TINT_DATA = new HashMap<String, TintIndexData>();
    private static final Map<String, SpawnEggTintData> SPAWN_EGG_TINT_DATA = new HashMap<String, SpawnEggTintData>();
    private static int[] GRASS_TINT_PIXELS = new int[65536];
    private static int[] FOLIAGE_TINT_PIXELS = new int[65536];

    public static void setGrassAndFoliageColorMap(int[] grassColorMap, int[] foliageColorMap) {
        GRASS_TINT_PIXELS = grassColorMap;
        FOLIAGE_TINT_PIXELS = foliageColorMap;
    }

    public static TintIndexData getTintData(String material) {
        return TINT_DATA.getOrDefault(material.toUpperCase(), TintIndexData.EMPTY_INSTANCE);
    }

    public static TintIndexData getTintData(XMaterial material) {
        return TINT_DATA.getOrDefault(material.name(), TintIndexData.EMPTY_INSTANCE);
    }

    public static SpawnEggTintData getSpawnEggTint(String spawnEgg) {
        return SPAWN_EGG_TINT_DATA.get(spawnEgg.toUpperCase());
    }

    public static SpawnEggTintData getSpawnEggTint(XMaterial spawnEgg) {
        return SPAWN_EGG_TINT_DATA.get(spawnEgg.name());
    }

    public static int getGrassTintColor(float temperature, float downfall) {
        double d0 = Math.max(0.0, Math.min(1.0, (double)temperature));
        double d1 = Math.max(0.0, Math.min(1.0, (double)downfall));
        int j = (int)((1.0 - (d1 *= d0)) * 255.0);
        int i = (int)((1.0 - d0) * 255.0);
        int k = j << 8 | i;
        return k >= GRASS_TINT_PIXELS.length ? -65281 : GRASS_TINT_PIXELS[k];
    }

    public static int getFoliageTintColor(float temperature, float downfall) {
        double d0 = Math.max(0.0, Math.min(1.0, (double)temperature));
        double d1 = Math.max(0.0, Math.min(1.0, (double)downfall));
        int j = (int)((1.0 - (d1 *= d0)) * 255.0);
        int i = (int)((1.0 - d0) * 255.0);
        int k = j << 8 | i;
        return k >= FOLIAGE_TINT_PIXELS.length ? 4764952 : FOLIAGE_TINT_PIXELS[k];
    }

    static {
        TintIndexData grassTint = new TintIndexData(Collections.singletonList(() -> TintUtils.getGrassTintColor(0.8f, 0.4f)));
        TINT_DATA.put("GRASS_BLOCK", grassTint);
        TINT_DATA.put("GRASS", grassTint);
        TINT_DATA.put("LARGE_FERN", grassTint);
        TINT_DATA.put("POTTED_FERN", grassTint);
        TINT_DATA.put("SUGAR_CANE", grassTint);
        TintIndexData grassTint2 = new TintIndexData(Collections.singletonList(() -> TintUtils.getGrassTintColor(0.5f, 1.0f)));
        TINT_DATA.put("TALL_GRASS", grassTint2);
        TINT_DATA.put("FERN", grassTint2);
        TintIndexData foliageTint = new TintIndexData(Collections.singletonList(() -> TintUtils.getFoliageTintColor(0.8f, 0.4f)));
        TINT_DATA.put("OAK_LEAVES", foliageTint);
        TINT_DATA.put("JUNGLE_LEAVES", foliageTint);
        TINT_DATA.put("ACACIA_LEAVES", foliageTint);
        TINT_DATA.put("DARK_OAK_LEAVES", foliageTint);
        TINT_DATA.put("VINE", foliageTint);
        TINT_DATA.put("BIRCH_LEAVES", new TintIndexData(Collections.singletonList(() -> 8431445)));
        TINT_DATA.put("SPRUCE_LEAVES", new TintIndexData(Collections.singletonList(() -> 0x619961)));
        TINT_DATA.put("MANGROVE_LEAVES", new TintIndexData(Collections.singletonList(() -> 9619016)));
        TINT_DATA.put("LILY_PAD", new TintIndexData(Collections.singletonList(() -> 2129968)));
        SPAWN_EGG_TINT_DATA.put("ALLAY_SPAWN_EGG", new SpawnEggTintData(56063, 44543));
        SPAWN_EGG_TINT_DATA.put("AXOLOTL_SPAWN_EGG", new SpawnEggTintData(16499171, 10890612));
        SPAWN_EGG_TINT_DATA.put("BAT_SPAWN_EGG", new SpawnEggTintData(4996656, 986895));
        SPAWN_EGG_TINT_DATA.put("BEE_SPAWN_EGG", new SpawnEggTintData(15582019, 4400155));
        SPAWN_EGG_TINT_DATA.put("BLAZE_SPAWN_EGG", new SpawnEggTintData(16167425, 16775294));
        SPAWN_EGG_TINT_DATA.put("CAT_SPAWN_EGG", new SpawnEggTintData(15714446, 9794134));
        SPAWN_EGG_TINT_DATA.put("CAVE_SPIDER_SPAWN_EGG", new SpawnEggTintData(803406, 11013646));
        SPAWN_EGG_TINT_DATA.put("CHICKEN_SPAWN_EGG", new SpawnEggTintData(0xA1A1A1, 0xFF0000));
        SPAWN_EGG_TINT_DATA.put("COD_SPAWN_EGG", new SpawnEggTintData(12691306, 15058059));
        SPAWN_EGG_TINT_DATA.put("COW_SPAWN_EGG", new SpawnEggTintData(4470310, 0xA1A1A1));
        SPAWN_EGG_TINT_DATA.put("CREEPER_SPAWN_EGG", new SpawnEggTintData(894731, 0));
        SPAWN_EGG_TINT_DATA.put("DOLPHIN_SPAWN_EGG", new SpawnEggTintData(2243405, 0xF9F9F9));
        SPAWN_EGG_TINT_DATA.put("DONKEY_SPAWN_EGG", new SpawnEggTintData(5457209, 8811878));
        SPAWN_EGG_TINT_DATA.put("DROWNED_SPAWN_EGG", new SpawnEggTintData(9433559, 7969893));
        SPAWN_EGG_TINT_DATA.put("ELDER_GUARDIAN_SPAWN_EGG", new SpawnEggTintData(13552826, 7632531));
        SPAWN_EGG_TINT_DATA.put("ENDERMAN_SPAWN_EGG", new SpawnEggTintData(0x161616, 0));
        SPAWN_EGG_TINT_DATA.put("ENDERMITE_SPAWN_EGG", new SpawnEggTintData(0x161616, 0x6E6E6E));
        SPAWN_EGG_TINT_DATA.put("EVOKER_SPAWN_EGG", new SpawnEggTintData(0x959B9B, 1973274));
        SPAWN_EGG_TINT_DATA.put("FOX_SPAWN_EGG", new SpawnEggTintData(14005919, 13396256));
        SPAWN_EGG_TINT_DATA.put("FROG_SPAWN_EGG", new SpawnEggTintData(13661252, 0xFFC77C));
        SPAWN_EGG_TINT_DATA.put("GHAST_SPAWN_EGG", new SpawnEggTintData(0xF9F9F9, 0xBCBCBC));
        SPAWN_EGG_TINT_DATA.put("GLOW_SQUID_SPAWN_EGG", new SpawnEggTintData(611926, 8778172));
        SPAWN_EGG_TINT_DATA.put("GOAT_SPAWN_EGG", new SpawnEggTintData(10851452, 5589310));
        SPAWN_EGG_TINT_DATA.put("GUARDIAN_SPAWN_EGG", new SpawnEggTintData(5931634, 15826224));
        SPAWN_EGG_TINT_DATA.put("HOGLIN_SPAWN_EGG", new SpawnEggTintData(13004373, 6251620));
        SPAWN_EGG_TINT_DATA.put("HORSE_SPAWN_EGG", new SpawnEggTintData(12623485, 0xEEE500));
        SPAWN_EGG_TINT_DATA.put("HUSK_SPAWN_EGG", new SpawnEggTintData(7958625, 15125652));
        SPAWN_EGG_TINT_DATA.put("LLAMA_SPAWN_EGG", new SpawnEggTintData(12623485, 10051392));
        SPAWN_EGG_TINT_DATA.put("MAGMA_CUBE_SPAWN_EGG", new SpawnEggTintData(0x340000, 0xFCFC00));
        SPAWN_EGG_TINT_DATA.put("MOOSHROOM_SPAWN_EGG", new SpawnEggTintData(10489616, 0xB7B7B7));
        SPAWN_EGG_TINT_DATA.put("MULE_SPAWN_EGG", new SpawnEggTintData(1769984, 5321501));
        SPAWN_EGG_TINT_DATA.put("OCELOT_SPAWN_EGG", new SpawnEggTintData(15720061, 5653556));
        SPAWN_EGG_TINT_DATA.put("PANDA_SPAWN_EGG", new SpawnEggTintData(0xE7E7E7, 0x1B1B22));
        SPAWN_EGG_TINT_DATA.put("PARROT_SPAWN_EGG", new SpawnEggTintData(894731, 0xFF0000));
        SPAWN_EGG_TINT_DATA.put("PHANTOM_SPAWN_EGG", new SpawnEggTintData(4411786, 0x88FF00));
        SPAWN_EGG_TINT_DATA.put("PIG_SPAWN_EGG", new SpawnEggTintData(15771042, 14377823));
        SPAWN_EGG_TINT_DATA.put("PIGLIN_SPAWN_EGG", new SpawnEggTintData(10051392, 16380836));
        SPAWN_EGG_TINT_DATA.put("PIGLIN_BRUTE_SPAWN_EGG", new SpawnEggTintData(5843472, 16380836));
        SPAWN_EGG_TINT_DATA.put("PILLAGER_SPAWN_EGG", new SpawnEggTintData(5451574, 0x959B9B));
        SPAWN_EGG_TINT_DATA.put("POLAR_BEAR_SPAWN_EGG", new SpawnEggTintData(0xF2F2F2, 0x959590));
        SPAWN_EGG_TINT_DATA.put("PUFFERFISH_SPAWN_EGG", new SpawnEggTintData(16167425, 3654642));
        SPAWN_EGG_TINT_DATA.put("RABBIT_SPAWN_EGG", new SpawnEggTintData(10051392, 7555121));
        SPAWN_EGG_TINT_DATA.put("RAVAGER_SPAWN_EGG", new SpawnEggTintData(7697520, 5984329));
        SPAWN_EGG_TINT_DATA.put("SALMON_SPAWN_EGG", new SpawnEggTintData(10489616, 951412));
        SPAWN_EGG_TINT_DATA.put("SHEEP_SPAWN_EGG", new SpawnEggTintData(0xE7E7E7, 0xFFB5B5));
        SPAWN_EGG_TINT_DATA.put("SHULKER_SPAWN_EGG", new SpawnEggTintData(9725844, 5060690));
        SPAWN_EGG_TINT_DATA.put("SILVERFISH_SPAWN_EGG", new SpawnEggTintData(0x6E6E6E, 0x303030));
        SPAWN_EGG_TINT_DATA.put("SKELETON_SPAWN_EGG", new SpawnEggTintData(0xC1C1C1, 0x494949));
        SPAWN_EGG_TINT_DATA.put("SKELETON_HORSE_SPAWN_EGG", new SpawnEggTintData(6842447, 15066584));
        SPAWN_EGG_TINT_DATA.put("SLIME_SPAWN_EGG", new SpawnEggTintData(5349438, 8306542));
        SPAWN_EGG_TINT_DATA.put("SPIDER_SPAWN_EGG", new SpawnEggTintData(3419431, 11013646));
        SPAWN_EGG_TINT_DATA.put("SQUID_SPAWN_EGG", new SpawnEggTintData(2243405, 7375001));
        SPAWN_EGG_TINT_DATA.put("STRAY_SPAWN_EGG", new SpawnEggTintData(0x617677, 0xDDEAEA));
        SPAWN_EGG_TINT_DATA.put("STRIDER_SPAWN_EGG", new SpawnEggTintData(10236982, 0x4D494D));
        SPAWN_EGG_TINT_DATA.put("TADPOLE_SPAWN_EGG", new SpawnEggTintData(7164733, 1444352));
        SPAWN_EGG_TINT_DATA.put("TRADER_LLAMA_SPAWN_EGG", new SpawnEggTintData(15377456, 4547222));
        SPAWN_EGG_TINT_DATA.put("TROPICAL_FISH_SPAWN_EGG", new SpawnEggTintData(15690005, 0xFFF9EF));
        SPAWN_EGG_TINT_DATA.put("TURTLE_SPAWN_EGG", new SpawnEggTintData(0xE7E7E7, 44975));
        SPAWN_EGG_TINT_DATA.put("VEX_SPAWN_EGG", new SpawnEggTintData(8032420, 15265265));
        SPAWN_EGG_TINT_DATA.put("VILLAGER_SPAWN_EGG", new SpawnEggTintData(5651507, 12422002));
        SPAWN_EGG_TINT_DATA.put("VINDICATOR_SPAWN_EGG", new SpawnEggTintData(0x959B9B, 2580065));
        SPAWN_EGG_TINT_DATA.put("WANDERING_TRADER_SPAWN_EGG", new SpawnEggTintData(4547222, 15377456));
        SPAWN_EGG_TINT_DATA.put("WARDEN_SPAWN_EGG", new SpawnEggTintData(1001033, 3790560));
        SPAWN_EGG_TINT_DATA.put("WITCH_SPAWN_EGG", new SpawnEggTintData(0x340000, 5349438));
        SPAWN_EGG_TINT_DATA.put("WITHER_SKELETON_SPAWN_EGG", new SpawnEggTintData(0x141414, 0x474D4D));
        SPAWN_EGG_TINT_DATA.put("WOLF_SPAWN_EGG", new SpawnEggTintData(0xD7D3D3, 13545366));
        SPAWN_EGG_TINT_DATA.put("ZOGLIN_SPAWN_EGG", new SpawnEggTintData(13004373, 0xE6E6E6));
        SPAWN_EGG_TINT_DATA.put("ZOMBIE_SPAWN_EGG", new SpawnEggTintData(44975, 7969893));
        SPAWN_EGG_TINT_DATA.put("ZOMBIE_HORSE_SPAWN_EGG", new SpawnEggTintData(3232308, 9945732));
        SPAWN_EGG_TINT_DATA.put("ZOMBIE_VILLAGER_SPAWN_EGG", new SpawnEggTintData(5651507, 7969893));
        SPAWN_EGG_TINT_DATA.put("ZOMBIFIED_PIGLIN_SPAWN_EGG", new SpawnEggTintData(15373203, 5009705));
    }

    public static class TintIndexData {
        public static final TintIndexData EMPTY_INSTANCE = new TintIndexData(Collections.emptyList());
        private List<IntSupplier> data;

        public TintIndexData(List<IntSupplier> data) {
            this.data = data;
        }

        public BufferedImage applyTint(BufferedImage image, int tintIndex) {
            IntSupplier colorSupplier;
            if (tintIndex >= 0 && tintIndex < this.data.size() && (colorSupplier = this.data.get(tintIndex)) != null) {
                int color = colorSupplier.getAsInt();
                BufferedImage tintImage = ImageUtils.changeColorTo(ImageUtils.copyImage(image), color);
                return ImageUtils.multiply(image, tintImage);
            }
            return image;
        }

        public int getTintColor(int tintIndex) {
            IntSupplier colorSupplier;
            if (tintIndex >= 0 && tintIndex < this.data.size() && (colorSupplier = this.data.get(tintIndex)) != null) {
                return colorSupplier.getAsInt();
            }
            return 0xFFFFFF;
        }

        public int[] getAvailableTintIndexes() {
            return IntStream.range(0, this.data.size()).filter(i -> this.data.get(i) != null).toArray();
        }
    }

    public static class SpawnEggTintData {
        private int base;
        private int overlay;

        public SpawnEggTintData(int base, int overlay) {
            this.base = base;
            this.overlay = overlay;
        }

        public int getBase() {
            return this.base;
        }

        public int getOverlay() {
            return this.overlay;
        }
    }
}

