/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.utils.MCVersion;
import com.loohp.interactivechat.utils.NMSUtils;
import com.mojang.bridge.game.PackType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;

public class ResourcePackUtils {
    private static Class<?> craftServerClass;
    private static Method craftServerGetServerMethod;
    private static Method nmsGetResourcePackMethod;
    private static Method nmsGetResourcePackHashMethod;
    private static Class<?> nmsMinecraftVersionClass;
    private static Constructor<?> nmsMinecraftVersionConstructor;
    private static Method nmsMinecraftVersionGetPackVersionMethod;
    private static Object mojangPackTypeResourceEnumObject;
    private static Object nmsMinecraftVersionObject;

    public static String getServerResourcePack() {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_19)) {
            return Bukkit.getResourcePack();
        }
        try {
            Object craftServerObject = craftServerClass.cast(Bukkit.getServer());
            Object nmsMinecraftServerObject = craftServerGetServerMethod.invoke(craftServerObject, new Object[0]);
            Object resourcePackStringObject = nmsGetResourcePackMethod.invoke(nmsMinecraftServerObject, new Object[0]);
            return resourcePackStringObject == null ? "" : resourcePackStringObject.toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getServerResourcePackHash() {
        if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_19)) {
            return Bukkit.getResourcePackHash();
        }
        try {
            Object craftServerObject = craftServerClass.cast(Bukkit.getServer());
            Object nmsMinecraftServerObject = craftServerGetServerMethod.invoke(craftServerObject, new Object[0]);
            Object resourcePackStringObject = nmsGetResourcePackHashMethod.invoke(nmsMinecraftServerObject, new Object[0]);
            return resourcePackStringObject == null ? "" : resourcePackStringObject.toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getServerResourcePackVersion() {
        try {
            if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_15)) {
                if (mojangPackTypeResourceEnumObject == null) {
                    return (Integer)nmsMinecraftVersionGetPackVersionMethod.invoke(nmsMinecraftVersionObject, new Object[0]);
                }
                return (Integer)nmsMinecraftVersionGetPackVersionMethod.invoke(nmsMinecraftVersionObject, mojangPackTypeResourceEnumObject);
            }
            if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_13)) {
                return 4;
            }
            if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_11)) {
                return 3;
            }
            if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_9)) {
                return 2;
            }
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    static {
        try {
            if (InteractiveChat.version.isOlderThan(MCVersion.V1_19)) {
                craftServerClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.CraftServer", (String[])new String[0]);
                craftServerGetServerMethod = craftServerClass.getMethod("getServer", new Class[0]);
                nmsGetResourcePackMethod = (Method)NMSUtils.reflectiveLookup(Method.class, () -> craftServerGetServerMethod.getReturnType().getMethod("getResourcePack", new Class[0]), (NMSUtils.ReflectionLookupSupplier[])new NMSUtils.ReflectionLookupSupplier[]{() -> craftServerGetServerMethod.getReturnType().getMethod("S", new Class[0])});
                nmsGetResourcePackHashMethod = (Method)NMSUtils.reflectiveLookup(Method.class, () -> craftServerGetServerMethod.getReturnType().getMethod("getResourcePackHash", new Class[0]), (NMSUtils.ReflectionLookupSupplier[])new NMSUtils.ReflectionLookupSupplier[]{() -> craftServerGetServerMethod.getReturnType().getMethod("T", new Class[0])});
            }
            try {
                nmsMinecraftVersionClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.MinecraftVersion", (String[])new String[]{"net.minecraft.MinecraftVersion"});
                nmsMinecraftVersionConstructor = nmsMinecraftVersionClass.getDeclaredConstructor(new Class[0]);
                nmsMinecraftVersionConstructor.setAccessible(true);
                nmsMinecraftVersionObject = nmsMinecraftVersionConstructor.newInstance(new Object[0]);
                nmsMinecraftVersionGetPackVersionMethod = (Method)NMSUtils.reflectiveLookup(Method.class, () -> nmsMinecraftVersionClass.getMethod("getPackVersion", new Class[0]), (NMSUtils.ReflectionLookupSupplier[])new NMSUtils.ReflectionLookupSupplier[]{() -> {
                    mojangPackTypeResourceEnumObject = PackType.RESOURCE;
                    return nmsMinecraftVersionClass.getMethod("getPackVersion", PackType.class);
                }});
            }
            catch (Exception exception) {}
        }
        catch (ReflectiveOperationException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

