/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactivechat.utils.LanguageUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackInfo;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackType;
import com.loohp.interactivechatdiscordsrvaddon.utils.TranslationKeyUtils;

public class ResourcePackInfoUtils {
    public static String resolveName(ResourcePackInfo info) {
        return ResourcePackInfoUtils.resolveName(info.getName(), info.getType());
    }

    public static String resolveName(String name, ResourcePackType type) {
        switch (type) {
            case BUILT_IN: 
            case LOCAL: {
                return name;
            }
            case WORLD: 
            case SERVER: {
                return LanguageUtils.getTranslation((String)TranslationKeyUtils.getWorldSpecificResources(), (String)InteractiveChatDiscordSrvAddon.plugin.language);
            }
        }
        return name;
    }

    public static Component resolveDescription(ResourcePackInfo info) {
        return ResourcePackInfoUtils.resolveDescription(info.getDescription(), info.getType());
    }

    public static Component resolveDescription(Component component, ResourcePackType type) {
        String space = PlainTextComponentSerializer.plainText().serialize(component).isEmpty() ? "" : " ";
        switch (type) {
            case BUILT_IN: 
            case WORLD: 
            case SERVER: {
                component = component.append(((TextComponent)Component.empty().append(((TextComponent)Component.text((String)(space + "(")).append((Component)Component.translatable((String)TranslationKeyUtils.getServerResourcePackType(type)))).append((Component)Component.text((String)")")))).color((TextColor)NamedTextColor.GRAY));
            }
        }
        return component;
    }
}

