/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.io.github.bananapuncher714.nbteditor.NBTEditor;
import com.loohp.interactivechat.utils.MCVersion;
import com.loohp.interactivechat.utils.NMSUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class PotionUtils {
    public static final int WATER_COLOR = 3694022;
    public static final int UNCRAFTABLE_COLOR = 0xF800F8;
    private static Class<?> craftItemStackClass;
    private static Class<?> nmsItemStackClass;
    private static Class<?> nmsNbtTagCompoundClass;
    private static Class<?> craftPotionBrewerClass;
    private static Object craftPotionBrewerInstance;
    private static Method craftPotionBrewerGetEffectsFromDamageMethod;
    private static Class<?> nmsPotionRegistryClass;
    private static Method nmsPotionRegistryGetPotionRegistryFromStringMethod;
    private static Method nmsPotionRegistryGetMobEffectListMethod;
    private static Class<?> craftPotionUtilClass;
    private static Class<?> nmsMobEffectClass;
    private static Method craftPotionUtilToBukkitMethod;
    private static Method craftPotionUtilFromBukkitMethod;
    private static Class<?> nmsMobEffectListClass;
    private static Field nmsMobEffectListByIdArrayField;
    private static Method nmsMobEffectListByIdMethod;
    private static Field nmsMobEffectListTypeField;
    private static Field nmsMobEffectInfoChatFormatField;
    private static Method nmsMobEffectGetMobEffectListMethod;
    private static Field nmsMobEffectListAttributeMapField;
    private static Method nmsMobEffectGetAttributeModifierValueMethod;
    private static Class<?> nmsAttributeBaseClass;
    private static Method nmsAttributeBaseGetNameMethod;
    private static Class<?> nmsAttributeModifierClass;
    private static Class<?> craftAttributeInstanceClass;
    private static Method craftAttributeInstanceConvertMethod;

    public static int getPotionBaseColor(PotionType type) {
        PotionEffectType effect = type.getEffectType();
        if (effect == null) {
            if (type.name().equalsIgnoreCase("UNCRAFTABLE")) {
                return 0xF800F8;
            }
            return 3694022;
        }
        return effect.getColor().asRGB();
    }

    public static List<PotionEffect> getBasePotionEffect(ItemStack potion) throws Exception {
        Object reg;
        if (InteractiveChat.version.isOld()) {
            return new ArrayList<PotionEffect>((Collection)craftPotionBrewerGetEffectsFromDamageMethod.invoke(craftPotionBrewerInstance, potion.getDurability()));
        }
        if (!NBTEditor.contains((Object)potion, (Object[])new Object[]{"Potion"})) {
            return null;
        }
        String pName = NBTEditor.getString((Object)potion, (Object[])new Object[]{"Potion"});
        if (pName.contains(":")) {
            pName = pName.substring(pName.indexOf(":") + 1);
        }
        if ((reg = nmsPotionRegistryGetPotionRegistryFromStringMethod.invoke(null, pName)) == null) {
            return null;
        }
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (Object me : (List)nmsPotionRegistryGetMobEffectListMethod.invoke(reg, new Object[0])) {
            effects.add((PotionEffect)craftPotionUtilToBukkitMethod.invoke(null, me));
        }
        return effects;
    }

    public static ChatColor getPotionEffectChatColor(PotionEffectType type) throws Exception {
        int id = type.getId();
        if (InteractiveChat.version.isOld()) {
            Object array = nmsMobEffectListByIdArrayField.get(null);
            Object mobEffectListObject = Array.get(array, id);
            nmsMobEffectListTypeField.setAccessible(true);
            return nmsMobEffectListTypeField.getBoolean(mobEffectListObject) ? ChatColor.RED : ChatColor.BLUE;
        }
        if (InteractiveChat.version.isOlderOrEqualTo(MCVersion.V1_13_1)) {
            Object mobEffectListObject = nmsMobEffectListByIdMethod.invoke(null, id);
            nmsMobEffectListTypeField.setAccessible(true);
            return nmsMobEffectListTypeField.getBoolean(mobEffectListObject) ? ChatColor.RED : ChatColor.BLUE;
        }
        Object mobEffectListObject = nmsMobEffectListByIdMethod.invoke(null, id);
        nmsMobEffectListTypeField.setAccessible(true);
        Enum mobEffectType = (Enum)nmsMobEffectListTypeField.get(mobEffectListObject);
        nmsMobEffectInfoChatFormatField.setAccessible(true);
        Enum chatFormat = (Enum)nmsMobEffectInfoChatFormatField.get(mobEffectType);
        return ChatColor.getByChar((char)chatFormat.toString().charAt(1));
    }

    public static Map<String, AttributeModifier> getPotionAttributes(PotionEffect effect) {
        try {
            HashMap<String, AttributeModifier> attributes = new HashMap<String, AttributeModifier>();
            Object nmsMobEffect = craftPotionUtilFromBukkitMethod.invoke(null, effect);
            Object nmsMobEffectList = nmsMobEffectGetMobEffectListMethod.invoke(nmsMobEffect, new Object[0]);
            nmsMobEffectListAttributeMapField.setAccessible(true);
            for (Map.Entry entry : ((Map)nmsMobEffectListAttributeMapField.get(nmsMobEffectList)).entrySet()) {
                String name = (String)nmsAttributeBaseGetNameMethod.invoke(entry.getKey(), new Object[0]);
                craftAttributeInstanceConvertMethod.setAccessible(true);
                AttributeModifier attributeModifier = (AttributeModifier)craftAttributeInstanceConvertMethod.invoke(null, entry.getValue());
                double leveledAmount = (Double)nmsMobEffectGetAttributeModifierValueMethod.invoke(nmsMobEffectList, effect.getAmplifier(), entry.getValue());
                attributes.put(name, new AttributeModifier(attributeModifier.getUniqueId(), attributeModifier.getName(), leveledAmount, attributeModifier.getOperation(), attributeModifier.getSlot()));
            }
            return attributes;
        }
        catch (Throwable e) {
            return Collections.emptyMap();
        }
    }

    static {
        try {
            craftItemStackClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.inventory.CraftItemStack", (String[])new String[0]);
            nmsItemStackClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.ItemStack", (String[])new String[]{"net.minecraft.world.item.ItemStack"});
            nmsNbtTagCompoundClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.NBTTagCompound", (String[])new String[]{"net.minecraft.nbt.NBTTagCompound"});
            nmsMobEffectListClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.MobEffectList", (String[])new String[]{"net.minecraft.world.effect.MobEffectList"});
            if (InteractiveChat.version.isOld()) {
                craftPotionBrewerClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.potion.CraftPotionBrewer", (String[])new String[0]);
                craftPotionBrewerInstance = craftPotionBrewerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                craftPotionBrewerGetEffectsFromDamageMethod = craftPotionBrewerClass.getMethod("getEffectsFromDamage", Integer.TYPE);
            } else {
                nmsPotionRegistryClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.PotionRegistry", (String[])new String[]{"net.minecraft.world.item.alchemy.PotionRegistry"});
                nmsPotionRegistryGetPotionRegistryFromStringMethod = nmsPotionRegistryClass.getMethod("a", String.class);
                nmsPotionRegistryGetMobEffectListMethod = nmsPotionRegistryClass.getMethod("a", new Class[0]);
                craftPotionUtilClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.potion.CraftPotionUtil", (String[])new String[0]);
                nmsMobEffectClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.MobEffect", (String[])new String[]{"net.minecraft.world.effect.MobEffect"});
                craftPotionUtilToBukkitMethod = craftPotionUtilClass.getMethod("toBukkit", nmsMobEffectClass);
                craftPotionUtilFromBukkitMethod = craftPotionUtilClass.getMethod("fromBukkit", PotionEffect.class);
            }
            if (InteractiveChat.version.isOld()) {
                nmsMobEffectListByIdArrayField = nmsMobEffectListClass.getField("byId");
                nmsMobEffectListTypeField = nmsMobEffectListClass.getDeclaredField("K");
            } else if (InteractiveChat.version.isOlderOrEqualTo(MCVersion.V1_13_1)) {
                nmsMobEffectListByIdMethod = nmsMobEffectListClass.getMethod("fromId", Integer.TYPE);
                nmsMobEffectListTypeField = nmsMobEffectListClass.getDeclaredField("c");
            } else {
                nmsMobEffectListByIdMethod = InteractiveChat.version.isOlderOrEqualTo(MCVersion.V1_17) ? nmsMobEffectListClass.getMethod("fromId", Integer.TYPE) : nmsMobEffectListClass.getMethod("a", Integer.TYPE);
                nmsMobEffectListTypeField = nmsMobEffectListClass.getDeclaredField("b");
                nmsMobEffectInfoChatFormatField = nmsMobEffectListTypeField.getType().getDeclaredField("d");
            }
            if (!InteractiveChat.version.isOld()) {
                nmsAttributeBaseClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.AttributeBase", (String[])new String[]{"net.minecraft.world.entity.ai.attributes.AttributeBase"});
                nmsAttributeModifierClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.AttributeModifier", (String[])new String[]{"net.minecraft.world.entity.ai.attributes.AttributeModifier"});
                craftAttributeInstanceClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.attribute.CraftAttributeInstance", (String[])new String[0]);
                craftAttributeInstanceConvertMethod = craftAttributeInstanceClass.getDeclaredMethod("convert", nmsAttributeModifierClass);
                nmsMobEffectGetAttributeModifierValueMethod = nmsMobEffectListClass.getMethod("a", Integer.TYPE, nmsAttributeModifierClass);
                if (InteractiveChat.version.isOlderOrEqualTo(MCVersion.V1_17)) {
                    nmsAttributeBaseGetNameMethod = nmsAttributeBaseClass.getMethod("getName", new Class[0]);
                    nmsMobEffectGetMobEffectListMethod = nmsMobEffectClass.getMethod("getMobEffect", new Class[0]);
                } else if (InteractiveChat.version.isOlderOrEqualTo(MCVersion.V1_18_2)) {
                    nmsAttributeBaseGetNameMethod = nmsAttributeBaseClass.getMethod("c", new Class[0]);
                    nmsMobEffectGetMobEffectListMethod = nmsMobEffectClass.getMethod("a", new Class[0]);
                } else {
                    nmsAttributeBaseGetNameMethod = nmsAttributeBaseClass.getMethod("c", new Class[0]);
                    nmsMobEffectGetMobEffectListMethod = nmsMobEffectClass.getMethod("b", new Class[0]);
                }
                nmsMobEffectListAttributeMapField = nmsMobEffectListClass.getDeclaredField("a");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

