/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JarUtils {
    public static final char JAR_SEPARATOR = '/';

    public static void copyFolderFromJar(String folderName, File destFolder, CopyOption option) throws IOException {
        JarUtils.copyFolderFromJar(folderName, destFolder, option, null);
    }

    public static void copyFolderFromJar(String folderName, File destFolder, CopyOption option, PathTrimmer trimmer) throws IOException {
        ZipEntry entry;
        if (!destFolder.exists()) {
            destFolder.mkdirs();
        }
        byte[] buffer = new byte[1024];
        File fullPath = null;
        String path = JarUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (trimmer != null) {
            path = trimmer.trim(path);
        }
        try {
            if (!path.startsWith("file")) {
                path = "file://" + path;
            }
            fullPath = new File(new URI(path));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        ZipInputStream zis = new ZipInputStream(new FileInputStream(fullPath));
        while ((entry = zis.getNextEntry()) != null) {
            int len;
            File file;
            if (!entry.getName().startsWith(folderName + '/')) continue;
            String fileName = entry.getName();
            if (fileName.charAt(fileName.length() - 1) == '/') {
                file = new File(destFolder + File.separator + fileName);
                if (file.isFile()) {
                    file.delete();
                }
                file.mkdirs();
                continue;
            }
            file = new File(destFolder + File.separator + fileName);
            if (option == CopyOption.COPY_IF_NOT_EXIST && file.exists()) continue;
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            while ((len = zis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            fos.close();
        }
        zis.closeEntry();
        zis.close();
    }

    public static enum CopyOption {
        COPY_IF_NOT_EXIST,
        REPLACE_IF_EXIST;

    }

    @FunctionalInterface
    public static interface PathTrimmer {
        public String trim(String var1);
    }
}

