/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import github.scarsz.discordsrv.dependencies.jda.api.entities.Guild;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Role;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.privileges.CommandPrivilege;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JDAUtils {
    private static final Pattern VALID_ID = Pattern.compile("[0-9]+");

    public static List<Role> toRoles(Guild guild, Collection<String> roles) {
        ArrayList<Role> result = new ArrayList<Role>();
        for (String str : roles) {
            if (str.equals("everyone")) {
                result.add(guild.getPublicRole());
                continue;
            }
            Role role = null;
            if (VALID_ID.matcher(str).matches()) {
                role = guild.getRoleById(str);
            }
            if (role == null) {
                result.addAll(guild.getRolesByName(str, false));
                continue;
            }
            result.add(role);
        }
        return result;
    }

    public static List<CommandPrivilege> toWhitelistedCommandPrivileges(Guild guild, Collection<Role> roles) {
        return roles.stream().map(each -> CommandPrivilege.enableRole((long)each.getIdLong())).collect(Collectors.toList());
    }
}

