/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechat.libs.io.github.bananapuncher714.nbteditor.NBTEditor;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.CompoundTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.IntArrayTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.ListTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.StringTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.Tag;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechat.libs.org.json.simple.parser.ParseException;
import com.loohp.interactivechat.objectholders.ICPlayer;
import com.loohp.interactivechat.objectholders.OfflineICPlayer;
import com.loohp.interactivechat.objectholders.ValuePairs;
import com.loohp.interactivechat.utils.CompassUtils;
import com.loohp.interactivechat.utils.FilledMapUtils;
import com.loohp.interactivechat.utils.ItemNBTUtils;
import com.loohp.interactivechat.utils.MCVersion;
import com.loohp.interactivechat.utils.NBTParsingUtils;
import com.loohp.interactivechat.utils.SkinUtils;
import com.loohp.interactivechat.utils.XMaterialUtils;
import com.loohp.interactivechatdiscordsrvaddon.graphics.BannerGraphics;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageGeneration;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.registry.ResourceRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.CustomItemTextureRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.ModelRenderer;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.BlockModel;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.EnchantmentProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.GeneratedTextureResource;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import com.loohp.interactivechatdiscordsrvaddon.utils.BundleUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.DiscordItemStackUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.FishUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.ModelUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.PotionUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.TintUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.VectorUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.WorldUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.time.LocalDate;
import java.time.Month;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;
import org.bukkit.inventory.meta.CompassMeta;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.Potion;
import org.bukkit.potion.PotionType;
import org.bukkit.util.Vector;

public class ItemRenderUtils {
    private static final Random RANDOM = new Random();

    public static ItemStackProcessResult processItemForRendering(ResourceManager manager, OfflineICPlayer player, ItemStack item, EquipmentSlot slot, boolean is1_8, String language) throws IOException {
        int cooldown;
        World world = null;
        Player livingEntity = null;
        if (player.isOnline() && player.getPlayer().isLocal()) {
            livingEntity = player.getPlayer().getLocalPlayer();
            world = livingEntity.getWorld();
        }
        boolean requiresEnchantmentGlint = false;
        XMaterial xMaterial = XMaterialUtils.matchXMaterial((ItemStack)item);
        String directLocation = null;
        if (xMaterial.equals((Object)XMaterial.DEBUG_STICK)) {
            requiresEnchantmentGlint = true;
        } else if (xMaterial.equals((Object)XMaterial.ENCHANTED_GOLDEN_APPLE)) {
            requiresEnchantmentGlint = true;
        } else if (xMaterial.equals((Object)XMaterial.WRITTEN_BOOK)) {
            requiresEnchantmentGlint = true;
        } else if (xMaterial.equals((Object)XMaterial.ENCHANTED_BOOK)) {
            requiresEnchantmentGlint = true;
        } else if (item.getEnchantments().size() > 0) {
            requiresEnchantmentGlint = true;
        }
        List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> enchantmentGlintResource = manager.getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getEnchantmentGlintOverrideTextures(null, item, () -> ImageGeneration.getDefaultEnchantmentTint(), manager.getLanguageManager().getTranslateFunction().ofLanguage(language));
        UnaryOperator enchantmentGlintFunction = image -> ImageGeneration.getEnchantedImage(enchantmentGlintResource, image);
        Function<BufferedImage, ModelRenderer.RawEnchantmentGlintData> rawEnchantmentGlintFunction = image -> new ModelRenderer.RawEnchantmentGlintData(enchantmentGlintResource.stream().map(each -> ImageGeneration.getRawEnchantedImage((TextureResource)each.getFirst(), image)).collect(Collectors.toList()), enchantmentGlintResource.stream().map(each -> (EnchantmentProperties.OpenGLBlending)each.getSecond()).collect(Collectors.toList()));
        TintUtils.TintIndexData tintIndexData = TintUtils.getTintData(xMaterial);
        EnumMap<ModelOverride.ModelOverrideType, Float> predicates = new EnumMap<ModelOverride.ModelOverrideType, Float>(ModelOverride.ModelOverrideType.class);
        HashMap<String, TextureResource> providedTextures = new HashMap<String, TextureResource>();
        if (!player.isRightHanded()) {
            predicates.put(ModelOverride.ModelOverrideType.LEFTHANDED, Float.valueOf(1.0f));
        }
        if (NBTEditor.contains((Object)item, (Object[])new Object[]{"CustomModelData"})) {
            int customModelData = NBTEditor.getInt((Object)item, (Object[])new Object[]{"CustomModelData"});
            predicates.put(ModelOverride.ModelOverrideType.CUSTOM_MODEL_DATA, Float.valueOf(customModelData));
        }
        if (item.getType().getMaxDurability() > 0) {
            short maxDur = item.getType().getMaxDurability();
            int damage = InteractiveChat.version.isLegacy() ? item.getDurability() : ((Damageable)item.getItemMeta()).getDamage();
            predicates.put(ModelOverride.ModelOverrideType.DAMAGE, Float.valueOf((float)damage / (float)maxDur));
            predicates.put(ModelOverride.ModelOverrideType.DAMAGED, Float.valueOf(DiscordItemStackUtils.isUnbreakable(item) || damage <= 0 ? 0.0f : 1.0f));
        }
        if (xMaterial.equals((Object)XMaterial.CHEST) || xMaterial.equals((Object)XMaterial.TRAPPED_CHEST)) {
            LocalDate time = LocalDate.now();
            Month month = time.getMonth();
            int day = time.getDayOfMonth();
            if (month.equals(Month.DECEMBER) && (day == 24 || day == 25 || day == 26)) {
                directLocation = "minecraft:interactivechatdiscordsrvaddon/builtin_entity/christmas_chest";
            }
        } else if (xMaterial.isOneOf(Collections.singletonList("CONTAINS:banner")) && !xMaterial.isOneOf(Collections.singletonList("CONTAINS:banner_pattern"))) {
            BannerGraphics.BannerAssetResult bannerAsset = BannerGraphics.generateBannerAssets(item);
            providedTextures.put("minecraft:interactivechatdiscordsrvaddon/banner_base", new GeneratedTextureResource(manager, bannerAsset.getBase()));
            providedTextures.put("minecraft:interactivechatdiscordsrvaddon/banner_patterns", new GeneratedTextureResource(manager, bannerAsset.getPatterns()));
        } else if (xMaterial.equals((Object)XMaterial.SHIELD)) {
            BannerGraphics.BannerAssetResult shieldAsset = BannerGraphics.generateShieldAssets(item);
            providedTextures.put("minecraft:interactivechatdiscordsrvaddon/shield_base", new GeneratedTextureResource(manager, shieldAsset.getBase()));
            providedTextures.put("minecraft:interactivechatdiscordsrvaddon/shield_patterns", new GeneratedTextureResource(manager, shieldAsset.getPatterns()));
            predicates.put(ModelOverride.ModelOverrideType.BLOCKING, Float.valueOf(0.0f));
            ICPlayer icplayer = player.getPlayer();
            if (icplayer != null && icplayer.isLocal()) {
                int cooldown2 = icplayer.getLocalPlayer().getCooldown(item.getType());
                predicates.put(ModelOverride.ModelOverrideType.COOLDOWN, Float.valueOf((float)cooldown2 / 100.0f));
            }
        } else if (xMaterial.equals((Object)XMaterial.PLAYER_HEAD)) {
            BufferedImage skinImage = manager.getTextureManager().getTexture("minecraft:entity/steve").getTexture();
            if (item.hasItemMeta()) {
                Tag skullOwnerTag = ((CompoundTag)NBTParsingUtils.fromSNBT((String)ItemNBTUtils.getNMSItemStackJson((ItemStack)item))).getCompoundTag("tag").get("SkullOwner");
                try {
                    String skinURL = null;
                    if (skullOwnerTag instanceof StringTag) {
                        skinURL = SkinUtils.getSkinURLFromUUID((UUID)Bukkit.getOfflinePlayer((String)((StringTag)skullOwnerTag).getValue()).getUniqueId());
                    } else if (skullOwnerTag instanceof CompoundTag) {
                        Tag uuidTag;
                        StringTag valueTag2;
                        ListTag texturesTag;
                        CompoundTag propertiesTag = (CompoundTag)((CompoundTag)skullOwnerTag).get("Properties");
                        if (propertiesTag != null && (texturesTag = (ListTag)propertiesTag.get("textures")) != null && texturesTag.size() > 0 && (valueTag2 = (StringTag)((CompoundTag)texturesTag.get(0)).get("Value")) != null) {
                            String json = new String(Base64.getDecoder().decode(valueTag2.getValue()));
                            try {
                                JSONObject skinJson;
                                JSONObject texturesJson = (JSONObject)((JSONObject)new JSONParser().parse(json)).get((Object)"textures");
                                if (texturesJson != null && (skinJson = (JSONObject)texturesJson.get((Object)"SKIN")) != null) {
                                    skinURL = (String)skinJson.get((Object)"url");
                                }
                            }
                            catch (ParseException e) {
                                throw new IllegalArgumentException("Skull contains illegal texture data: \n" + json, e);
                            }
                        }
                        if (skinURL == null && (uuidTag = ((CompoundTag)skullOwnerTag).get("Id")) != null) {
                            int[] array;
                            if (uuidTag instanceof StringTag) {
                                try {
                                    skinURL = SkinUtils.getSkinURLFromUUID((UUID)UUID.fromString(((StringTag)uuidTag).getValue()));
                                }
                                catch (IllegalArgumentException valueTag2) {}
                            } else if (uuidTag instanceof IntArrayTag && (array = (int[])((IntArrayTag)uuidTag).getValue()).length == 4) {
                                UUID uuid = new UUID((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL, (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
                                skinURL = SkinUtils.getSkinURLFromUUID((UUID)uuid);
                            }
                        }
                        if (skinURL == null) {
                            StringTag nameTag = (StringTag)((CompoundTag)skullOwnerTag).get("Name");
                            skinURL = SkinUtils.getSkinURLFromUUID((UUID)Bukkit.getOfflinePlayer((String)nameTag.getValue()).getUniqueId());
                        }
                    }
                    if (skinURL != null) {
                        skinImage = ImageUtils.downloadImage(skinURL);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            providedTextures.put("minecraft:interactivechatdiscordsrvaddon/skin", new GeneratedTextureResource(manager, ModelUtils.convertToModernSkinTexture(skinImage)));
        } else if (xMaterial.equals((Object)XMaterial.ELYTRA)) {
            int durability = item.getType().getMaxDurability() - (InteractiveChat.version.isLegacy() ? item.getDurability() : ((Damageable)item.getItemMeta()).getDamage());
            if (durability <= 1) {
                predicates.put(ModelOverride.ModelOverrideType.BROKEN, Float.valueOf(1.0f));
            }
        } else if (xMaterial.equals((Object)XMaterial.CROSSBOW)) {
            CrossbowMeta meta = (CrossbowMeta)item.getItemMeta();
            List charged = meta.getChargedProjectiles();
            if (charged != null && !charged.isEmpty()) {
                predicates.put(ModelOverride.ModelOverrideType.CHARGED, Float.valueOf(1.0f));
                ItemStack charge = (ItemStack)charged.get(0);
                XMaterial chargeType = XMaterialUtils.matchXMaterial((ItemStack)charge);
                if (chargeType.equals((Object)XMaterial.FIREWORK_ROCKET)) {
                    predicates.put(ModelOverride.ModelOverrideType.FIREWORK, Float.valueOf(1.0f));
                }
            }
        } else if (xMaterial.equals((Object)XMaterial.CLOCK)) {
            Player bukkitPlayer;
            ICPlayer onlinePlayer = player.getPlayer();
            long time = onlinePlayer != null && onlinePlayer.isLocal() ? (WorldUtils.isNatural((bukkitPlayer = onlinePlayer.getLocalPlayer()).getWorld()) ? onlinePlayer.getLocalPlayer().getPlayerTime() % 24000L - 6000L : (long)(RANDOM.nextInt(24000) - 6000)) : ((World)Bukkit.getWorlds().get(0)).getTime() % 24000L - 6000L;
            if (time < 0L) {
                time += 24000L;
            }
            double timePhase = (double)time / 24000.0;
            predicates.put(ModelOverride.ModelOverrideType.TIME, Float.valueOf((float)(timePhase - 0.0078125)));
        } else if (xMaterial.equals((Object)XMaterial.COMPASS)) {
            double angle;
            ICPlayer icplayer = player.getPlayer();
            if (icplayer != null && icplayer.isLocal()) {
                Player bukkitPlayer = icplayer.getLocalPlayer();
                if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_16)) {
                    Location target;
                    CompassMeta meta = (CompassMeta)item.getItemMeta();
                    if (meta.hasLodestone()) {
                        Location lodestone = meta.getLodestone();
                        target = new Location(lodestone.getWorld(), (double)lodestone.getBlockX() + 0.5, (double)lodestone.getBlockY(), (double)lodestone.getBlockZ() + 0.5, lodestone.getYaw(), lodestone.getPitch());
                    } else if (WorldUtils.isNatural(bukkitPlayer.getWorld())) {
                        Location spawn = bukkitPlayer.getCompassTarget();
                        target = new Location(spawn.getWorld(), (double)spawn.getBlockX() + 0.5, (double)spawn.getBlockY(), (double)spawn.getBlockZ() + 0.5, spawn.getYaw(), spawn.getPitch());
                    } else {
                        target = null;
                    }
                    if (target != null && target.getWorld().equals(bukkitPlayer.getWorld())) {
                        Location playerLocation = bukkitPlayer.getEyeLocation();
                        playerLocation.setPitch(0.0f);
                        Vector looking = playerLocation.getDirection();
                        Vector pointing = target.toVector().subtract(playerLocation.toVector());
                        pointing.setY(0);
                        double degree = VectorUtils.getBearing(looking, pointing);
                        if (degree < 0.0) {
                            degree += 360.0;
                        }
                        angle = degree / 360.0;
                    } else {
                        angle = RANDOM.nextDouble();
                    }
                } else if (WorldUtils.isNatural(bukkitPlayer.getWorld())) {
                    Location spawn = bukkitPlayer.getCompassTarget();
                    Location target = new Location(spawn.getWorld(), (double)spawn.getBlockX() + 0.5, (double)spawn.getBlockY(), (double)spawn.getBlockZ() + 0.5, spawn.getYaw(), spawn.getPitch());
                    Location playerLocation = bukkitPlayer.getEyeLocation();
                    playerLocation.setPitch(0.0f);
                    Vector looking = playerLocation.getDirection();
                    Vector pointing = target.toVector().subtract(playerLocation.toVector());
                    pointing.setY(0);
                    double degree = VectorUtils.getBearing(looking, pointing);
                    if (degree < 0.0) {
                        degree += 360.0;
                    }
                    angle = degree / 360.0;
                } else {
                    angle = RANDOM.nextDouble();
                }
            } else {
                angle = 0.0;
            }
            if (CompassUtils.isLodestoneCompass((ItemStack)item)) {
                requiresEnchantmentGlint = true;
            }
            predicates.put(ModelOverride.ModelOverrideType.ANGLE, Float.valueOf((float)(angle - 0.015625)));
        } else if (xMaterial.equals((Object)XMaterial.RECOVERY_COMPASS)) {
            double angle;
            ICPlayer icplayer = player.getPlayer();
            if (icplayer != null && icplayer.isLocal()) {
                Player bukkitPlayer = icplayer.getLocalPlayer();
                Location target = bukkitPlayer.getLastDeathLocation();
                if (target != null && target.getWorld().equals(bukkitPlayer.getWorld())) {
                    Location playerLocation = bukkitPlayer.getEyeLocation();
                    playerLocation.setPitch(0.0f);
                    Vector looking = playerLocation.getDirection();
                    Vector pointing = target.toVector().subtract(playerLocation.toVector());
                    pointing.setY(0);
                    double degree = VectorUtils.getBearing(looking, pointing);
                    if (degree < 0.0) {
                        degree += 360.0;
                    }
                    angle = degree / 360.0;
                } else {
                    angle = RANDOM.nextDouble();
                }
            } else {
                angle = 0.0;
            }
            predicates.put(ModelOverride.ModelOverrideType.ANGLE, Float.valueOf((float)(angle - 0.015625)));
        } else if (xMaterial.equals((Object)XMaterial.LIGHT)) {
            Object levelObj;
            int level = 16;
            Object blockStateObj = item.getItemMeta().serialize().get("BlockStateTag");
            if (blockStateObj != null && blockStateObj instanceof Map && (levelObj = ((Map)blockStateObj).get("level")) != null) {
                try {
                    level = Integer.parseInt(levelObj.toString().replace("i", ""));
                }
                catch (NumberFormatException bukkitPlayer) {
                    // empty catch block
                }
            }
            predicates.put(ModelOverride.ModelOverrideType.LEVEL, Float.valueOf((float)level / 16.0f));
        } else if (item.getItemMeta() instanceof LeatherArmorMeta) {
            LeatherArmorMeta meta = (LeatherArmorMeta)item.getItemMeta();
            Color color = new Color(meta.getColor().asRGB());
            if (xMaterial.equals((Object)XMaterial.LEATHER_HORSE_ARMOR)) {
                BufferedImage itemImage = manager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + xMaterial.name().toLowerCase()).getTexture(32, 32);
                BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(itemImage), color);
                itemImage = ImageUtils.multiply(itemImage, colorOverlay);
                providedTextures.put(ResourceRegistry.LEATHER_HORSE_ARMOR_PLACEHOLDER, new GeneratedTextureResource(manager, itemImage));
            } else {
                BufferedImage itemImage = manager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + xMaterial.name().toLowerCase()).getTexture(32, 32);
                BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(itemImage), color);
                itemImage = ImageUtils.multiply(itemImage, colorOverlay);
                if (xMaterial.name().contains("HELMET")) {
                    providedTextures.put(ResourceRegistry.LEATHER_HELMET_PLACEHOLDER, new GeneratedTextureResource(manager, itemImage));
                } else if (xMaterial.name().contains("CHESTPLATE")) {
                    providedTextures.put(ResourceRegistry.LEATHER_CHESTPLATE_PLACEHOLDER, new GeneratedTextureResource(manager, itemImage));
                } else if (xMaterial.name().contains("LEGGINGS")) {
                    providedTextures.put(ResourceRegistry.LEATHER_LEGGINGS_PLACEHOLDER, new GeneratedTextureResource(manager, itemImage));
                } else if (xMaterial.name().contains("BOOTS")) {
                    providedTextures.put(ResourceRegistry.LEATHER_BOOTS_PLACEHOLDER, new GeneratedTextureResource(manager, itemImage));
                }
            }
        } else if (item.getItemMeta() instanceof PotionMeta) {
            if (xMaterial.equals((Object)XMaterial.TIPPED_ARROW)) {
                int color;
                PotionMeta meta = (PotionMeta)item.getItemMeta();
                PotionType potiontype = InteractiveChat.version.isOld() ? Potion.fromItemStack((ItemStack)item).getType() : meta.getBasePotionData().getType();
                BufferedImage tippedArrowHead = manager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "tipped_arrow_head").getTexture(32, 32);
                try {
                    color = meta.hasColor() ? meta.getColor().asRGB() : PotionUtils.getPotionBaseColor(potiontype);
                }
                catch (Throwable e) {
                    color = PotionUtils.getPotionBaseColor(PotionType.WATER);
                }
                BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(tippedArrowHead), color);
                tippedArrowHead = ImageUtils.multiply(tippedArrowHead, colorOverlay);
                providedTextures.put(ResourceRegistry.TIPPED_ARROW_HEAD_PLACEHOLDER, new GeneratedTextureResource(manager, tippedArrowHead));
            } else {
                int color;
                PotionMeta meta = (PotionMeta)item.getItemMeta();
                PotionType potiontype = InteractiveChat.version.isOld() ? Potion.fromItemStack((ItemStack)item).getType() : meta.getBasePotionData().getType();
                BufferedImage potionOverlay = manager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "potion_overlay").getTexture(32, 32);
                try {
                    color = meta.hasColor() ? meta.getColor().asRGB() : PotionUtils.getPotionBaseColor(potiontype);
                }
                catch (Throwable e) {
                    color = PotionUtils.getPotionBaseColor(PotionType.WATER);
                }
                BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(potionOverlay), color);
                potionOverlay = ImageUtils.multiply(potionOverlay, colorOverlay);
                providedTextures.put(ResourceRegistry.POTION_OVERLAY_PLACEHOLDER, new GeneratedTextureResource(manager, potionOverlay));
                if (!(potiontype == null || potiontype.name().equals("WATER") || potiontype.name().equals("AWKWARD") || potiontype.name().equals("MUNDANE") || potiontype.name().equals("THICK") || potiontype.name().equals("UNCRAFTABLE"))) {
                    requiresEnchantmentGlint = true;
                }
            }
        } else if (xMaterial.isOneOf(Collections.singletonList("CONTAINS:spawn_egg"))) {
            TintUtils.SpawnEggTintData tintData = TintUtils.getSpawnEggTint(xMaterial);
            if (tintData != null) {
                BufferedImage baseImage = manager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "spawn_egg").getTexture();
                BufferedImage overlayImage = manager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "spawn_egg_overlay").getTexture(baseImage.getWidth(), baseImage.getHeight());
                BufferedImage colorBase = ImageUtils.changeColorTo(ImageUtils.copyImage(baseImage), tintData.getBase());
                BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(overlayImage), tintData.getOverlay());
                baseImage = ImageUtils.multiply(baseImage, colorBase);
                overlayImage = ImageUtils.multiply(overlayImage, colorOverlay);
                providedTextures.put(ResourceRegistry.SPAWN_EGG_PLACEHOLDER, new GeneratedTextureResource(manager, baseImage));
                providedTextures.put(ResourceRegistry.SPAWN_EGG_OVERLAY_PLACEHOLDER, new GeneratedTextureResource(manager, overlayImage));
            }
        } else if (xMaterial.equals((Object)XMaterial.FIREWORK_STAR)) {
            int overlayColor;
            int[] is = NBTEditor.contains((Object)item, (Object[])new Object[]{"Explosion", "Colors"}) ? NBTEditor.getIntArray((Object)item, (Object[])new Object[]{"Explosion", "Colors"}) : null;
            int[] nArray = is;
            if (is == null || is.length == 0) {
                overlayColor = 0x8A8A8A;
            } else if (is.length == 1) {
                overlayColor = is[0];
            } else {
                int i = 0;
                int j = 0;
                int k = 0;
                for (int l : is) {
                    i += (l & 0xFF0000) >> 16;
                    j += (l & 0xFF00) >> 8;
                    k += l & 0xFF;
                }
                overlayColor = (i /= is.length) << 16 | (j /= is.length) << 8 | (k /= is.length);
            }
            BufferedImage fireworkStarOverlay = manager.getTextureManager().getTexture("minecraft:item/firework_star_overlay").getTexture();
            BufferedImage tint = ImageUtils.changeColorTo(ImageUtils.copyImage(fireworkStarOverlay), overlayColor);
            fireworkStarOverlay = ImageUtils.multiply(fireworkStarOverlay, tint);
            providedTextures.put("minecraft:item/firework_star_overlay", new GeneratedTextureResource(manager, fireworkStarOverlay));
        } else if (InteractiveChat.version.isLegacy() && xMaterial.isOneOf(Collections.singletonList("CONTAINS:bed"))) {
            String colorName = xMaterial.name().replace("_BED", "").toLowerCase();
            BufferedImage bedTexture = manager.getTextureManager().getTexture("minecraft:entity/bed/" + colorName).getTexture();
            providedTextures.put("minecraft:interactivechatdiscordsrvaddon/legacy_bed", new GeneratedTextureResource(manager, bedTexture));
        } else if (InteractiveChat.version.isNewerOrEqualTo(MCVersion.V1_9) && xMaterial.equals((Object)XMaterial.ENDER_PEARL)) {
            ICPlayer icplayer = player.getPlayer();
            if (icplayer != null && icplayer.isLocal()) {
                cooldown = icplayer.getLocalPlayer().getCooldown(item.getType());
                predicates.put(ModelOverride.ModelOverrideType.COOLDOWN, Float.valueOf((float)cooldown / 20.0f));
            }
        } else if (xMaterial.equals((Object)XMaterial.CHORUS_FRUIT)) {
            ICPlayer icplayer = player.getPlayer();
            if (icplayer != null && icplayer.isLocal()) {
                cooldown = icplayer.getLocalPlayer().getCooldown(item.getType());
                predicates.put(ModelOverride.ModelOverrideType.COOLDOWN, Float.valueOf((float)cooldown / 20.0f));
            }
        } else if (xMaterial.equals((Object)XMaterial.FISHING_ROD)) {
            Player bukkitPlayer;
            predicates.put(ModelOverride.ModelOverrideType.CAST, Float.valueOf(0.0f));
            ICPlayer icplayer = player.getPlayer();
            if (icplayer != null && icplayer.isLocal() && FishUtils.getPlayerFishingHook(bukkitPlayer = icplayer.getLocalPlayer()) != null) {
                ItemStack mainHandItem = bukkitPlayer.getEquipment().getItemInHand();
                if (InteractiveChat.version.isOld()) {
                    if (mainHandItem != null && mainHandItem.equals((Object)item)) {
                        predicates.put(ModelOverride.ModelOverrideType.CAST, Float.valueOf(1.0f));
                    }
                } else {
                    ItemStack offHandItem = bukkitPlayer.getEquipment().getItemInOffHand();
                    if (mainHandItem != null && mainHandItem.equals((Object)item) || offHandItem != null && offHandItem.equals((Object)item) && (mainHandItem == null || !XMaterial.matchXMaterial((ItemStack)mainHandItem).equals((Object)XMaterial.FISHING_ROD))) {
                        predicates.put(ModelOverride.ModelOverrideType.CAST, Float.valueOf(1.0f));
                    }
                }
            }
        } else if (xMaterial.equals((Object)XMaterial.BUNDLE)) {
            float fullness = BundleUtils.getFullnessPercentage(((BundleMeta)item.getItemMeta()).getItems());
            predicates.put(ModelOverride.ModelOverrideType.FILLED, Float.valueOf(fullness));
        } else if (FilledMapUtils.isFilledMap((ItemStack)item)) {
            int markingColor = NBTEditor.contains((Object)item, (Object[])new Object[]{"display", "MapColor"}) ? 0xFF000000 | NBTEditor.getInt((Object)item, (Object[])new Object[]{"display", "MapColor"}) & 0xFFFFFF : -12173266;
            BufferedImage filledMapMarkings = manager.getTextureManager().getTexture(ResourceRegistry.MAP_MARKINGS_LOCATION).getTexture();
            BufferedImage tint = ImageUtils.changeColorTo(ImageUtils.copyImage(filledMapMarkings), markingColor);
            filledMapMarkings = ImageUtils.multiply(filledMapMarkings, tint);
            providedTextures.put(ResourceRegistry.MAP_MARKINGS_LOCATION, new GeneratedTextureResource(manager, filledMapMarkings));
        }
        String modelKey = directLocation == null ? "minecraft:item/" + ModelUtils.getItemModelKey(xMaterial) : directLocation;
        Function postResolveFunction = manager.getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getItemPostResolveFunction(modelKey, slot, item, is1_8, predicates, player, world, (LivingEntity)livingEntity, manager.getLanguageManager().getTranslateFunction().ofLanguage(language)).map(function -> function.andThen(result -> {
            Map overrideTextures = (Map)result.getSecond();
            for (Map.Entry entry : overrideTextures.entrySet()) {
                BufferedImage itemImage;
                PotionMeta meta;
                String overriddenResource = ((BlockModel)result.getFirst()).getTextures().get(entry.getKey());
                if (overriddenResource == null) continue;
                if (!overriddenResource.contains(":")) {
                    String namespace = ((BlockModel)result.getFirst()).getResourceLocation();
                    namespace = namespace.contains(":") ? namespace.substring(0, namespace.indexOf(":")) : "minecraft";
                    overriddenResource = namespace + ":" + overriddenResource;
                }
                if (item.getItemMeta() instanceof PotionMeta) {
                    int color;
                    BufferedImage colorOverlay;
                    PotionType potiontype;
                    if (xMaterial.equals((Object)XMaterial.TIPPED_ARROW)) {
                        int color2;
                        if (!overriddenResource.equalsIgnoreCase(ResourceRegistry.TIPPED_ARROW_HEAD_PLACEHOLDER)) continue;
                        meta = (PotionMeta)item.getItemMeta();
                        potiontype = InteractiveChat.version.isOld() ? Potion.fromItemStack((ItemStack)item).getType() : meta.getBasePotionData().getType();
                        BufferedImage tippedArrowHead = manager.getTextureManager().getTexture(ResourceRegistry.ITEM_TEXTURE_LOCATION + "tipped_arrow_head").getTexture(32, 32);
                        try {
                            int color3 = meta.hasColor() ? meta.getColor().asRGB() : PotionUtils.getPotionBaseColor(potiontype);
                        }
                        catch (Throwable e) {
                            color2 = PotionUtils.getPotionBaseColor(PotionType.WATER);
                        }
                        colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(tippedArrowHead), color2);
                        tippedArrowHead = ImageUtils.multiply(tippedArrowHead, colorOverlay);
                        entry.setValue(new GeneratedTextureResource(manager, tippedArrowHead));
                        continue;
                    }
                    if (!overriddenResource.equalsIgnoreCase(ResourceRegistry.POTION_OVERLAY_PLACEHOLDER)) continue;
                    meta = (PotionMeta)item.getItemMeta();
                    potiontype = InteractiveChat.version.isOld() ? Potion.fromItemStack((ItemStack)item).getType() : meta.getBasePotionData().getType();
                    BufferedImage potionOverlay = ((TextureResource)entry.getValue()).getTexture(32, 32);
                    try {
                        color = meta.hasColor() ? meta.getColor().asRGB() : PotionUtils.getPotionBaseColor(potiontype);
                    }
                    catch (Throwable e) {
                        color = PotionUtils.getPotionBaseColor(PotionType.WATER);
                    }
                    colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(potionOverlay), color);
                    potionOverlay = ImageUtils.multiply(potionOverlay, colorOverlay);
                    entry.setValue(new GeneratedTextureResource(manager, potionOverlay));
                    continue;
                }
                if (xMaterial.isOneOf(Collections.singletonList("CONTAINS:spawn_egg"))) {
                    TintUtils.SpawnEggTintData tintData;
                    if (overriddenResource.equalsIgnoreCase(ResourceRegistry.SPAWN_EGG_PLACEHOLDER)) {
                        tintData = TintUtils.getSpawnEggTint(xMaterial);
                        if (tintData == null) continue;
                        BufferedImage baseImage = ((TextureResource)entry.getValue()).getTexture();
                        BufferedImage colorBase = ImageUtils.changeColorTo(ImageUtils.copyImage(baseImage), tintData.getBase());
                        baseImage = ImageUtils.multiply(baseImage, colorBase);
                        entry.setValue(new GeneratedTextureResource(manager, baseImage));
                        continue;
                    }
                    if (!overriddenResource.equalsIgnoreCase(ResourceRegistry.SPAWN_EGG_OVERLAY_PLACEHOLDER) || (tintData = TintUtils.getSpawnEggTint(xMaterial)) == null) continue;
                    BufferedImage overlayImage = ((TextureResource)entry.getValue()).getTexture();
                    BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(overlayImage), tintData.getOverlay());
                    overlayImage = ImageUtils.multiply(overlayImage, colorOverlay);
                    entry.setValue(new GeneratedTextureResource(manager, overlayImage));
                    continue;
                }
                if (!(item.getItemMeta() instanceof LeatherArmorMeta)) continue;
                meta = (LeatherArmorMeta)item.getItemMeta();
                Color color = new Color(meta.getColor().asRGB());
                if (xMaterial.equals((Object)XMaterial.LEATHER_HORSE_ARMOR)) {
                    if (!overriddenResource.equalsIgnoreCase(ResourceRegistry.LEATHER_HORSE_ARMOR_PLACEHOLDER)) continue;
                    itemImage = ((TextureResource)entry.getValue()).getTexture(32, 32);
                    BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(itemImage), color);
                    itemImage = ImageUtils.multiply(itemImage, colorOverlay);
                    entry.setValue(new GeneratedTextureResource(manager, itemImage));
                    continue;
                }
                if (!overriddenResource.equalsIgnoreCase(ResourceRegistry.LEATHER_HELMET_PLACEHOLDER) && !overriddenResource.equalsIgnoreCase(ResourceRegistry.LEATHER_CHESTPLATE_PLACEHOLDER) && !overriddenResource.equalsIgnoreCase(ResourceRegistry.LEATHER_LEGGINGS_PLACEHOLDER) && !overriddenResource.equalsIgnoreCase(ResourceRegistry.LEATHER_BOOTS_PLACEHOLDER)) continue;
                itemImage = ((TextureResource)entry.getValue()).getTexture(32, 32);
                BufferedImage colorOverlay = ImageUtils.changeColorTo(ImageUtils.copyImage(itemImage), color);
                itemImage = ImageUtils.multiply(itemImage, colorOverlay);
                entry.setValue(new GeneratedTextureResource(manager, itemImage));
            }
            return result;
        })).orElse(null);
        return new ItemStackProcessResult(requiresEnchantmentGlint, predicates, providedTextures, tintIndexData, modelKey, postResolveFunction, enchantmentGlintFunction, rawEnchantmentGlintFunction);
    }

    public static class ItemStackProcessResult {
        private boolean requiresEnchantmentGlint;
        private Map<ModelOverride.ModelOverrideType, Float> predicates;
        private Map<String, TextureResource> providedTextures;
        private TintUtils.TintIndexData tintIndexData;
        private String modelKey;
        private Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> postResolveFunction;
        private UnaryOperator<BufferedImage> enchantmentGlintFunction;
        private Function<BufferedImage, ModelRenderer.RawEnchantmentGlintData> rawEnchantmentGlintFunction;

        public ItemStackProcessResult(boolean requiresEnchantmentGlint, Map<ModelOverride.ModelOverrideType, Float> predicates, Map<String, TextureResource> providedTextures, TintUtils.TintIndexData tintIndexData, String modelKey, Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> postResolveFunction, UnaryOperator<BufferedImage> enchantmentGlintFunction, Function<BufferedImage, ModelRenderer.RawEnchantmentGlintData> rawEnchantmentGlintFunction) {
            this.requiresEnchantmentGlint = requiresEnchantmentGlint;
            this.predicates = predicates;
            this.providedTextures = providedTextures;
            this.tintIndexData = tintIndexData;
            this.modelKey = modelKey;
            this.postResolveFunction = postResolveFunction;
            this.enchantmentGlintFunction = enchantmentGlintFunction;
            this.rawEnchantmentGlintFunction = rawEnchantmentGlintFunction;
        }

        public boolean requiresEnchantmentGlint() {
            return this.requiresEnchantmentGlint;
        }

        public Map<ModelOverride.ModelOverrideType, Float> getPredicates() {
            return this.predicates;
        }

        public Map<String, TextureResource> getProvidedTextures() {
            return this.providedTextures;
        }

        public TintUtils.TintIndexData getTintIndexData() {
            return this.tintIndexData;
        }

        public String getModelKey() {
            return this.modelKey;
        }

        public Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> getPostResolveFunction() {
            return this.postResolveFunction;
        }

        public UnaryOperator<BufferedImage> getEnchantmentGlintFunction() {
            return this.enchantmentGlintFunction;
        }

        public Function<BufferedImage, ModelRenderer.RawEnchantmentGlintData> getRawEnchantmentGlintFunction() {
            return this.rawEnchantmentGlintFunction;
        }
    }
}

