/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.objectholders.ValuePairs;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.ibm.icu.text.ArabicShaping;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.ibm.icu.text.Bidi;
import com.loohp.interactivechatdiscordsrvaddon.libs.com.ibm.icu.text.BidiRun;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.CharacterData;
import it.unimi.dsi.fastutil.chars.CharObjectPair;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class I18nUtils {
    public static String shaping(String str) {
        try {
            return new ArabicShaping(8).shape(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    public static List<CharObjectPair<CharacterData>> bidirectionalReorder(Component component, boolean rightToLeft) {
        ValuePairs<String, List<CharObjectPair<CharacterData>>> pair = CharacterData.fromComponent(component, str -> I18nUtils.shaping(str));
        List data = (List)pair.getSecond();
        Bidi bidi = new Bidi((String)pair.getFirst(), rightToLeft ? 127 : 126);
        bidi.setReorderingMode(0);
        ArrayList<CharObjectPair<CharacterData>> result = new ArrayList<CharObjectPair<CharacterData>>(data.size());
        int totalRuns = bidi.countRuns();
        for (int i = 0; i < totalRuns; ++i) {
            BidiRun bidiRun = bidi.getVisualRun(i);
            int start = bidiRun.getStart();
            int limit = bidiRun.getLimit();
            ArrayList<CharObjectPair> subResult = new ArrayList<CharObjectPair>(bidiRun.getLength());
            for (int u = start; u < limit; ++u) {
                if (u < 0 || u >= data.size()) continue;
                subResult.add((CharObjectPair)data.get(u));
            }
            if (bidiRun.isOddRun()) {
                ListIterator itr = subResult.listIterator(subResult.size());
                while (itr.hasPrevious()) {
                    result.add((CharObjectPair<CharacterData>)((CharObjectPair)itr.previous()));
                }
                continue;
            }
            result.addAll(subResult);
        }
        return result;
    }
}

