/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.utils.NMSUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.Player;
import org.bukkit.entity.TropicalFish;

public class FishUtils {
    private static final Map<Integer, Integer> PREDEFINED_TROPICAL_FISH = new HashMap<Integer, Integer>();
    private static Class<?> craftPlayerClass;
    private static Class<?> nmsEntityHumanClass;
    private static Class<?> nmsEntityFishingHookClass;
    private static Method getNmsEntityPlayerMethod;
    private static Field nmsHumanFishingHookField;
    private static Method nmsGetBukkitEntityMethod;

    public static int getPredefinedType(int variance) {
        return PREDEFINED_TROPICAL_FISH.getOrDefault(variance, -1);
    }

    public static int calculateTropicalFishVariant(TropicalFish.Pattern bukkitPattern, DyeColor bodyColor, DyeColor patternColor) {
        TropicalFishPattern pattern = TropicalFishPattern.fromPattern(bukkitPattern);
        return pattern.getBase() & 0xFF | (pattern.getIndex() & 0xFF) << 8 | (bodyColor.getWoolData() & 0xFF) << 16 | (patternColor.getWoolData() & 0xFF) << 24;
    }

    public static int getTropicalFishBaseColorIdx(int variance) {
        return (variance & 0xFF0000) >> 16;
    }

    public static int getTropicalFishPatternColorIdx(int variance) {
        return (variance & 0xFF000000) >> 24;
    }

    public static int getTropicalFishBaseVariant(int variance) {
        return Math.min(variance & 0xFF, 1);
    }

    public static int getTropicalFishPatternVariant(int variance) {
        return Math.min((variance & 0xFF00) >> 8, 5);
    }

    public static DyeColor getTropicalFishBaseColor(int variance) {
        return DyeColor.getByWoolData((byte)((byte)FishUtils.getTropicalFishBaseColorIdx(variance)));
    }

    public static DyeColor getTropicalFishPatternColor(int variance) {
        return DyeColor.getByWoolData((byte)((byte)FishUtils.getTropicalFishPatternColorIdx(variance)));
    }

    public static String getTropicalFishTypeName(int variance) {
        int base = FishUtils.getTropicalFishBaseVariant(variance);
        int index = FishUtils.getTropicalFishPatternVariant(variance);
        return TropicalFishPattern.getPatternName(base, index);
    }

    public static FishHook getPlayerFishingHook(Player player) {
        try {
            Object craftPlayer = craftPlayerClass.cast(player);
            Object nmsEntityPlayer = getNmsEntityPlayerMethod.invoke(craftPlayer, new Object[0]);
            Object nmsEntityFishingHook = nmsHumanFishingHookField.get(nmsEntityPlayer);
            if (nmsEntityFishingHook == null) {
                return null;
            }
            return (FishHook)nmsGetBukkitEntityMethod.invoke(nmsEntityFishingHook, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            craftPlayerClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.entity.CraftPlayer", (String[])new String[0]);
            nmsEntityHumanClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.EntityHuman", (String[])new String[]{"net.minecraft.world.entity.player.EntityHuman"});
            nmsEntityFishingHookClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.EntityFishingHook", (String[])new String[]{"net.minecraft.world.entity.projectile.EntityFishingHook"});
            getNmsEntityPlayerMethod = craftPlayerClass.getMethod("getHandle", new Class[0]);
            nmsHumanFishingHookField = Arrays.stream(nmsEntityHumanClass.getFields()).filter(each -> each.getType().equals(nmsEntityFishingHookClass)).findFirst().get();
            nmsGetBukkitEntityMethod = nmsEntityFishingHookClass.getMethod("getBukkitEntity", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.STRIPEY, DyeColor.ORANGE, DyeColor.GRAY), 0);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.FLOPPER, DyeColor.GRAY, DyeColor.GRAY), 1);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.FLOPPER, DyeColor.GRAY, DyeColor.BLUE), 2);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.GRAY), 3);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.SUNSTREAK, DyeColor.BLUE, DyeColor.GRAY), 4);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.KOB, DyeColor.ORANGE, DyeColor.WHITE), 5);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.SPOTTY, DyeColor.PINK, DyeColor.LIGHT_BLUE), 6);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.BLOCKFISH, DyeColor.PURPLE, DyeColor.YELLOW), 7);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.RED), 8);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.SPOTTY, DyeColor.WHITE, DyeColor.YELLOW), 9);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.GLITTER, DyeColor.WHITE, DyeColor.GRAY), 10);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.CLAYFISH, DyeColor.WHITE, DyeColor.ORANGE), 11);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.DASHER, DyeColor.CYAN, DyeColor.PINK), 12);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.BRINELY, DyeColor.LIME, DyeColor.LIGHT_BLUE), 13);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.BETTY, DyeColor.RED, DyeColor.WHITE), 14);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.SNOOPER, DyeColor.GRAY, DyeColor.RED), 15);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.BLOCKFISH, DyeColor.RED, DyeColor.WHITE), 16);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.FLOPPER, DyeColor.WHITE, DyeColor.YELLOW), 17);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.KOB, DyeColor.RED, DyeColor.WHITE), 18);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.SUNSTREAK, DyeColor.GRAY, DyeColor.WHITE), 19);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.DASHER, DyeColor.CYAN, DyeColor.YELLOW), 20);
        PREDEFINED_TROPICAL_FISH.put(FishUtils.calculateTropicalFishVariant(TropicalFish.Pattern.FLOPPER, DyeColor.YELLOW, DyeColor.YELLOW), 21);
    }

    public static enum TropicalFishPattern {
        KOB(0, 0),
        SUNSTREAK(0, 1),
        SNOOPER(0, 2),
        DASHER(0, 3),
        BRINELY(0, 4),
        SPOTTY(0, 5),
        FLOPPER(1, 0),
        STRIPEY(1, 1),
        GLITTER(1, 2),
        BLOCKFISH(1, 3),
        BETTY(1, 4),
        CLAYFISH(1, 5);

        private static final TropicalFishPattern[] VALUES;
        private final int base;
        private final int index;

        public static String getPatternName(int base, int index) {
            return VALUES[index + 6 * base].getName();
        }

        public static TropicalFishPattern fromPattern(TropicalFish.Pattern pattern) {
            for (TropicalFishPattern wrapper : VALUES) {
                if (!wrapper.name().equals(pattern.name())) continue;
                return wrapper;
            }
            return null;
        }

        private TropicalFishPattern(int base, int index) {
            this.base = base;
            this.index = index;
        }

        public int getBase() {
            return this.base;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = TropicalFishPattern.values();
        }
    }
}

