/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactivechat.objectholders.ICPlayer;
import com.loohp.interactivechat.objectholders.OfflineICPlayer;
import com.loohp.interactivechat.objectholders.ValuePairs;
import com.loohp.interactivechat.utils.BookUtils;
import com.loohp.interactivechat.utils.FilledMapUtils;
import com.loohp.interactivechat.utils.InteractiveChatComponentSerializer;
import com.loohp.interactivechat.utils.ItemStackUtils;
import com.loohp.interactivechat.utils.LanguageUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.debug.Debug;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageGeneration;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.listeners.DiscordInteractionEvents;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.DiscordDisplayData;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.DiscordMessageContent;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.HoverClickDisplayData;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.ImageDisplayData;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.ImageDisplayType;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.InteractionHandler;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.ToolTipComponent;
import com.loohp.interactivechatdiscordsrvaddon.resources.CustomItemTextureRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelDisplay;
import com.loohp.interactivechatdiscordsrvaddon.utils.ComponentStringUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.DiscordItemStackUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.TranslationKeyUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.URLRequestUtils;
import com.loohp.interactivechatdiscordsrvaddon.wrappers.TitledInventoryWrapper;
import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.entities.Message;
import github.scarsz.discordsrv.dependencies.jda.api.entities.MessageEmbed;
import github.scarsz.discordsrv.dependencies.jda.api.entities.SelfUser;
import github.scarsz.discordsrv.dependencies.jda.api.entities.User;
import github.scarsz.discordsrv.dependencies.jda.api.events.interaction.GenericComponentInteractionCreateEvent;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.ActionRow;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Button;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.Component;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.selections.SelectOption;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.selections.SelectionMenu;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.components.selections.SelectionMenuInteraction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.WebhookMessageUpdateAction;
import github.scarsz.discordsrv.dependencies.jda.api.requests.restaction.interactions.ReplyAction;
import github.scarsz.discordsrv.dependencies.jda.api.utils.AttachmentOption;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;

public class DiscordContentUtils {
    public static final Color OFFSET_WHITE = new Color(0xFFFFFE);
    public static final String BOOK_EMOJI = "\ud83d\udcd6";
    public static final String LEFT_EMOJI = "\u2b05\ufe0f";
    public static final String RIGHT_EMOJI = "\u27a1\ufe0f";

    public static ValuePairs<List<DiscordMessageContent>, InteractionHandler> createContents(List<DiscordDisplayData> dataList, OfflineICPlayer player) {
        ArrayList<DiscordMessageContent> contents = new ArrayList<DiscordMessageContent>();
        ArrayList<ActionRow> interactionsToRegister = new ArrayList<ActionRow>();
        ArrayList<String> interactions = new ArrayList<String>();
        BiConsumer<GenericComponentInteractionCreateEvent, List<DiscordMessageContent>> interactionConsumer = (event, discordMessageContents) -> {};
        int i = -1;
        for (DiscordDisplayData data : dataList) {
            ++i;
            if (data instanceof ImageDisplayData) {
                DiscordMessageContent content;
                byte[] imageData;
                ImageDisplayData iData = (ImageDisplayData)data;
                ImageDisplayType type = iData.getType();
                String title = iData.getTitle();
                if (iData.getItemStack().isPresent()) {
                    Debug.debug("createContents creating item discord content");
                    ItemStack item = iData.getItemStack().get();
                    Color color = DiscordItemStackUtils.getDiscordColor(item);
                    if (color == null || color.equals(Color.WHITE)) {
                        color = OFFSET_WHITE;
                    }
                    try {
                        BufferedImage image = ImageGeneration.getItemStackImage(item, data.getPlayer(), InteractiveChatDiscordSrvAddon.plugin.itemAltAir, 48);
                        imageData = ImageUtils.toArray(image);
                        content = new DiscordMessageContent(title, null, color);
                        content.setTitle(DiscordItemStackUtils.getItemNameForDiscord(item, player, InteractiveChatDiscordSrvAddon.plugin.language));
                        content.setThumbnail("attachment://Item_" + i + ".png");
                        content.addAttachment("Item_" + i + ".png", imageData);
                        contents.add(content);
                        DiscordItemStackUtils.DiscordToolTip discordToolTip = DiscordItemStackUtils.getToolTip(item, player);
                        List<ToolTipComponent<?>> toolTipComponents = discordToolTip.getComponents();
                        boolean forceShow = false;
                        if (type.equals((Object)ImageDisplayType.ITEM_CONTAINER)) {
                            TitledInventoryWrapper inv = iData.getInventory().get();
                            BufferedImage container = ImageGeneration.getInventoryImage(inv.getInventory(), inv.getTitle(), data.getPlayer());
                            toolTipComponents.add(ToolTipComponent.image(container));
                            forceShow = true;
                            UUID interactionUuid = UUID.randomUUID();
                            ArrayList<SelectOption> options = new ArrayList<SelectOption>();
                            for (int u = 0; u < inv.getInventory().getSize(); ++u) {
                                ItemStack itemStack = inv.getInventory().getItem(u);
                                if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
                                com.loohp.interactivechat.libs.net.kyori.adventure.text.Component name = ItemStackUtils.getDisplayName((ItemStack)itemStack);
                                String label = u + 1 + " - " + PlainTextComponentSerializer.plainText().serialize(ComponentStringUtils.resolve(name, InteractiveChatDiscordSrvAddon.plugin.resourceManager.getLanguageManager().getTranslateFunction().ofLanguage(InteractiveChatDiscordSrvAddon.plugin.language)));
                                if (label.length() > 100) {
                                    ItemStack stripNameItem = itemStack.clone();
                                    if (stripNameItem.hasItemMeta()) {
                                        ItemMeta meta = stripNameItem.getItemMeta();
                                        meta.setDisplayName(null);
                                        stripNameItem.setItemMeta(meta);
                                    }
                                    name = ItemStackUtils.getDisplayName((ItemStack)stripNameItem);
                                    label = u + 1 + " - " + PlainTextComponentSerializer.plainText().serialize(ComponentStringUtils.resolve(name, InteractiveChatDiscordSrvAddon.plugin.resourceManager.getLanguageManager().getTranslateFunction().ofLanguage(InteractiveChatDiscordSrvAddon.plugin.language)));
                                }
                                options.add(SelectOption.of((String)label, (String)String.valueOf(u)));
                            }
                            int j = 0;
                            for (int u = 0; u < options.size(); u += 25) {
                                String id = DiscordInteractionEvents.INTERACTION_ID_PREFIX + "inventory_item_" + interactionUuid + "_" + ++j;
                                interactionsToRegister.add(ActionRow.of((Component[])new Component[]{SelectionMenu.create((String)id).addOptions(options.subList(u, Math.min(u + 25, options.size()))).build()}));
                                interactions.add(id);
                            }
                            interactionConsumer = interactionConsumer.andThen(DiscordContentUtils.getInventoryHandler(interactionUuid, inv.getInventory(), data.getPlayer()));
                        } else if (iData.isFilledMap()) {
                            forceShow = true;
                        }
                        if (forceShow || !discordToolTip.isBaseItem() || InteractiveChatDiscordSrvAddon.plugin.itemUseTooltipImageOnBaseItem) {
                            BufferedImage tooltip = ImageGeneration.getToolTipImage(toolTipComponents);
                            if (iData.isFilledMap()) {
                                boolean isPlayerLocal;
                                MapView mapView = FilledMapUtils.getMapView((ItemStack)item);
                                boolean isContextual = mapView == null || FilledMapUtils.isContextual((MapView)mapView);
                                ICPlayer icPlayer = iData.getPlayer().getPlayer();
                                boolean bl = isPlayerLocal = icPlayer != null && icPlayer.isLocal();
                                if (!isContextual || isPlayerLocal) {
                                    BufferedImage map = ImageGeneration.getMapImage(item, isPlayerLocal ? icPlayer.getLocalPlayer() : null).get();
                                    tooltip = ImageUtils.resizeImage(tooltip, 5.0);
                                    tooltip = ImageUtils.appendImageBottom(tooltip, map, 10, 0);
                                }
                            }
                            byte[] tooltipData = ImageUtils.toArray(tooltip);
                            content.addAttachment("ToolTip_" + i + ".png", tooltipData);
                            content.addImageUrl("attachment://ToolTip_" + i + ".png");
                        }
                        if (!iData.isBook()) continue;
                        List pages = BookUtils.getPages((BookMeta)((BookMeta)item.getItemMeta()));
                        List<Supplier<BufferedImage>> images = ImageGeneration.getBookInterfaceSuppliers(pages);
                        byte[][] cachedImages = new byte[images.size()][];
                        cachedImages[0] = ImageUtils.toArray(images.get(0).get());
                        if (images.isEmpty()) continue;
                        UUID interactionUuid = UUID.randomUUID();
                        interactionsToRegister.add(ActionRow.of((Component[])new Component[]{Button.secondary((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "open_book_" + interactionUuid), (String)BOOK_EMOJI)}));
                        interactions.add(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "open_book_" + interactionUuid);
                        interactions.add(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "left_book_" + interactionUuid);
                        interactions.add(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "right_book_" + interactionUuid);
                        interactions.add(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "selection_book_" + interactionUuid);
                        interactionConsumer = interactionConsumer.andThen(DiscordContentUtils.getBookHandler(interactionUuid, color, images, cachedImages));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!iData.getInventory().isPresent()) continue;
                Debug.debug("createContents creating inventory discord content");
                TitledInventoryWrapper inv = iData.getInventory().get();
                try {
                    Color color;
                    BufferedImage image = iData.isPlayerInventory() ? (InteractiveChatDiscordSrvAddon.plugin.usePlayerInvView ? ImageGeneration.getPlayerInventoryImage(inv.getInventory(), iData.getPlayer()) : ImageGeneration.getInventoryImage(inv.getInventory(), inv.getTitle(), data.getPlayer())) : ImageGeneration.getInventoryImage(inv.getInventory(), inv.getTitle(), data.getPlayer());
                    switch (type) {
                        case ENDERCHEST: {
                            color = InteractiveChatDiscordSrvAddon.plugin.enderColor;
                            break;
                        }
                        case INVENTORY: {
                            color = InteractiveChatDiscordSrvAddon.plugin.invColor;
                            break;
                        }
                        default: {
                            color = Color.black;
                        }
                    }
                    imageData = ImageUtils.toArray(image);
                    content = new DiscordMessageContent(title, null, null, "attachment://Inventory_" + i + ".png", color);
                    content.addAttachment("Inventory_" + i + ".png", imageData);
                    if (type.equals((Object)ImageDisplayType.INVENTORY) && InteractiveChatDiscordSrvAddon.plugin.invShowLevel) {
                        int level = iData.getPlayer().getExperienceLevel();
                        byte[] bottleData = ImageUtils.toArray(InteractiveChatDiscordSrvAddon.plugin.modelRenderer.render(32, 32, InteractiveChatDiscordSrvAddon.plugin.resourceManager, InteractiveChatDiscordSrvAddon.plugin.resourceManager.getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).getItemPostResolveFunction("minecraft:item/experience_bottle", null, XMaterial.EXPERIENCE_BOTTLE.parseItem(), InteractiveChat.version.isOld(), null, null, null, null, InteractiveChatDiscordSrvAddon.plugin.resourceManager.getLanguageManager().getTranslateFunction().ofLanguage(InteractiveChatDiscordSrvAddon.plugin.language)).orElse(null), InteractiveChat.version.isOld(), "minecraft:item/experience_bottle", ModelDisplay.ModelDisplayPosition.GUI, false, null, null).getImage());
                        content.addAttachment("Level_" + i + ".png", bottleData);
                        content.setFooter(ComponentStringUtils.convertFormattedString(LanguageUtils.getTranslation((String)TranslationKeyUtils.getLevelTranslation(level), (String)InteractiveChatDiscordSrvAddon.plugin.language), level));
                        content.setFooterImageUrl("attachment://Level_" + i + ".png");
                    }
                    contents.add(content);
                    UUID interactionUuid = UUID.randomUUID();
                    ArrayList<SelectOption> options = new ArrayList<SelectOption>();
                    for (int u = 0; u < inv.getInventory().getSize(); ++u) {
                        ItemStack itemStack = inv.getInventory().getItem(u);
                        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) continue;
                        com.loohp.interactivechat.libs.net.kyori.adventure.text.Component name = ItemStackUtils.getDisplayName((ItemStack)itemStack);
                        String label = u + 1 + " - " + PlainTextComponentSerializer.plainText().serialize(ComponentStringUtils.resolve(name, InteractiveChatDiscordSrvAddon.plugin.resourceManager.getLanguageManager().getTranslateFunction().ofLanguage(InteractiveChatDiscordSrvAddon.plugin.language)));
                        if (label.length() > 100) {
                            ItemStack stripNameItem = itemStack.clone();
                            if (stripNameItem.hasItemMeta()) {
                                ItemMeta meta = stripNameItem.getItemMeta();
                                meta.setDisplayName(null);
                                stripNameItem.setItemMeta(meta);
                            }
                            name = ItemStackUtils.getDisplayName((ItemStack)stripNameItem);
                            label = u + 1 + " - " + PlainTextComponentSerializer.plainText().serialize(ComponentStringUtils.resolve(name, InteractiveChatDiscordSrvAddon.plugin.resourceManager.getLanguageManager().getTranslateFunction().ofLanguage(InteractiveChatDiscordSrvAddon.plugin.language)));
                        }
                        options.add(SelectOption.of((String)label, (String)String.valueOf(u)));
                    }
                    int j = 0;
                    for (int u = 0; u < options.size(); u += 25) {
                        String id = DiscordInteractionEvents.INTERACTION_ID_PREFIX + "inventory_item_" + interactionUuid + "_" + ++j;
                        interactionsToRegister.add(ActionRow.of((Component[])new Component[]{SelectionMenu.create((String)id).addOptions(options.subList(u, Math.min(u + 25, options.size()))).build()}));
                        interactions.add(id);
                    }
                    interactionConsumer = interactionConsumer.andThen(DiscordContentUtils.getInventoryHandler(interactionUuid, inv.getInventory(), data.getPlayer()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(data instanceof HoverClickDisplayData)) continue;
            Debug.debug("createContents creating hover event discord content");
            try {
                HoverClickDisplayData hData = (HoverClickDisplayData)data;
                String title = hData.getDisplayText();
                Color color = hData.getColor();
                DiscordMessageContent content = new DiscordMessageContent(title, null, color);
                String body = "";
                String preview = null;
                if (hData.hasHover()) {
                    if (InteractiveChatDiscordSrvAddon.plugin.hoverUseTooltipImage) {
                        com.loohp.interactivechat.libs.net.kyori.adventure.text.Component print = hData.getHoverText();
                        BufferedImage tooltip = ImageGeneration.getToolTipImage(print, true);
                        byte[] tooltipData = ImageUtils.toArray(tooltip);
                        content.addAttachment("ToolTip_" + i + ".png", tooltipData);
                        content.addImageUrl("attachment://ToolTip_" + i + ".png");
                        content.addDescription(null);
                    } else {
                        body = body + ComponentStringUtils.stripColorAndConvertMagic(InteractiveChatComponentSerializer.bungeecordApiLegacy().serialize(hData.getHoverText()));
                    }
                }
                if (hData.hasClick()) {
                    switch (hData.getClickAction()) {
                        case COPY_TO_CLIPBOARD: {
                            if (body.length() > 0) {
                                body = body + "\n\n";
                            }
                            body = body + LanguageUtils.getTranslation((String)TranslationKeyUtils.getCopyToClipboard(), (String)InteractiveChatDiscordSrvAddon.plugin.language) + ": __" + hData.getClickValue() + "__";
                            break;
                        }
                        case OPEN_URL: {
                            if (body.length() > 0) {
                                body = body + "\n\n";
                            }
                            String url = hData.getClickValue();
                            body = body + LanguageUtils.getTranslation((String)TranslationKeyUtils.getOpenUrl(), (String)InteractiveChatDiscordSrvAddon.plugin.language) + ": __" + url + "__";
                            if (!URLRequestUtils.IMAGE_URL_PATTERN.matcher(url).matches() || !URLRequestUtils.isAllowed(url)) break;
                            preview = url;
                            break;
                        }
                    }
                }
                if (!body.isEmpty()) {
                    content.addDescription(body);
                }
                if (InteractiveChatDiscordSrvAddon.plugin.hoverImage) {
                    BufferedImage image = InteractiveChatDiscordSrvAddon.plugin.resourceManager.getTextureManager().getTexture("minecraft:interactivechatdiscordsrvaddon/misc/hover_cursor").getTexture();
                    byte[] imageData = ImageUtils.toArray(image);
                    content.setAuthorIconUrl("attachment://Hover_" + i + ".png");
                    content.addAttachment("Hover_" + i + ".png", imageData);
                }
                if (preview != null) {
                    content.addImageUrl(preview);
                }
                contents.add(content);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ValuePairs(contents, (Object)new InteractionHandler(interactionsToRegister, interactions, InteractiveChat.itemDisplayTimeout, interactionConsumer));
    }

    private static BiConsumer<GenericComponentInteractionCreateEvent, List<DiscordMessageContent>> getInventoryHandler(UUID interactionUuid, Inventory inventory, OfflineICPlayer player) {
        return (event, discordMessageContents) -> {
            int slot;
            User user;
            SelfUser self = DiscordSRV.getPlugin().getJda().getSelfUser();
            if (self.equals(user = event.getUser())) {
                return;
            }
            String id = event.getComponent().getId();
            if (id.startsWith(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "inventory_item_" + interactionUuid + "_") && event.getInteraction() instanceof SelectionMenuInteraction && (slot = Integer.parseInt((String)((SelectionMenuInteraction)event.getInteraction()).getValues().get(0))) >= 0 && slot < inventory.getSize()) {
                event.deferReply().setEphemeral(true).queue();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> {
                    Color color;
                    ItemStack item = inventory.getItem(slot);
                    if (item == null) {
                        item = new ItemStack(Material.AIR);
                    }
                    if ((color = DiscordItemStackUtils.getDiscordColor(item)) == null || color.equals(Color.WHITE)) {
                        color = OFFSET_WHITE;
                    }
                    try {
                        BufferedImage image = ImageGeneration.getItemStackImage(item, player, InteractiveChatDiscordSrvAddon.plugin.itemAltAir, 48);
                        byte[] imageData = ImageUtils.toArray(image);
                        DiscordMessageContent content = new DiscordMessageContent(null, null, color);
                        content.setTitle(DiscordItemStackUtils.getItemNameForDiscord(item, player, InteractiveChatDiscordSrvAddon.plugin.language));
                        content.setThumbnail("attachment://Item.png");
                        content.addAttachment("Item.png", imageData);
                        DiscordItemStackUtils.DiscordToolTip discordToolTip = DiscordItemStackUtils.getToolTip(item, player);
                        List<ToolTipComponent<?>> toolTipComponents = discordToolTip.getComponents();
                        if (!discordToolTip.isBaseItem() || InteractiveChatDiscordSrvAddon.plugin.itemUseTooltipImageOnBaseItem) {
                            BufferedImage tooltip = ImageGeneration.getToolTipImage(toolTipComponents);
                            byte[] tooltipData = ImageUtils.toArray(tooltip);
                            content.addAttachment("ToolTip.png", tooltipData);
                            content.addImageUrl("attachment://ToolTip.png");
                        }
                        WebhookMessageUpdateAction action = event.getHook().setEphemeral(true).editOriginalEmbeds((Collection)content.toJDAMessageEmbeds().getFirst());
                        for (Map.Entry<String, byte[]> entry : content.getAttachments().entrySet()) {
                            action.addFile(entry.getValue(), entry.getKey(), new AttachmentOption[0]);
                        }
                        action.queue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        };
    }

    private static BiConsumer<GenericComponentInteractionCreateEvent, List<DiscordMessageContent>> getBookHandler(UUID interactionUuid, Color color, List<Supplier<BufferedImage>> imageSuppliers, byte[][] cachedImages) {
        ConcurrentHashMap currentPages = new ConcurrentHashMap();
        List selectOptions = IntStream.range(1, cachedImages.length + 1).mapToObj(i -> {
            String asText = String.valueOf(i);
            return SelectOption.of((String)ComponentStringUtils.convertFormattedString(LanguageUtils.getTranslation((String)TranslationKeyUtils.getBookPageIndicator(), (String)InteractiveChatDiscordSrvAddon.plugin.language), i, cachedImages.length), (String)asText);
        }).collect(Collectors.toList());
        return (event, discordMessageContents) -> {
            User user;
            SelfUser self = DiscordSRV.getPlugin().getJda().getSelfUser();
            if (self.equals(user = event.getUser())) {
                return;
            }
            String id = event.getComponent().getId();
            Message message = event.getMessage();
            if (id.equals(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "open_book_" + interactionUuid)) {
                AtomicInteger currentPage = new AtomicInteger(0);
                currentPages.put(user.getId(), currentPage);
                DiscordMessageContent bookContent = new DiscordMessageContent(null, null, null, "attachment://Page.png", color);
                bookContent.addAttachment("Page.png", cachedImages[0]);
                ValuePairs<List<MessageEmbed>, Set<String>> pair = bookContent.toJDAMessageEmbeds();
                ReplyAction action = event.replyEmbeds((Collection)pair.getFirst()).setEphemeral(true);
                for (String name : (Set)pair.getSecond()) {
                    action = action.addFile(bookContent.getAttachments().get(name), name, new AttachmentOption[0]);
                }
                Button leftButton = Button.danger((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "left_book_" + interactionUuid), (String)LEFT_EMOJI).asDisabled();
                Button rightButton = Button.success((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "right_book_" + interactionUuid), (String)RIGHT_EMOJI);
                if (cachedImages.length <= 1) {
                    rightButton = rightButton.asDisabled();
                }
                SelectionMenu selectionMenu = SelectionMenu.create((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "selection_book_" + interactionUuid)).setRequiredRange(1, 1).addOptions((Collection)selectOptions).setDefaultValues(Arrays.asList("1")).build();
                action.addActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{leftButton, rightButton}), ActionRow.of((Component[])new Component[]{selectionMenu})}).queue(h -> h.retrieveOriginal().queue(m -> DiscordInteractionEvents.getInteractionData(id).getMessageIds().add(m.getTextChannel().getId() + "/" + m.getId())));
                return;
            }
            event.deferEdit().queue();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> {
                AtomicInteger currentPage = (AtomicInteger)currentPages.get(user.getId());
                if (currentPage == null) {
                    currentPage = new AtomicInteger(0);
                    currentPages.put(user.getId(), currentPage);
                }
                AtomicInteger atomicInteger = currentPage;
                synchronized (atomicInteger) {
                    if (id.equals(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "selection_book_" + interactionUuid) && event.getInteraction() instanceof SelectionMenuInteraction) {
                        int pageNumber = currentPage.updateAndGet(i -> Integer.parseInt((String)((SelectionMenuInteraction)event.getInteraction()).getValues().get(0)) - 1);
                        byte[] pageFile = cachedImages[pageNumber];
                        if (pageFile == null) {
                            try {
                                pageFile = ImageUtils.toArray((BufferedImage)((Supplier)imageSuppliers.get(pageNumber)).get());
                                cachedImages[pageNumber] = pageFile;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        WebhookMessageUpdateAction action = event.getHook().editOriginal(message.getContentRaw()).retainFiles(Collections.emptyList()).addFile(pageFile, "Page.png", new AttachmentOption[0]);
                        Button leftButton = Button.danger((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "left_book_" + interactionUuid), (String)LEFT_EMOJI);
                        if (currentPage.get() <= 0) {
                            leftButton = leftButton.asDisabled();
                        }
                        Button rightButton = Button.success((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "right_book_" + interactionUuid), (String)RIGHT_EMOJI);
                        if (currentPage.get() >= cachedImages.length - 1) {
                            rightButton = rightButton.asDisabled();
                        }
                        SelectionMenu selectionMenu = SelectionMenu.create((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "selection_book_" + interactionUuid)).setRequiredRange(1, 1).addOptions((Collection)selectOptions).setDefaultValues(Arrays.asList(String.valueOf(currentPage.get() + 1))).build();
                        action.setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{leftButton, rightButton}), ActionRow.of((Component[])new Component[]{selectionMenu})}).queue();
                    } else if (id.equals(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "left_book_" + interactionUuid)) {
                        if (currentPage.get() > 0) {
                            int pageNumber = currentPage.decrementAndGet();
                            byte[] pageFile = cachedImages[pageNumber];
                            if (pageFile == null) {
                                try {
                                    pageFile = ImageUtils.toArray((BufferedImage)((Supplier)imageSuppliers.get(pageNumber)).get());
                                    cachedImages[pageNumber] = pageFile;
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            WebhookMessageUpdateAction action = event.getHook().editOriginal(message.getContentRaw()).retainFiles(Collections.emptyList()).addFile(pageFile, "Page.png", new AttachmentOption[0]);
                            Button leftButton = Button.danger((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "left_book_" + interactionUuid), (String)LEFT_EMOJI);
                            if (currentPage.get() <= 0) {
                                leftButton = leftButton.asDisabled();
                            }
                            Button rightButton = Button.success((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "right_book_" + interactionUuid), (String)RIGHT_EMOJI);
                            if (currentPage.get() >= cachedImages.length - 1) {
                                rightButton = rightButton.asDisabled();
                            }
                            SelectionMenu selectionMenu = SelectionMenu.create((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "selection_book_" + interactionUuid)).setRequiredRange(1, 1).addOptions((Collection)selectOptions).setDefaultValues(Arrays.asList(String.valueOf(currentPage.get() + 1))).build();
                            action.setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{leftButton, rightButton}), ActionRow.of((Component[])new Component[]{selectionMenu})}).queue();
                        }
                    } else if (id.equals(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "right_book_" + interactionUuid) && currentPage.get() < cachedImages.length - 1) {
                        int pageNumber = currentPage.incrementAndGet();
                        byte[] pageFile = cachedImages[pageNumber];
                        if (pageFile == null) {
                            try {
                                pageFile = ImageUtils.toArray((BufferedImage)((Supplier)imageSuppliers.get(pageNumber)).get());
                                cachedImages[pageNumber] = pageFile;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        WebhookMessageUpdateAction action = event.getHook().editOriginal(message.getContentRaw()).retainFiles(Collections.emptyList()).addFile(pageFile, "Page.png", new AttachmentOption[0]);
                        Button leftButton = Button.danger((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "left_book_" + interactionUuid), (String)LEFT_EMOJI);
                        if (currentPage.get() <= 0) {
                            leftButton = leftButton.asDisabled();
                        }
                        Button rightButton = Button.success((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "right_book_" + interactionUuid), (String)RIGHT_EMOJI);
                        if (currentPage.get() >= cachedImages.length - 1) {
                            rightButton = rightButton.asDisabled();
                        }
                        SelectionMenu selectionMenu = SelectionMenu.create((String)(DiscordInteractionEvents.INTERACTION_ID_PREFIX + "selection_book_" + interactionUuid)).setRequiredRange(1, 1).addOptions((Collection)selectOptions).setDefaultValues(Arrays.asList(String.valueOf(currentPage.get() + 1))).build();
                        action.setActionRows(new ActionRow[]{ActionRow.of((Component[])new Component[]{leftButton, rightButton}), ActionRow.of((Component[])new Component[]{selectionMenu})}).queue();
                    }
                }
            });
        };
    }
}

