/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.Command;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.OptionType;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.CommandData;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.OptionData;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.SubcommandData;
import github.scarsz.discordsrv.dependencies.jda.api.interactions.commands.build.SubcommandGroupData;
import java.util.Collection;

public class DiscordCommandDataUtils {
    public static CommandData toCommandData(Command command) {
        CommandData commandData = new CommandData(command.getName(), command.getDescription()).setDefaultEnabled(command.isDefaultEnabled());
        for (Command.Option option : command.getOptions()) {
            commandData.addOptions(new OptionData[]{DiscordCommandDataUtils.toCommandData(option)});
        }
        for (Command.Subcommand subcommand : command.getSubcommands()) {
            commandData.addSubcommands(new SubcommandData[]{DiscordCommandDataUtils.toCommandData(subcommand)});
        }
        for (Command.SubcommandGroup subcommandGroup : command.getSubcommandGroups()) {
            commandData.addSubcommandGroups(new SubcommandGroupData[]{DiscordCommandDataUtils.toCommandData(subcommandGroup)});
        }
        return commandData;
    }

    public static SubcommandData toCommandData(Command.Subcommand command) {
        SubcommandData subcommandData = new SubcommandData(command.getName(), command.getDescription());
        for (Command.Option option : command.getOptions()) {
            subcommandData.addOptions(new OptionData[]{DiscordCommandDataUtils.toCommandData(option)});
        }
        return subcommandData;
    }

    public static SubcommandGroupData toCommandData(Command.SubcommandGroup command) {
        SubcommandGroupData subcommandGroupData = new SubcommandGroupData(command.getName(), command.getDescription());
        for (Command.Subcommand subcommand : command.getSubcommands()) {
            subcommandGroupData.addSubcommands(new SubcommandData[]{DiscordCommandDataUtils.toCommandData(subcommand)});
        }
        return subcommandGroupData;
    }

    public static OptionData toCommandData(Command.Option option) {
        OptionData optionData = new OptionData(option.getType(), option.getName(), option.getDescription(), option.isRequired());
        if (option.getType() == OptionType.NUMBER) {
            if (option.getMaxValue() instanceof Double) {
                optionData.setMaxValue(option.getMaxValue().doubleValue());
            } else {
                optionData.setMaxValue(option.getMaxValue().longValue());
            }
            if (option.getMinValue() instanceof Double) {
                optionData.setMinValue(option.getMinValue().doubleValue());
            } else {
                optionData.setMinValue(option.getMinValue().longValue());
            }
        }
        for (Command.Choice choice : option.getChoices()) {
            if (option.getType() == OptionType.INTEGER) {
                optionData.addChoice(choice.getName(), choice.getAsLong());
                continue;
            }
            if (option.getType() == OptionType.STRING) {
                optionData.addChoice(choice.getName(), choice.getAsString());
                continue;
            }
            if (option.getType() != OptionType.NUMBER) {
                throw new IllegalArgumentException("Cannot add choice for type " + option.getType());
            }
            optionData.addChoice(choice.getName(), choice.getAsDouble());
        }
        if (optionData.getType() == OptionType.CHANNEL) {
            optionData.setChannelTypes((Collection)option.getChannelTypes());
        }
        return optionData;
    }
}

