/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechat.libs.net.kyori.adventure.key.Key;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.BlockNBTComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.EntityNBTComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.KeybindComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.ScoreComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.StorageNBTComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.TranslatableComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.event.HoverEvent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextDecoration;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import com.loohp.interactivechat.libs.org.apache.commons.lang3.RandomStringUtils;
import com.loohp.interactivechat.objectholders.LegacyIdKey;
import com.loohp.interactivechat.utils.ComponentCompacting;
import com.loohp.interactivechat.utils.ComponentFlattening;
import com.loohp.interactivechat.utils.ComponentModernizing;
import com.loohp.interactivechat.utils.InteractiveChatComponentSerializer;
import com.loohp.interactivechat.utils.ItemNBTUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.fonts.FontProvider;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.Component;
import github.scarsz.discordsrv.dependencies.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;

public class ComponentStringUtils {
    private static final Pattern ARG_FORMAT = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public static List<com.loohp.interactivechat.libs.net.kyori.adventure.text.Component> applyWordWrap(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component component, UnaryOperator<String> translateFunction, int lineLengthLimit, ToIntFunction<CharacterLengthProviderData> characterLengthProvider) {
        ArrayList<com.loohp.interactivechat.libs.net.kyori.adventure.text.Component> result = new ArrayList<com.loohp.interactivechat.libs.net.kyori.adventure.text.Component>();
        int x = 0;
        List child = ComponentFlattening.flatten((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)component).children();
        TextComponent currentLine = com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.empty();
        boolean nullCurrentLine = true;
        for (com.loohp.interactivechat.libs.net.kyori.adventure.text.Component each : child) {
            Key font = each.font();
            List<TextDecoration> decorations = each.decorations().entrySet().stream().filter(entry -> ((TextDecoration.State)entry.getValue()).equals((Object)TextDecoration.State.TRUE)).map(entry -> (TextDecoration)entry.getKey()).collect(Collectors.toList());
            if (each instanceof TextComponent) {
                TextComponent textComponent = (TextComponent)each;
                String content = textComponent.content();
                String[] parts = content.split("\\R", -1);
                List split = Arrays.stream(parts).map(p -> textComponent.content(p)).collect(Collectors.toList());
                int j = 0;
                for (TextComponent part : split) {
                    if (++j >= split.size() && part.content().isEmpty()) continue;
                    String[] sections = part.content().split(" ", -1);
                    int u = 0;
                    for (String section : sections) {
                        if (++u < sections.length) {
                            section = section + " ";
                        }
                        int length = 0;
                        int i = 0;
                        while (i < section.length()) {
                            String c = new String(Character.toChars(section.codePointAt(i)));
                            i += c.length();
                            length += characterLengthProvider.applyAsInt(new CharacterLengthProviderData(c, font, decorations));
                        }
                        if (x + length > lineLengthLimit) {
                            if (!nullCurrentLine) {
                                result.add((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)currentLine);
                            }
                            currentLine = textComponent.content(section);
                            nullCurrentLine = false;
                            x = length;
                            block4: while (length > lineLengthLimit) {
                                String c;
                                StringBuilder sb = new StringBuilder();
                                int subLength = 0;
                                for (int i2 = 0; i2 < section.length(); i2 += c.length()) {
                                    c = new String(Character.toChars(section.codePointAt(i2)));
                                    int currentCharLength = characterLengthProvider.applyAsInt(new CharacterLengthProviderData(c, font, decorations));
                                    if ((subLength += currentCharLength) > lineLengthLimit) {
                                        result.add((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)textComponent.content(sb.toString()));
                                        section = section.substring(i2 - c.length());
                                        length -= subLength - currentCharLength;
                                        if (section.isEmpty()) {
                                            nullCurrentLine = true;
                                            currentLine = com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.empty();
                                            x = 0;
                                            continue block4;
                                        }
                                        nullCurrentLine = false;
                                        currentLine = textComponent.content(section);
                                        x = length;
                                        continue block4;
                                    }
                                    sb.append(c);
                                }
                            }
                            continue;
                        }
                        currentLine = currentLine.append((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)textComponent.content(section));
                        nullCurrentLine = false;
                        x += length;
                    }
                    if (j >= split.size()) continue;
                    if (nullCurrentLine) {
                        result.add((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.empty());
                    } else {
                        result.add((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)currentLine);
                    }
                    nullCurrentLine = true;
                    currentLine = com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.empty();
                    x = 0;
                }
                continue;
            }
            if (each instanceof TranslatableComponent) {
                TranslatableComponent translatableComponent = (TranslatableComponent)each;
                com.loohp.interactivechat.libs.net.kyori.adventure.text.Component textComponent = ComponentStringUtils.convertSingleTranslatable(translatableComponent, translateFunction);
                String content = PlainTextComponentSerializer.plainText().serialize(textComponent);
                int length = 0;
                int i = 0;
                while (i < content.length()) {
                    int codePoint = content.codePointAt(i);
                    String c = new String(Character.toChars(codePoint));
                    i += c.length();
                    length += characterLengthProvider.applyAsInt(new CharacterLengthProviderData(c, font, decorations));
                }
                if (x + length > lineLengthLimit) {
                    if (!nullCurrentLine) {
                        result.add((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)currentLine);
                    }
                    currentLine = translatableComponent;
                    nullCurrentLine = false;
                    x = 0;
                    continue;
                }
                currentLine = currentLine.append((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)translatableComponent);
                nullCurrentLine = false;
                x += length;
                continue;
            }
            String content = PlainTextComponentSerializer.plainText().serialize(each);
            int length = 0;
            int i = 0;
            while (i < content.length()) {
                int codePoint = content.codePointAt(i);
                String c = new String(Character.toChars(codePoint));
                i += c.length();
                length += characterLengthProvider.applyAsInt(new CharacterLengthProviderData(c, font, decorations));
            }
            if (x + length > lineLengthLimit) {
                if (!nullCurrentLine) {
                    result.add((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)currentLine);
                }
                nullCurrentLine = false;
                currentLine = each;
                x = 0;
                continue;
            }
            currentLine = currentLine.append(each);
            nullCurrentLine = false;
            x += length;
        }
        if (!nullCurrentLine) {
            result.add((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)currentLine);
        }
        return result;
    }

    public static com.loohp.interactivechat.libs.net.kyori.adventure.text.Component resolve(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component component, UnaryOperator<String> translateFunction) {
        component = ComponentFlattening.flatten((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)component);
        ArrayList<com.loohp.interactivechat.libs.net.kyori.adventure.text.Component> children = new ArrayList<com.loohp.interactivechat.libs.net.kyori.adventure.text.Component>(component.children());
        for (int i = 0; i < children.size(); ++i) {
            BlockNBTComponent nbt;
            com.loohp.interactivechat.libs.net.kyori.adventure.text.Component current = (com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)children.get(i);
            if (current instanceof TranslatableComponent) {
                TranslatableComponent translatable = (TranslatableComponent)current;
                current = ComponentStringUtils.convertSingleTranslatable(translatable, translateFunction);
            } else if (current instanceof KeybindComponent) {
                KeybindComponent keybinding = (KeybindComponent)current;
                current = ComponentStringUtils.convertSingleTranslatable(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.translatable((String)keybinding.keybind()), translateFunction);
            } else if (current instanceof ScoreComponent) {
                ScoreComponent score = (ScoreComponent)current;
                current = com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.text((String)("{" + score.name() + ": " + score.objective() + "}"));
            } else if (current instanceof BlockNBTComponent) {
                nbt = (BlockNBTComponent)current;
                current = com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.text((String)(nbt.nbtPath() + "@[" + nbt.pos().asString() + "]"));
            } else if (current instanceof EntityNBTComponent) {
                nbt = (EntityNBTComponent)current;
                current = com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.text((String)(nbt.nbtPath() + "@[" + nbt.selector() + "]"));
            } else if (current instanceof StorageNBTComponent) {
                nbt = (StorageNBTComponent)current;
                current = com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.text((String)(nbt.nbtPath() + "@[" + nbt.storage().asString() + "]"));
            }
            children.set(i, current);
        }
        return ComponentCompacting.optimize((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)component.children(children));
    }

    public static com.loohp.interactivechat.libs.net.kyori.adventure.text.Component convertSingleTranslatable(TranslatableComponent component, UnaryOperator<String> translateFunction) {
        String translation = (String)translateFunction.apply(component.key());
        List args = component.args();
        ArrayList<Object> parts = new ArrayList<Object>();
        Matcher matcher = ARG_FORMAT.matcher(translation);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                String string;
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    string = translation.substring(j, k);
                    if (string.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    parts.add(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.text((String)string));
                }
                string = matcher.group(2);
                String string2 = translation.substring(k, l);
                if ("%".equals(string) && "%%".equals(string2)) {
                    parts.add(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.text((String)"%"));
                } else if ("s".equals(string) || "d".equals(string)) {
                    String string3 = matcher.group(1);
                    int m = string3 != null ? Integer.parseInt(string3) - 1 : i++;
                    int n = m;
                    if (m < args.size()) {
                        parts.add(ComponentStringUtils.resolve((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)args.get(m), translateFunction));
                    }
                } else {
                    throw new RuntimeException("Unsupported format: '" + string2 + "'");
                }
                j = l;
            }
            if (j < translation.length()) {
                String string4 = translation.substring(j);
                if (string4.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                parts.add(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.text((String)string4));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        return ComponentModernizing.modernize((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)((TextComponent)com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.empty().style(component.style())).children(parts));
    }

    public static String convertFormattedString(String translation, Object ... args) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = ARG_FORMAT.matcher(translation);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                String string;
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    string = translation.substring(j, k);
                    if (string.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    parts.add(string);
                }
                string = matcher.group(2);
                String string2 = translation.substring(k, l);
                if ("%".equals(string) && "%%".equals(string2)) {
                    parts.add("%");
                } else if ("s".equals(string) || "d".equals(string)) {
                    String string3 = matcher.group(1);
                    int m = string3 != null ? Integer.parseInt(string3) - 1 : i++;
                    int n = m;
                    if (m < args.length) {
                        parts.add(args[m].toString());
                    }
                } else {
                    throw new RuntimeException("Unsupported format: '" + string2 + "'");
                }
                j = l;
            }
            if (j < translation.length()) {
                String string4 = translation.substring(j);
                if (string4.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                parts.add(string4);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        return String.join((CharSequence)"", parts);
    }

    public static com.loohp.interactivechat.libs.net.kyori.adventure.text.Component join(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component deliminator, com.loohp.interactivechat.libs.net.kyori.adventure.text.Component ... components) {
        return ComponentStringUtils.join((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.empty(), deliminator, components);
    }

    public static com.loohp.interactivechat.libs.net.kyori.adventure.text.Component join(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component deliminator, List<? extends com.loohp.interactivechat.libs.net.kyori.adventure.text.Component> components) {
        return ComponentStringUtils.join((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)com.loohp.interactivechat.libs.net.kyori.adventure.text.Component.empty(), deliminator, components);
    }

    public static com.loohp.interactivechat.libs.net.kyori.adventure.text.Component join(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component parent, com.loohp.interactivechat.libs.net.kyori.adventure.text.Component deliminator, com.loohp.interactivechat.libs.net.kyori.adventure.text.Component ... components) {
        return ComponentStringUtils.join(parent, deliminator, Arrays.asList(components));
    }

    public static com.loohp.interactivechat.libs.net.kyori.adventure.text.Component join(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component parent, com.loohp.interactivechat.libs.net.kyori.adventure.text.Component deliminator, List<? extends com.loohp.interactivechat.libs.net.kyori.adventure.text.Component> components) {
        if (components.size() <= 0) {
            return parent;
        }
        if (components.size() == 1) {
            return parent.append(components.get(0));
        }
        ArrayList<com.loohp.interactivechat.libs.net.kyori.adventure.text.Component> children = new ArrayList<com.loohp.interactivechat.libs.net.kyori.adventure.text.Component>(parent.children());
        for (int i = 0; i < components.size() - 1; ++i) {
            children.add(components.get(i));
            children.add(deliminator);
        }
        children.add(components.get(components.size() - 1));
        return parent.children(children);
    }

    public static String toMagic(String str) {
        return ComponentStringUtils.toMagic(null, str);
    }

    public static String toMagic(FontProvider provider, String str) {
        if (provider == null) {
            return RandomStringUtils.random((int)str.length());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            String currentChar = str.substring(i, i + 1);
            IntList list = (IntList)provider.getDisplayableCharactersByWidth().get(provider.forCharacter(currentChar).getCharacterWidth(currentChar));
            sb.append(Character.toChars(list.getInt(ThreadLocalRandom.current().nextInt(list.size()))));
        }
        return sb.toString();
    }

    public static String stripColorAndConvertMagic(String str) {
        return ComponentStringUtils.stripColorAndConvertMagic(null, str);
    }

    public static String stripColorAndConvertMagic(FontProvider provider, String str) {
        StringBuilder sb = new StringBuilder();
        str = str.replaceAll("\u00a7[l-o]", "").replaceAll("\u00a7[0-9a-fxA-F]", "\u00a7r");
        boolean magic = false;
        for (int i = 0; i < str.length(); ++i) {
            String current = str.substring(i, i + 1);
            if (current.equals("\u00a7")) {
                String next = str.substring(i + 1, i + 2);
                if (next.equalsIgnoreCase("r")) {
                    magic = false;
                    ++i;
                    continue;
                }
                if (next.equalsIgnoreCase("k")) {
                    magic = true;
                    ++i;
                    continue;
                }
                sb.append(magic ? ComponentStringUtils.toMagic(provider, current) : current);
                continue;
            }
            sb.append(magic ? ComponentStringUtils.toMagic(provider, current) : current);
        }
        return sb.toString();
    }

    public static ItemStack extractItemStack(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component component) {
        component = ComponentFlattening.flatten((com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)component);
        ArrayList<TranslatableComponent> children = new ArrayList<TranslatableComponent>(component.children());
        for (int i = 0; i < children.size(); ++i) {
            com.loohp.interactivechat.libs.net.kyori.adventure.text.Component child = (com.loohp.interactivechat.libs.net.kyori.adventure.text.Component)children.get(i);
            HoverEvent hoverEvent = child.hoverEvent();
            if (hoverEvent != null && hoverEvent.action().equals(HoverEvent.Action.SHOW_ITEM)) {
                String longNbt;
                Optional optXMaterial;
                HoverEvent.ShowItem showItem = (HoverEvent.ShowItem)hoverEvent.value();
                Key key = showItem.item();
                int count = showItem.count();
                ItemStack itemstack = null;
                LegacyIdKey legacyId = InteractiveChatComponentSerializer.interactiveChatKeyToLegacyId((Key)key);
                if (legacyId == null) {
                    String simpleNbt = "{id:\"" + key.asString() + "\", Count: " + count + "b}";
                    try {
                        itemstack = ItemNBTUtils.getItemFromNBTJson((String)simpleNbt);
                    }
                    catch (Throwable throwable) {}
                } else if (legacyId.hasByteId()) {
                    optXMaterial = XMaterial.matchXMaterial((int)legacyId.getByteId(), (byte)(legacyId.isDamageDataValue() ? (byte)legacyId.getDamage() : (byte)0));
                    if (optXMaterial.isPresent()) {
                        itemstack = ((XMaterial)optXMaterial.get()).parseItem();
                    }
                } else {
                    String materialId = legacyId.getStringId();
                    if (materialId.contains(":")) {
                        materialId = materialId.substring(materialId.indexOf(":") + 1);
                    }
                    if ((optXMaterial = XMaterial.matchXMaterial((String)materialId.toUpperCase())).isPresent()) {
                        itemstack = ((XMaterial)optXMaterial.get()).parseItem();
                        itemstack.setDurability(legacyId.getDamage());
                    }
                }
                String string = longNbt = showItem.nbt() == null ? null : showItem.nbt().string();
                if (itemstack != null && longNbt != null) {
                    try {
                        itemstack = Bukkit.getUnsafe().modifyItemStack(itemstack, longNbt);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (itemstack != null) {
                    return itemstack;
                }
            }
            if (!(child instanceof TranslatableComponent)) continue;
            TranslatableComponent trans = (TranslatableComponent)child;
            ArrayList withs = new ArrayList(trans.args());
            for (com.loohp.interactivechat.libs.net.kyori.adventure.text.Component with : withs) {
                ItemStack itemstack = ComponentStringUtils.extractItemStack(with);
                if (itemstack == null) continue;
                return itemstack;
            }
            trans = trans.args(withs);
            children.set(i, trans);
        }
        return null;
    }

    public static Component toDiscordSRVComponent(com.loohp.interactivechat.libs.net.kyori.adventure.text.Component component) {
        return GsonComponentSerializer.gson().deserialize((Object)((String)InteractiveChatComponentSerializer.gson().serialize(component)));
    }

    public static com.loohp.interactivechat.libs.net.kyori.adventure.text.Component toRegularComponent(Component component) {
        return InteractiveChatComponentSerializer.gson().deserialize((Object)((String)GsonComponentSerializer.gson().serialize(component)));
    }

    public static class CharacterLengthProviderData {
        private String character;
        private Key font;
        private List<TextDecoration> decorations;

        public CharacterLengthProviderData(String character, Key font, List<TextDecoration> decorations) {
            this.character = character;
            this.font = font;
            this.decorations = decorations;
        }

        public String getCharacter() {
            return this.character;
        }

        public Key getFont() {
            return this.font;
        }

        public List<TextDecoration> getDecorations() {
            return this.decorations;
        }
    }
}

