/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.libs.io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;

public class BundleUtils {
    public static int getContainerGridSizeX(int itemCount) {
        return Math.max(2, (int)Math.ceil(Math.sqrt((double)itemCount + 1.0)));
    }

    public static int getContainerGridSizeY(int itemCount) {
        return (int)Math.ceil(((double)itemCount + 1.0) / (double)BundleUtils.getContainerGridSizeX(itemCount));
    }

    public static float getFullnessPercentage(List<ItemStack> items) {
        return (float)BundleUtils.getContentWeight(items) / 64.0f;
    }

    public static int getFullness(List<ItemStack> items) {
        return BundleUtils.getContentWeight(items);
    }

    private static int getWeight(ItemStack itemStack) {
        Material material = itemStack.getType();
        if (material.equals((Object)Material.BUNDLE)) {
            return 4 + BundleUtils.getContentWeight(((BundleMeta)itemStack.getItemMeta()).getItems());
        }
        if ((material.equals((Object)Material.BEEHIVE) || material.equals((Object)Material.BEE_NEST)) && NBTEditor.contains((Object)itemStack, (Object[])new Object[]{"BlockEntityTag"}) && NBTEditor.getSize((Object)itemStack, (Object[])new Object[]{"BlockEntityTag", "Bees"}) > 0) {
            return 64;
        }
        return 64 / itemStack.getMaxStackSize();
    }

    private static int getContentWeight(List<ItemStack> items) {
        return items.stream().mapToInt(each -> BundleUtils.getWeight(each) * each.getAmount()).sum();
    }
}

