/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.utils;

import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.utils.ChatComponentType;
import com.loohp.interactivechat.utils.ItemStackUtils;
import com.loohp.interactivechat.utils.NMSUtils;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.AdvancementData;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.AdvancementType;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.advancement.Advancement;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.inventory.ItemStack;

public class AdvancementUtils {
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    private static Class<?> craftAdvancementClass;
    private static Method craftAdvancementClassGetHandleMethod;
    private static Class<?> nmsAdvancementClass;
    private static Method nmsAdvancementClassGetDisplayMethod;
    private static Class<?> nmsAdvancementDisplayClass;
    private static Method nmsAdvancementDisplayClassGetTitleMethod;
    private static Method nmsAdvancementDisplayClassGetDescriptionMethod;
    private static Method nmsAdvancementDisplayClassGetTypeMethod;
    private static Field nmsAdvancementDisplayClassItemStackField;

    public static AdvancementData getAdvancementData(Object advancementObject) {
        try {
            Advancement advancement = (Advancement)advancementObject;
            boolean isMinecraft = advancement.getKey().getNamespace().equals(MINECRAFT_NAMESPACE);
            Object craftAdvancement = craftAdvancementClass.cast(advancement);
            Object nmsAdvancement = craftAdvancementClassGetHandleMethod.invoke(craftAdvancement, new Object[0]);
            Object nmsAdvancementDisplay = nmsAdvancementClassGetDisplayMethod.invoke(nmsAdvancement, new Object[0]);
            Object nmsTitle = nmsAdvancementDisplayClassGetTitleMethod.invoke(nmsAdvancementDisplay, new Object[0]);
            Component title = ChatComponentType.IChatBaseComponent.convertFrom(nmsTitle);
            Object nmsDescription = nmsAdvancementDisplayClassGetDescriptionMethod.invoke(nmsAdvancementDisplay, new Object[0]);
            Component description = ChatComponentType.IChatBaseComponent.convertFrom(nmsDescription);
            Object nmsAdvancementType = nmsAdvancementDisplayClassGetTypeMethod.invoke(nmsAdvancementDisplay, new Object[0]);
            AdvancementType advancementType = AdvancementType.fromHandle(nmsAdvancementType);
            nmsAdvancementDisplayClassItemStackField.setAccessible(true);
            Object nmsItemStack = nmsAdvancementDisplayClassItemStackField.get(nmsAdvancementDisplay);
            ItemStack itemStack = ItemStackUtils.toBukkitCopy((Object)nmsItemStack);
            return new AdvancementData(title, description, itemStack, advancementType, isMinecraft);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object getAdvancementFromEvent(Object event) {
        return ((PlayerAdvancementDoneEvent)event).getAdvancement();
    }

    static {
        try {
            craftAdvancementClass = NMSUtils.getNMSClass((String)"org.bukkit.craftbukkit.%s.advancement.CraftAdvancement", (String[])new String[0]);
            craftAdvancementClassGetHandleMethod = craftAdvancementClass.getMethod("getHandle", new Class[0]);
            nmsAdvancementClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.Advancement", (String[])new String[]{"net.minecraft.advancements.Advancement"});
            nmsAdvancementClassGetDisplayMethod = nmsAdvancementClass.getMethod("c", new Class[0]);
            nmsAdvancementDisplayClass = NMSUtils.getNMSClass((String)"net.minecraft.server.%s.AdvancementDisplay", (String[])new String[]{"net.minecraft.advancements.AdvancementDisplay"});
            nmsAdvancementDisplayClassGetTitleMethod = nmsAdvancementDisplayClass.getMethod("a", new Class[0]);
            nmsAdvancementDisplayClassGetDescriptionMethod = nmsAdvancementDisplayClass.getMethod("b", new Class[0]);
            nmsAdvancementDisplayClassGetTypeMethod = nmsAdvancementDisplayClass.getMethod("e", new Class[0]);
            nmsAdvancementDisplayClassItemStackField = nmsAdvancementDisplayClass.getDeclaredField("c");
        }
        catch (ClassNotFoundException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

