/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.updater;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.event.ClickEvent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.event.HoverEvent;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.event.HoverEventSource;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.NamedTextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.format.TextColor;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.utils.HTTPRequestUtils;
import com.loohp.interactivechatdiscordsrvaddon.InteractiveChatDiscordSrvAddon;
import com.loohp.interactivechatdiscordsrvaddon.updater.Version;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class Updater
implements Listener {
    public static final String PLUGIN_NAME = "InteractiveChat-DiscordSRV-Addon";

    public static void sendUpdateMessage(CommandSender sender, String version, int spigotPluginId) {
        Updater.sendUpdateMessage(sender, version, spigotPluginId, false);
    }

    public static void sendUpdateMessage(CommandSender sender, String version, int spigotPluginId, boolean devbuild) {
        if (!version.equals("error")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (!devbuild) {
                    player.sendMessage(ChatColor.YELLOW + "[ICDiscordSrvAddon] A new version is available on SpigotMC: " + version);
                    TextComponent url = LegacyComponentSerializer.legacySection().deserialize(ChatColor.GOLD + "https://www.spigotmc.org/resources/" + spigotPluginId);
                    url = url.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click me!").color((TextColor)NamedTextColor.AQUA)));
                    url = url.clickEvent(ClickEvent.openUrl((String)("https://www.spigotmc.org/resources/" + spigotPluginId)));
                    InteractiveChat.sendMessage((CommandSender)player, (Component)url);
                } else {
                    sender.sendMessage(ChatColor.GREEN + "[ICDiscordSrvAddon] You are running the latest release!");
                    TextComponent url = LegacyComponentSerializer.legacySection().deserialize(ChatColor.YELLOW + "[InteractiveChat] However, a new Development Build is available if you want to try that!");
                    url = url.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click me!").color((TextColor)NamedTextColor.AQUA)));
                    url = url.clickEvent(ClickEvent.openUrl((String)"https://ci.loohpjames.com/job/InteractiveChat-DiscordSRV-Addon"));
                    InteractiveChat.sendMessage((CommandSender)player, (Component)url);
                }
            } else if (!devbuild) {
                sender.sendMessage(ChatColor.YELLOW + "[ICDiscordSrvAddon] A new version is available on SpigotMC: " + version);
                sender.sendMessage(ChatColor.GOLD + "Download: https://www.spigotmc.org/resources/" + spigotPluginId);
            } else {
                sender.sendMessage(ChatColor.GREEN + "[ICDiscordSrvAddon] You are running the latest release!");
                sender.sendMessage(ChatColor.YELLOW + "[ICDiscordSrvAddon] However, a new Development Build is available if you want to try that!");
            }
        }
    }

    public static UpdaterResponse checkUpdate() {
        try {
            String localPluginVersion = InteractiveChatDiscordSrvAddon.plugin.getDescription().getVersion();
            JSONObject response = (JSONObject)HTTPRequestUtils.getJSONResponse((String)"https://api.loohpjames.com/spigot/data").get((Object)PLUGIN_NAME);
            String spigotPluginVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"release");
            String devBuildVersion = (String)((JSONObject)response.get((Object)"latestversion")).get((Object)"devbuild");
            int spigotPluginId = (int)((Long)((JSONObject)response.get((Object)"spigotmc")).get((Object)"pluginid")).longValue();
            int posOfThirdDot = localPluginVersion.indexOf(".", localPluginVersion.indexOf(".", localPluginVersion.indexOf(".") + 1) + 1);
            Version currentDevBuild = new Version(localPluginVersion);
            Version currentRelease = new Version(localPluginVersion.substring(0, posOfThirdDot >= 0 ? posOfThirdDot : localPluginVersion.length()));
            Version spigotmc = new Version(spigotPluginVersion);
            Version devBuild = new Version(devBuildVersion);
            if (currentRelease.compareTo(spigotmc) < 0) {
                return new UpdaterResponse(spigotPluginVersion, spigotPluginId, currentDevBuild.compareTo(devBuild) >= 0);
            }
            return new UpdaterResponse("latest", spigotPluginId, currentDevBuild.compareTo(devBuild) >= 0);
        }
        catch (Exception e) {
            Bukkit.getConsoleSender().sendMessage(ChatColor.RED + "[ICDiscordSrvAddon] Failed to check against \"api.loohpjames.com\" for the latest version.. It could be an internet issue or \"api.loohpjames.com\" is down. If you want disable the update checker, you can disable in config.yml, but we still highly-recommend you to keep your plugin up to date!");
            return new UpdaterResponse("error", -1, false);
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Bukkit.getScheduler().runTaskLaterAsynchronously((Plugin)InteractiveChatDiscordSrvAddon.plugin, () -> {
            UpdaterResponse version;
            Player player;
            if (InteractiveChatDiscordSrvAddon.plugin.updaterEnabled && (player = event.getPlayer()).hasPermission("interactivechatdiscordsrv.update") && !(version = Updater.checkUpdate()).getResult().equals("latest")) {
                Updater.sendUpdateMessage((CommandSender)player, version.getResult(), version.getSpigotPluginId());
            }
        }, 100L);
    }

    public static class UpdaterResponse {
        private String result;
        private int spigotPluginId;
        private boolean devBuildIsLatest;

        public UpdaterResponse(String result, int spigotPluginId, boolean devBuildIsLatest) {
            this.result = result;
            this.spigotPluginId = spigotPluginId;
            this.devBuildIsLatest = devBuildIsLatest;
        }

        public String getResult() {
            return this.result;
        }

        public int getSpigotPluginId() {
            return this.spigotPluginId;
        }

        public boolean isDevBuildLatest() {
            return this.devBuildIsLatest;
        }
    }
}

