/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.textures;

import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.ITextureManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureMeta;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.imageio.ImageIO;

public class TextureResource {
    public static final String PNG_MCMETA_SUFFIX = ".png.mcmeta";
    public static final String MCMETA_SUFFIX = ".mcmeta";
    private ITextureManager manager;
    private String resourceKey;
    private ResourcePackFile file;
    private boolean isTexture;
    private Reference<BufferedImage> texture;
    private Unsafe unsafe;

    public TextureResource(ITextureManager manager, String resourceKey, ResourcePackFile file, boolean isTexture) {
        this.manager = manager;
        this.resourceKey = resourceKey;
        this.file = file;
        this.isTexture = isTexture;
        this.texture = null;
        this.unsafe = null;
    }

    protected TextureResource(ITextureManager manager, String resourceKey, ResourcePackFile file, BufferedImage image) {
        this.manager = manager;
        this.resourceKey = resourceKey;
        this.file = file;
        this.isTexture = true;
        this.texture = new WeakReference<BufferedImage>(image);
        this.unsafe = null;
    }

    public TextureResource(TextureManager manager, String resourceKey, ResourcePackFile file) {
        this((ITextureManager)manager, resourceKey, file, false);
    }

    public ITextureManager getManager() {
        return this.manager;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    private synchronized BufferedImage loadImage() {
        BufferedImage bufferedImage;
        block11: {
            BufferedImage image;
            if (!this.isTexture) {
                throw new IllegalStateException(this.resourceKey + " is not a texture!");
            }
            if (this.texture != null && (image = this.texture.get()) != null) {
                return image;
            }
            InputStream inputStream = this.file.getInputStream();
            try {
                image = ImageIO.read(inputStream);
                if (image == null) {
                    throw new IOException("Image is null!");
                }
                this.texture = new WeakReference<BufferedImage>(image);
                bufferedImage = image;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Unable to load image " + this.resourceKey + " from " + this.file.getAbsolutePath(), e);
                }
            }
            inputStream.close();
        }
        return bufferedImage;
    }

    public boolean isTexture() {
        return this.isTexture;
    }

    public BufferedImage getTexture(int w, int h) {
        BufferedImage image = this.loadImage();
        image = image.getWidth() != w || image.getHeight() != h ? ImageUtils.resizeImageAbs(image, w, h) : ImageUtils.copyImage(image);
        return image;
    }

    public BufferedImage getTexture() {
        return ImageUtils.copyImage(this.loadImage());
    }

    public boolean hasFile() {
        return this.file != null;
    }

    public ResourcePackFile getFile() {
        return this.file;
    }

    public boolean isTextureMeta() {
        return false;
    }

    public boolean hasTextureMeta() {
        return this.getTextureMeta() != null;
    }

    public TextureMeta getTextureMeta() {
        if (this.resourceKey == null || this.manager == null) {
            return null;
        }
        TextureResource meta = this.manager.getTexture(this.resourceKey.contains(".") ? this.resourceKey + MCMETA_SUFFIX : this.resourceKey + PNG_MCMETA_SUFFIX, false);
        if (meta != null && meta.isTextureMeta()) {
            return (TextureMeta)meta;
        }
        return null;
    }

    @Deprecated
    public Unsafe getUnsafe() {
        if (this.unsafe != null) {
            return this.unsafe;
        }
        this.unsafe = new Unsafe(){

            @Override
            public Reference<BufferedImage> getTextureReference() {
                return TextureResource.this.texture;
            }
        };
        return this.unsafe;
    }

    @Deprecated
    public static interface Unsafe {
        @Deprecated
        public Reference<BufferedImage> getTextureReference();
    }
}

