/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.textures;

import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.ITextureManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureAnimation;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import java.util.ArrayList;

public class TextureMeta
extends TextureResource {
    private TextureAnimation animation;
    private TextureProperties properties;

    public static TextureMeta fromJson(ITextureManager manager, String resourceKey, ResourcePackFile file, JSONObject rootJson) {
        TextureAnimation animation = null;
        if (rootJson.containsKey((Object)"animation")) {
            JSONObject animationJson = (JSONObject)rootJson.get((Object)"animation");
            boolean interpolate = (Boolean)animationJson.getOrDefault((Object)"interpolate", (Object)false);
            int width = ((Number)animationJson.getOrDefault((Object)"width", (Object)-1)).intValue();
            int height = ((Number)animationJson.getOrDefault((Object)"height", (Object)-1)).intValue();
            int frametime = ((Number)animationJson.getOrDefault((Object)"frametime", (Object)-1)).intValue();
            JSONArray framesArray = (JSONArray)animationJson.getOrDefault((Object)"frames", (Object)new JSONArray());
            ArrayList<TextureAnimation.TextureAnimationFrames> frames = new ArrayList<TextureAnimation.TextureAnimationFrames>();
            for (Object obj : framesArray) {
                if (obj instanceof Number) {
                    frames.add(new TextureAnimation.TextureAnimationFrames(((Number)obj).intValue(), frametime));
                    continue;
                }
                if (!(obj instanceof JSONObject)) continue;
                JSONObject frameJson = (JSONObject)obj;
                frames.add(new TextureAnimation.TextureAnimationFrames(((Number)frameJson.get((Object)"index")).intValue(), ((Number)frameJson.get((Object)"time")).intValue()));
            }
            animation = new TextureAnimation(interpolate, width, height, frametime, frames);
        }
        TextureProperties properties = null;
        if (rootJson.containsKey((Object)"texture")) {
            JSONObject propertiesJson = (JSONObject)rootJson.get((Object)"texture");
            boolean blur = (Boolean)propertiesJson.getOrDefault((Object)"blur", (Object)false);
            boolean clamp = (Boolean)propertiesJson.getOrDefault((Object)"clamp", (Object)false);
            int[] mipmaps = ((JSONArray)propertiesJson.getOrDefault((Object)"mipmaps", (Object)new JSONArray())).stream().mapToInt(each -> ((Number)each).intValue()).toArray();
            properties = new TextureProperties(blur, clamp, mipmaps);
        }
        return new TextureMeta(manager, resourceKey, file, animation, properties);
    }

    public TextureMeta(ITextureManager manager, String resourceKey, ResourcePackFile file, TextureAnimation animation, TextureProperties properties) {
        super(manager, resourceKey, file, false);
        this.animation = animation;
        this.properties = properties;
    }

    public TextureAnimation getAnimation() {
        return this.animation;
    }

    public TextureProperties getProperties() {
        return this.properties;
    }

    public boolean hasAnimation() {
        return this.animation != null;
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    @Override
    public boolean isTextureMeta() {
        return true;
    }

    @Override
    public boolean hasTextureMeta() {
        return false;
    }

    @Override
    public TextureMeta getTextureMeta() {
        return null;
    }
}

