/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit;

import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.IntegerRange;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.PercentageOrIntegerRange;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.CITProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.CITValueMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;

public class EnchantmentProperties
extends CITProperties {
    private int layer;
    private double speed;
    private double rotation;
    private double duration;
    private OpenGLBlending blend;
    private String texture;

    public EnchantmentProperties(int weight, Set<XMaterial> items, IntegerRange stackSize, PercentageOrIntegerRange damage, int damageMask, EquipmentSlot hand, Map<Enchantment, IntegerRange> enchantments, Map<String, CITValueMatcher> nbtMatch, int layer, double speed, double rotation, double duration, OpenGLBlending blend, String texture) {
        super(weight, items, stackSize, damage, damageMask, hand, enchantments, nbtMatch);
        this.layer = layer;
        this.speed = speed;
        this.rotation = rotation;
        this.duration = duration;
        this.blend = blend;
        this.texture = texture;
    }

    public int getLayer() {
        return this.layer;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getRotation() {
        return this.rotation;
    }

    public double getDuration() {
        return this.duration;
    }

    public OpenGLBlending getBlend() {
        return this.blend;
    }

    public String getTexture() {
        return this.texture;
    }

    @Override
    public String getOverrideAsset(String path, String extension) {
        if (extension.equalsIgnoreCase("png")) {
            return this.texture;
        }
        return null;
    }

    public static class OpenGLBlending {
        public static final OpenGLBlending REPLACE = OpenGLBlending.of(null, null, null, null);
        public static final OpenGLBlending GLINT = OpenGLBlending.of(OpenGLBlendMode.GL_SRC_COLOR, OpenGLBlendMode.GL_ONE);
        public static final OpenGLBlending ALPHA = OpenGLBlending.of(OpenGLBlendMode.GL_SRC_ALPHA, OpenGLBlendMode.GL_ONE_MINUS_SRC_ALPHA);
        public static final OpenGLBlending ADD = OpenGLBlending.of(OpenGLBlendMode.GL_SRC_ALPHA, OpenGLBlendMode.GL_ONE);
        public static final OpenGLBlending SUBTRACT = OpenGLBlending.of(OpenGLBlendMode.GL_ONE_MINUS_DST_COLOR, OpenGLBlendMode.GL_ZERO);
        public static final OpenGLBlending MULTIPLY = OpenGLBlending.of(OpenGLBlendMode.GL_DST_COLOR, OpenGLBlendMode.GL_ONE_MINUS_SRC_ALPHA);
        public static final OpenGLBlending DODGE = OpenGLBlending.of(OpenGLBlendMode.GL_ONE, OpenGLBlendMode.GL_ONE);
        public static final OpenGLBlending BURN = OpenGLBlending.of(OpenGLBlendMode.GL_ZERO, OpenGLBlendMode.GL_ONE_MINUS_SRC_COLOR);
        public static final OpenGLBlending SCREEN = OpenGLBlending.of(OpenGLBlendMode.GL_ONE, OpenGLBlendMode.GL_ONE_MINUS_SRC_COLOR);
        public static final OpenGLBlending OVERLAY = OpenGLBlending.of(OpenGLBlendMode.GL_DST_COLOR, OpenGLBlendMode.GL_SRC_COLOR);
        private static final Map<String, OpenGLBlending> PRESETS = new HashMap<String, OpenGLBlending>();
        private final OpenGLBlendMode srcColor;
        private final OpenGLBlendMode desColor;
        private final OpenGLBlendMode srcAlpha;
        private final OpenGLBlendMode desAlpha;

        public static OpenGLBlending of(OpenGLBlendMode srcComposite, OpenGLBlendMode desComposite) {
            return OpenGLBlending.of(srcComposite, desComposite, OpenGLBlendMode.GL_ZERO, OpenGLBlendMode.GL_ONE);
        }

        public static OpenGLBlending of(OpenGLBlendMode srcColorComposite, OpenGLBlendMode desColorComposite, OpenGLBlendMode srcAlphaComposite, OpenGLBlendMode desAlphaComposite) {
            return new OpenGLBlending(srcColorComposite, desColorComposite, srcAlphaComposite, desAlphaComposite);
        }

        public static OpenGLBlending fromString(String input) {
            String[] sections = input.split(" ");
            switch (sections.length) {
                case 1: {
                    return PRESETS.get(sections[0].toLowerCase());
                }
                case 2: {
                    return OpenGLBlending.of(OpenGLBlendMode.fromOpenGL(sections[0]), OpenGLBlendMode.fromOpenGL(sections[1]));
                }
                case 4: {
                    return OpenGLBlending.of(OpenGLBlendMode.fromOpenGL(sections[0]), OpenGLBlendMode.fromOpenGL(sections[1]), OpenGLBlendMode.fromOpenGL(sections[2]), OpenGLBlendMode.fromOpenGL(sections[3]));
                }
            }
            return null;
        }

        private OpenGLBlending(OpenGLBlendMode srcColor, OpenGLBlendMode desColor, OpenGLBlendMode srcAlpha, OpenGLBlendMode desAlpha) {
            this.srcColor = srcColor;
            this.desColor = desColor;
            this.srcAlpha = srcAlpha;
            this.desAlpha = desAlpha;
        }

        public OpenGLBlendMode getSrcColor() {
            return this.srcColor;
        }

        public OpenGLBlendMode getDesColor() {
            return this.desColor;
        }

        public OpenGLBlendMode getSrcAlpha() {
            return this.srcAlpha;
        }

        public OpenGLBlendMode getDesAlpha() {
            return this.desAlpha;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OpenGLBlending that = (OpenGLBlending)o;
            return this.srcColor == that.srcColor && this.desColor == that.desColor && this.srcAlpha == that.srcAlpha && this.desAlpha == that.desAlpha;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.srcColor, this.desColor, this.srcAlpha, this.desAlpha});
        }

        static {
            try {
                for (Field field : OpenGLBlendMode.class.getFields()) {
                    if (!field.getType().equals(OpenGLBlending.class) || !Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
                    PRESETS.put(field.getName().toLowerCase(), (OpenGLBlending)field.get(null));
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum OpenGLBlendMode {
        GL_ZERO(0),
        GL_ONE(1),
        GL_SRC_COLOR(768),
        GL_ONE_MINUS_SRC_COLOR(769),
        GL_DST_COLOR(774),
        GL_ONE_MINUS_DST_COLOR(775),
        GL_SRC_ALPHA(770),
        GL_ONE_MINUS_SRC_ALPHA(771),
        GL_DST_ALPHA(772),
        GL_ONE_MINUS_DST_ALPHA(773);

        private static final OpenGLBlendMode[] VALUES;
        private final int openGLValue;

        private OpenGLBlendMode(int openGLValue) {
            this.openGLValue = openGLValue;
        }

        public int getOpenGLValue() {
            return this.openGLValue;
        }

        public String getOpenGLName() {
            return this.name();
        }

        public static OpenGLBlendMode fromOpenGL(String name) {
            if (name.startsWith("0x")) {
                try {
                    return OpenGLBlendMode.fromOpenGL(Integer.parseInt(name.substring(2), 16));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            try {
                return OpenGLBlendMode.fromOpenGL(Integer.parseInt(name));
            }
            catch (NumberFormatException numberFormatException) {
                for (OpenGLBlendMode blend : VALUES) {
                    if (!blend.getOpenGLName().equalsIgnoreCase(name)) continue;
                    return blend;
                }
                return null;
            }
        }

        public static OpenGLBlendMode fromOpenGL(int value) {
            for (OpenGLBlendMode blend : VALUES) {
                if (blend.getOpenGLValue() != value) continue;
                return blend;
            }
            return null;
        }

        static {
            VALUES = OpenGLBlendMode.values();
        }
    }
}

