/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit;

import com.loohp.interactivechat.libs.net.querz.nbt.tag.ByteTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.DoubleTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.FloatTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.IntTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.LongTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.ShortTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.Tag;
import com.loohp.interactivechat.utils.NBTParsingUtils;
import java.util.regex.Pattern;

public abstract class CITValueMatcher {
    private String value;
    private IntTag matchInteger;
    private ByteTag matchByte;
    private FloatTag matchFloat;
    private DoubleTag matchDouble;
    private LongTag matchLong;
    private ShortTag matchShort;
    private Tag<?> matchTag;

    public CITValueMatcher(String value) {
        this.value = value;
        try {
            this.matchInteger = value.startsWith("#") ? new IntTag(Integer.parseInt(value.substring(1).toLowerCase(), 16)) : (value.startsWith("0x") ? new IntTag(Integer.parseInt(value.substring(2).toLowerCase(), 16)) : new IntTag(Integer.parseInt(value)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchByte = new ByteTag(Byte.parseByte(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchFloat = new FloatTag(Float.parseFloat(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchDouble = new DoubleTag(Double.parseDouble(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchLong = new LongTag(Long.parseLong(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchShort = new ShortTag(Short.parseShort(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.matchTag = NBTParsingUtils.fromSNBT((String)value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract boolean matches(String var1);

    public String value() {
        return this.value;
    }

    public IntTag intTag() {
        return this.matchInteger;
    }

    public ByteTag byteTag() {
        return this.matchByte;
    }

    public FloatTag floatTag() {
        return this.matchFloat;
    }

    public DoubleTag doubleTag() {
        return this.matchDouble;
    }

    public LongTag longTag() {
        return this.matchLong;
    }

    public ShortTag shortTag() {
        return this.matchShort;
    }

    public Tag<?> tag() {
        return this.matchTag;
    }

    public static class IPatternMatcher
    extends PatternMatcher {
        public IPatternMatcher(String pattern) {
            super(pattern.toLowerCase());
        }

        @Override
        protected boolean charsEqual(char p, char v) {
            return p == v || p == Character.toLowerCase(v);
        }
    }

    public static class IRegexMatcher
    extends RegexMatcher {
        public IRegexMatcher(String pattern) {
            super(Pattern.compile(pattern, 2));
        }
    }

    public static class PatternMatcher
    extends CITValueMatcher {
        protected final String pattern;

        public PatternMatcher(String pattern) {
            super(pattern);
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String value) {
            return this.matchesPattern(value, this.pattern, 0, value.length(), 0, this.pattern.length());
        }

        protected boolean matchesPattern(String value, String pattern, int curV, int maxV, int curG, int maxG) {
            while (curG < maxG) {
                char g = pattern.charAt(curG);
                if (g == '*') {
                    while (true) {
                        if (this.matchesPattern(value, pattern, curV, maxV, curG + 1, maxG)) {
                            return true;
                        }
                        if (curV >= maxV) break;
                        ++curV;
                    }
                    return false;
                }
                if (curV >= maxV) break;
                if (g != '?') {
                    if (g == '\\' && curG + 1 < maxG) {
                        g = pattern.charAt(++curG);
                    }
                    if (!this.charsEqual(g, value.charAt(curV))) {
                        return false;
                    }
                }
                ++curG;
                ++curV;
            }
            return curG == maxG && curV == maxV;
        }

        protected boolean charsEqual(char p, char v) {
            return p == v;
        }
    }

    public static class RegexMatcher
    extends CITValueMatcher {
        protected final Pattern pattern;

        public RegexMatcher(String pattern) {
            this(Pattern.compile(pattern));
        }

        protected RegexMatcher(Pattern pattern) {
            super(pattern.pattern());
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String value) {
            return this.pattern.matcher(value).matches();
        }
    }

    public static class DirectMatcher
    extends CITValueMatcher {
        protected final String pattern;

        public DirectMatcher(String pattern) {
            super(pattern);
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String value) {
            return this.pattern.equals(value);
        }
    }
}

