/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit;

import com.loohp.interactivechat.InteractiveChat;
import com.loohp.interactivechat.libs.com.cryptomorin.xseries.XMaterial;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.ByteTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.CompoundTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.DoubleTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.FloatTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.IntTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.ListTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.LongTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.ShortTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.StringTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.Tag;
import com.loohp.interactivechat.utils.InteractiveChatComponentSerializer;
import com.loohp.interactivechat.utils.ItemNBTUtils;
import com.loohp.interactivechat.utils.NBTParsingUtils;
import com.loohp.interactivechat.utils.XMaterialUtils;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.IntegerRange;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.PercentageOrIntegerRange;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.OptifineUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.ArmorProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.CITValueMatcher;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.ElytraProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.EnchantmentProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.ItemProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public abstract class CITProperties {
    protected int weight;
    protected Set<XMaterial> items;
    protected IntegerRange stackSize;
    protected PercentageOrIntegerRange damage;
    protected int damageMask;
    protected EquipmentSlot hand;
    protected Map<Enchantment, IntegerRange> enchantments;
    protected Map<String, CITValueMatcher> nbtMatch;

    public static CITProperties fromProperties(ResourcePackFile file, Properties properties) {
        String texture;
        String name = file.getName();
        if (name.contains(".")) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        int weight = Integer.parseInt(properties.getProperty("weight", "0"));
        HashSet<XMaterial> items = new HashSet<XMaterial>();
        String itemsStr = properties.getProperty("items");
        if (itemsStr == null) {
            itemsStr = properties.getProperty("matchItems");
        }
        if (itemsStr != null) {
            for (String section : itemsStr.split(" ")) {
                Optional optMaterial;
                if (section.contains(":")) {
                    section = section.substring(section.indexOf(":") + 1);
                }
                if ((optMaterial = XMaterial.matchXMaterial((String)section)).isPresent()) {
                    items.add((XMaterial)optMaterial.get());
                    continue;
                }
                XMaterial.matchXMaterial((String)name).ifPresent(items::add);
            }
        }
        String stackSizeStr = properties.getProperty("stackSize");
        IntegerRange stackSize = new IntegerRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
        if (stackSizeStr != null) {
            stackSize = new IntegerRange(stackSizeStr);
        }
        String damageStr = properties.getProperty("damage");
        PercentageOrIntegerRange damage = new PercentageOrIntegerRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
        if (damageStr != null) {
            damage = new PercentageOrIntegerRange(damageStr);
        }
        String damageMaskStr = properties.getProperty("damageMask");
        int damageMask = Integer.MIN_VALUE;
        if (damageMaskStr != null) {
            damageMask = Integer.parseInt(damageMaskStr);
        }
        String handStr = properties.getProperty("hand");
        EquipmentSlot hand = null;
        if (handStr != null) {
            if (handStr.equals("main")) {
                hand = EquipmentSlot.HAND;
            } else if (handStr.equals("off")) {
                hand = EquipmentSlot.OFF_HAND;
            }
        }
        LinkedHashMap<Enchantment, IntegerRange> enchantments = new LinkedHashMap<Enchantment, IntegerRange>();
        String enchantmentsStr = properties.getProperty("enchantments");
        String enchantmentLevelsStr = properties.getProperty("enchantmentLevels");
        if (enchantmentsStr != null) {
            String[] levelsSection = enchantmentLevelsStr == null ? new String[]{} : enchantmentLevelsStr.split(" ");
            int i = 0;
            for (String section : enchantmentsStr.split(" ")) {
                Enchantment enchantment;
                try {
                    enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.fromString((String)section));
                }
                catch (Throwable e) {
                    enchantment = Enchantment.getByName((String)section);
                }
                IntegerRange level = new IntegerRange(1, Integer.MAX_VALUE);
                if (i < levelsSection.length) {
                    level = new IntegerRange(levelsSection[i]);
                }
                enchantments.put(enchantment, level);
                ++i;
            }
        }
        HashMap<String, CITValueMatcher> nbtMatch = new HashMap<String, CITValueMatcher>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("nbt")) continue;
            String path = key.substring(key.length() > 3 ? 4 : 3);
            String value = (String)entry.getValue();
            CITValueMatcher matcher = value.startsWith("regex:") ? new CITValueMatcher.RegexMatcher(value.substring(6)) : (value.startsWith("iregex:") ? new CITValueMatcher.IRegexMatcher(value.substring(7)) : (value.startsWith("pattern:") ? new CITValueMatcher.PatternMatcher(value.substring(8)) : (value.startsWith("ipattern:") ? new CITValueMatcher.IPatternMatcher(value.substring(9)) : new CITValueMatcher.DirectMatcher(value))));
            nbtMatch.put(path, matcher);
        }
        String type = properties.getProperty("type", "item");
        if (type.equalsIgnoreCase("item")) {
            HashMap<String, String> models = new HashMap<String, String>();
            HashMap<String, String> textures = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String value;
                String path;
                String key = (String)entry.getKey();
                if (key.startsWith("texture")) {
                    path = key.substring(key.length() > 7 ? 8 : 7);
                    value = (String)entry.getValue();
                    if (!value.endsWith(".png")) {
                        value = value + ".png";
                    }
                    textures.put(path, value);
                    continue;
                }
                if (!key.startsWith("model")) continue;
                path = key.substring(key.length() > 5 ? 6 : 5);
                value = (String)entry.getValue();
                if (!value.endsWith(".json")) {
                    value = value + ".json";
                }
                models.put(path, value);
            }
            if (models.isEmpty() && textures.isEmpty()) {
                ResourcePackFile defModel = file.getParentFile().getChild(name + ".json");
                if (defModel.exists()) {
                    models.put("", name + ".json");
                } else {
                    ResourcePackFile defTexture = file.getParentFile().getChild(name + ".png");
                    if (defTexture.exists()) {
                        textures.put("", name + ".png");
                    }
                }
            }
            return new ItemProperties(weight, items, stackSize, damage, damageMask, hand, enchantments, nbtMatch, models, textures);
        }
        if (type.equalsIgnoreCase("armor")) {
            HashMap<String, String> textures = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                if (!key.startsWith("texture")) continue;
                String path = key.substring(key.length() > 7 ? 8 : 7);
                String value = (String)entry.getValue();
                if (!value.endsWith(".png")) {
                    value = value + ".png";
                }
                textures.put(path, value);
            }
            return new ArmorProperties(weight, items, stackSize, damage, damageMask, hand, enchantments, nbtMatch, textures);
        }
        if (type.equalsIgnoreCase("elytra")) {
            texture = properties.getProperty("texture");
            if (texture == null) {
                ResourcePackFile defTexture = file.getParentFile().getChild(name + ".png");
                if (defTexture.exists()) {
                    texture = name + ".png";
                }
            } else if (!texture.endsWith(".png")) {
                texture = texture + ".png";
            }
            return new ElytraProperties(weight, items, stackSize, damage, damageMask, hand, enchantments, nbtMatch, texture);
        }
        if (type.equalsIgnoreCase("enchantment")) {
            texture = properties.getProperty("texture");
            if (texture == null) {
                ResourcePackFile defTexture = file.getParentFile().getChild(name + ".png");
                if (defTexture.exists()) {
                    texture = name + ".png";
                }
            } else if (!texture.endsWith(".png")) {
                texture = texture + ".png";
            }
            int layer = Integer.parseInt(properties.getProperty("layer", "0"));
            double speed = Double.parseDouble(properties.getProperty("speed", "1.0"));
            double rotation = Double.parseDouble(properties.getProperty("rotation", "0.0"));
            double duration = Double.parseDouble(properties.getProperty("duration", "0.0"));
            String blend = properties.getProperty("blend", "add");
            EnchantmentProperties.OpenGLBlending openGLBlending = EnchantmentProperties.OpenGLBlending.ADD;
            try {
                openGLBlending = EnchantmentProperties.OpenGLBlending.fromString(blend);
            }
            catch (Throwable e) {
                new ResourceLoadingException("Invalid blend mode \"" + blend + "\" in " + file.getAbsolutePath(), e).printStackTrace();
            }
            return new EnchantmentProperties(weight, items, stackSize, damage, damageMask, hand, enchantments, nbtMatch, layer, speed, rotation, duration, openGLBlending, texture);
        }
        throw new IllegalArgumentException("Invalid CIT property type \"" + type + "\"");
    }

    public CITProperties(int weight, Set<XMaterial> items, IntegerRange stackSize, PercentageOrIntegerRange damage, int damageMask, EquipmentSlot hand, Map<Enchantment, IntegerRange> enchantments, Map<String, CITValueMatcher> nbtMatch) {
        this.weight = weight;
        this.items = items;
        this.stackSize = stackSize;
        this.damage = damage;
        this.damageMask = damageMask;
        this.hand = hand;
        this.enchantments = enchantments;
        this.nbtMatch = nbtMatch;
    }

    public int getWeight() {
        return this.weight;
    }

    public Set<XMaterial> getItems() {
        return this.items;
    }

    public IntegerRange getStackSize() {
        return this.stackSize;
    }

    public PercentageOrIntegerRange getDamage() {
        return this.damage;
    }

    public int getDamageMask() {
        return this.damageMask;
    }

    public EquipmentSlot getHand() {
        return this.hand;
    }

    public Map<Enchantment, IntegerRange> getEnchantments() {
        return this.enchantments;
    }

    public Map<String, CITValueMatcher> getNbtMatch() {
        return this.nbtMatch;
    }

    public boolean test(EquipmentSlot heldSlot, ItemStack itemStack, UnaryOperator<String> translateFunction) {
        block27: {
            if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
                return false;
            }
            if (!this.items.contains(XMaterialUtils.matchXMaterial((ItemStack)itemStack))) {
                return false;
            }
            if (!this.stackSize.test(itemStack.getAmount())) {
                return false;
            }
            short maxDurability = itemStack.getType().getMaxDurability();
            int damage = 0;
            if (InteractiveChat.version.isLegacy()) {
                damage = itemStack.getDurability();
            } else if (itemStack.hasItemMeta() && itemStack.getItemMeta() instanceof Damageable) {
                damage = ((Damageable)itemStack.getItemMeta()).getDamage();
            }
            if (!this.damage.test(damage & this.damageMask, maxDurability)) {
                return false;
            }
            if (this.hand != null && !this.hand.equals((Object)heldSlot)) {
                return false;
            }
            if (!this.enchantments.isEmpty() && this.enchantments.entrySet().stream().noneMatch(entry -> ((IntegerRange)entry.getValue()).test(itemStack.getEnchantmentLevel((Enchantment)entry.getKey())))) {
                return false;
            }
            try {
                String nbt = ItemNBTUtils.getNMSItemStackJson((ItemStack)itemStack);
                CompoundTag tag = (CompoundTag)NBTParsingUtils.fromSNBT((String)nbt);
                if (tag.containsKey("tag")) {
                    tag = tag.getCompoundTag("tag");
                    for (Map.Entry<String, CITValueMatcher> entry2 : this.nbtMatch.entrySet()) {
                        String key = entry2.getKey();
                        CITValueMatcher nbtValueMatcher = entry2.getValue();
                        String[] paths = key.split("\\.");
                        ArrayList<CompoundTag> subTags = new ArrayList<CompoundTag>(Collections.singletonList(tag));
                        try {
                            for (String path : paths) {
                                for (int i = 0; i < subTags.size(); ++i) {
                                    Tag subTag2 = (Tag)subTags.get(i);
                                    if (path.equals("*")) {
                                        List tags;
                                        if (subTag2 instanceof CompoundTag) {
                                            tags = ((CompoundTag)subTag2).values();
                                        } else if (subTag2 instanceof ListTag) {
                                            tags = new ArrayList();
                                            for (Tag t : (ListTag)subTag2) {
                                                tags.add(t);
                                            }
                                        } else {
                                            tags = Collections.emptyList();
                                        }
                                        subTags.remove(i);
                                        subTags.addAll(i, tags);
                                        i += tags.size() - 1;
                                        continue;
                                    }
                                    if (subTag2 instanceof CompoundTag) {
                                        subTag2 = ((CompoundTag)subTag2).get(path);
                                    } else if (subTag2 instanceof ListTag) {
                                        subTag2 = ((ListTag)subTag2).get(Integer.parseInt(path));
                                    }
                                    subTags.set(i, (CompoundTag)subTag2);
                                }
                            }
                        }
                        catch (Throwable e) {
                            return false;
                        }
                        if (!subTags.stream().noneMatch(subTag -> {
                            block20: {
                                try {
                                    if (subTag instanceof StringTag) {
                                        String jsonResultValue;
                                        String rawStringValue = ((StringTag)subTag).getValue();
                                        try {
                                            Component component = InteractiveChatComponentSerializer.gson().deserialize((Object)rawStringValue);
                                            jsonResultValue = OptifineUtils.componentToString(component, translateFunction);
                                        }
                                        catch (Throwable ignore) {
                                            jsonResultValue = null;
                                        }
                                        if (!(nbtValueMatcher.matches(rawStringValue) || jsonResultValue != null && nbtValueMatcher.matches(jsonResultValue))) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (subTag instanceof IntTag) {
                                        if (!nbtValueMatcher.intTag().equals(subTag)) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (subTag instanceof LongTag) {
                                        if (!nbtValueMatcher.longTag().equals(subTag)) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (subTag instanceof ByteTag) {
                                        if (!nbtValueMatcher.byteTag().equals(subTag)) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (subTag instanceof ShortTag) {
                                        if (!nbtValueMatcher.shortTag().equals(subTag)) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (subTag instanceof FloatTag) {
                                        if (!nbtValueMatcher.floatTag().equals(subTag)) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (subTag instanceof DoubleTag) {
                                        if (!nbtValueMatcher.doubleTag().equals(subTag)) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    if (subTag instanceof CompoundTag || subTag instanceof ListTag) {
                                        if (!nbtValueMatcher.tag().equals(subTag)) {
                                            return false;
                                        }
                                        break block20;
                                    }
                                    return false;
                                }
                                catch (Throwable e) {
                                    return false;
                                }
                            }
                            return true;
                        })) continue;
                        return false;
                    }
                    break block27;
                }
                if (!this.nbtMatch.isEmpty()) {
                    return false;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public abstract String getOverrideAsset(String var1, String var2);
}

