/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit;

import java.util.Properties;

public class CITGlobalProperties {
    private boolean useGlint;
    private int cap;
    private EnchantmentVisibilityMethod method;
    private double fade;

    public static CITGlobalProperties fromProperties(Properties properties) {
        boolean useGlint = Boolean.parseBoolean(properties.getProperty("useGlint", "true"));
        int cap = Integer.parseInt(properties.getProperty("cap", "2147483647"));
        EnchantmentVisibilityMethod method = EnchantmentVisibilityMethod.valueOf(properties.getProperty("method", "average").toUpperCase());
        double fade = Double.parseDouble(properties.getProperty("fade", "0.5"));
        return new CITGlobalProperties(useGlint, cap, method, fade);
    }

    public CITGlobalProperties(boolean useGlint, int cap, EnchantmentVisibilityMethod method, double fade) {
        this.useGlint = useGlint;
        this.cap = cap;
        this.method = method;
        this.fade = fade;
    }

    public boolean isUseGlint() {
        return this.useGlint;
    }

    public int getCap() {
        return this.cap;
    }

    public EnchantmentVisibilityMethod getMethod() {
        return this.method;
    }

    public double getFade() {
        return this.fade;
    }

    public static enum EnchantmentVisibilityMethod {
        AVERAGE,
        LAYERED,
        CYCLE;

    }
}

