/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine;

import com.loohp.interactivechat.libs.org.apache.commons.io.input.BOMInputStream;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechat.objectholders.ValuePairs;
import com.loohp.interactivechatdiscordsrvaddon.graphics.ImageUtils;
import com.loohp.interactivechatdiscordsrvaddon.resources.CustomItemTextureRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.ModelRenderer;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.BlockModel;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.ModManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.IOptifineManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.OptifineItemTextureResolver;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.ArmorProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.CITGlobalProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.CITProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.ElytraProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.EnchantmentProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.optifine.cit.ItemProperties;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.GeneratedTextureResource;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.ITextureManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureMeta;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class OptifineManager
extends ModManager
implements IOptifineManager {
    public static final String MOD_NAME = "Optifine";
    public static final List<String> ASSETS_FOLDERS = Collections.unmodifiableList(Arrays.asList("optifine", "mcpatcher"));
    public static final CITGlobalProperties DEFAULT_CIT_GLOBAL_PROPERTIES = new CITGlobalProperties(true, Integer.MAX_VALUE, CITGlobalProperties.EnchantmentVisibilityMethod.AVERAGE, 0.5);
    public static final List<String> ASSET_EXTENSIONS = Collections.unmodifiableList(Arrays.asList("png", "json"));
    private static final BufferedImage BLANK_ENCHANTMENT = new BufferedImage(512, 512, 2);
    private Map<String, ValuePairs<ResourcePackFile, ?>> assets = new HashMap();
    private CITGlobalProperties citGlobalProperties = null;
    private Map<String, ValuePairs<ResourcePackFile, CITProperties>> citOverrides = new LinkedHashMap<String, ValuePairs<ResourcePackFile, CITProperties>>();

    public OptifineManager(ResourceManager manager) {
        super(manager, MOD_NAME, ASSETS_FOLDERS);
        if (manager.hasResourceRegistry("CustomItemTextureRegistry")) {
            manager.getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).appendResolver(new OptifineItemTextureResolver(this));
        }
    }

    @Override
    protected void loadDirectory(String namespace, ResourcePackFile root, Object ... meta) {
        JSONParser parser = new JSONParser();
        for (ResourcePackFile file : root.listFilesRecursively()) {
            try {
                JSONObject rootJson;
                Properties properties;
                InputStreamReader reader;
                String path = file.getRelativePathFrom(root);
                String key = namespace + ":" + root.getName() + "/" + path;
                String extension = "";
                if (key.lastIndexOf(".") >= 0) {
                    extension = key.substring(key.lastIndexOf(".") + 1);
                }
                if (path.equalsIgnoreCase("cit.properties")) {
                    if (this.citGlobalProperties != null) continue;
                    reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
                    properties = new Properties();
                    properties.load(reader);
                    reader.close();
                    this.citGlobalProperties = CITGlobalProperties.fromProperties(properties);
                    continue;
                }
                if (extension.equalsIgnoreCase("json")) {
                    reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
                    rootJson = (JSONObject)parser.parse((Reader)reader);
                    reader.close();
                    this.assets.put(key, new ValuePairs((Object)file, (Object)BlockModel.fromJson(this, key.substring(0, key.length() - (extension.isEmpty() ? 0 : extension.length() + 1)), rootJson)));
                    continue;
                }
                if (extension.equalsIgnoreCase("png")) {
                    this.assets.put(key, new ValuePairs((Object)file, (Object)new TextureResource((ITextureManager)this, key, file, true)));
                    continue;
                }
                if (extension.equalsIgnoreCase("mcmeta")) {
                    reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
                    rootJson = (JSONObject)parser.parse((Reader)reader);
                    reader.close();
                    TextureMeta textureMeta = TextureMeta.fromJson(this, key, file, rootJson);
                    this.assets.put(key, new ValuePairs((Object)file, (Object)textureMeta));
                    continue;
                }
                if (extension.equalsIgnoreCase("properties")) {
                    if (!path.startsWith("cit/")) continue;
                    reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
                    properties = new Properties();
                    properties.load(reader);
                    reader.close();
                    CITProperties citProperties = CITProperties.fromProperties(file, properties);
                    this.citOverrides.put(key, (ValuePairs<ResourcePackFile, CITProperties>)new ValuePairs((Object)file, (Object)citProperties));
                    continue;
                }
                this.assets.put(key, new ValuePairs((Object)file, null));
            }
            catch (Exception e) {
                new ResourceLoadingException("Unable to load optifine asset " + file.getAbsolutePath(), e).printStackTrace();
            }
        }
    }

    @Override
    protected void filterResources(Pattern namespace, Pattern path) {
        Iterator<String> itr = this.assets.keySet().iterator();
        while (itr.hasNext()) {
            String namespacedKey = itr.next();
            String assetNamespace = namespacedKey.substring(0, namespacedKey.indexOf(":"));
            String assetKey = namespacedKey.substring(namespacedKey.indexOf(":") + 1);
            if (!namespace.matcher(assetNamespace).matches() || !path.matcher(assetKey).matches()) continue;
            itr.remove();
        }
        Iterator<String> itr2 = this.citOverrides.keySet().iterator();
        while (itr2.hasNext()) {
            String namespacedKey = itr2.next();
            String assetNamespace = namespacedKey.substring(0, namespacedKey.indexOf(":"));
            String assetKey = namespacedKey.substring(namespacedKey.indexOf(":") + 1);
            if (!namespace.matcher(assetNamespace).matches() || !path.matcher(assetKey).matches()) continue;
            itr2.remove();
        }
    }

    @Override
    protected void reload() {
    }

    @Override
    public Function<BlockModel, ValuePairs<BlockModel, Map<String, TextureResource>>> getItemPostResolveFunction(EquipmentSlot heldSlot, ItemStack itemStack, boolean is1_8, Map<ModelOverride.ModelOverrideType, Float> predicates, UnaryOperator<String> translateFunction) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return ModelRenderer.DEFAULT_POST_RESOLVE_FUNCTION;
        }
        ValuePairs<ResourcePackFile, ItemProperties> citOverride = this.getCITOverride(heldSlot, itemStack, translateFunction, ItemProperties.class);
        if (citOverride == null) {
            return ModelRenderer.DEFAULT_POST_RESOLVE_FUNCTION;
        }
        return blockModel -> {
            String resourceLocation;
            String extension;
            String modelName;
            HashMap<String, TextureResource> overrideTextures = new HashMap<String, TextureResource>();
            CITProperties citProperties = (CITProperties)citOverride.getSecond();
            String string = modelName = blockModel == null ? null : blockModel.getResourceLocation();
            if (modelName != null) {
                if (modelName.contains(":")) {
                    modelName = modelName.substring(modelName.indexOf(":") + 1);
                }
                if (modelName.contains("/")) {
                    modelName = modelName.substring(modelName.lastIndexOf("/") + 1);
                }
            }
            for (String string2 : ASSET_EXTENSIONS) {
                String path;
                String rootPath = citProperties.getOverrideAsset("", string2);
                if (rootPath != null) {
                    String extension2 = rootPath.substring(rootPath.lastIndexOf(".") + 1);
                    String resourceLocation2 = OptifineManager.resolveAsset((ResourcePackFile)citOverride.getFirst(), rootPath, extension2);
                    if (extension2.equalsIgnoreCase("png")) {
                        overrideTextures.put("", this.getTexture(resourceLocation2));
                        continue;
                    }
                    if (!extension2.equalsIgnoreCase("json")) continue;
                    blockModel = this.resolveBlockModel(resourceLocation2, is1_8, predicates);
                    continue;
                }
                if (modelName == null || (path = citProperties.getOverrideAsset(modelName, string2)) == null) continue;
                extension = path.substring(path.lastIndexOf(".") + 1);
                resourceLocation = OptifineManager.resolveAsset((ResourcePackFile)citOverride.getFirst(), path, extension);
                if (extension.equalsIgnoreCase("png")) {
                    overrideTextures.put("layer0", this.getTexture(resourceLocation));
                    continue;
                }
                if (!extension.equalsIgnoreCase("json")) continue;
                blockModel = this.resolveBlockModel(resourceLocation, is1_8, predicates);
            }
            if (blockModel == null) {
                return new ValuePairs(null, overrideTextures);
            }
            for (Map.Entry entry : blockModel.getTextures().entrySet()) {
                String pathV;
                String key = (String)entry.getKey();
                String pathK = citProperties.getOverrideAsset((String)entry.getKey(), "png");
                if (pathK != null) {
                    extension = pathK.substring(pathK.lastIndexOf(".") + 1);
                    resourceLocation = OptifineManager.resolveAsset((ResourcePackFile)citOverride.getFirst(), pathK, extension);
                    if (!extension.equalsIgnoreCase("png")) continue;
                    overrideTextures.put(key, this.getTexture(resourceLocation));
                    continue;
                }
                String value = (String)entry.getValue();
                if (value.contains(":")) {
                    value = value.substring(value.indexOf(":") + 1);
                }
                if (value.contains("/")) {
                    value = value.substring(value.indexOf("/") + 1);
                }
                if ((pathV = citProperties.getOverrideAsset(value, "png")) != null) {
                    String extension3 = pathV.substring(pathV.lastIndexOf(".") + 1);
                    String resourceLocation3 = OptifineManager.resolveAsset((ResourcePackFile)citOverride.getFirst(), pathV, extension3);
                    if (!extension3.equalsIgnoreCase("png")) continue;
                    overrideTextures.put(key, this.getTexture(resourceLocation3));
                    continue;
                }
                String resourceLocation4 = OptifineManager.resolveAsset((ResourcePackFile)citOverride.getFirst(), (String)entry.getValue(), "png");
                TextureResource textureResource = this.getTexture(resourceLocation4, false);
                if (textureResource == null) continue;
                overrideTextures.put(key, textureResource);
            }
            return new ValuePairs(blockModel, overrideTextures);
        };
    }

    @Override
    public TextureResource getElytraOverrideTextures(EquipmentSlot heldSlot, ItemStack itemStack, UnaryOperator<String> translateFunction) {
        if (itemStack == null || !itemStack.getType().equals((Object)Material.valueOf((String)"ELYTRA"))) {
            return null;
        }
        ValuePairs<ResourcePackFile, ElytraProperties> citOverride = this.getCITOverride(heldSlot, itemStack, translateFunction, ElytraProperties.class);
        if (citOverride == null) {
            return null;
        }
        String path = ((ElytraProperties)citOverride.getSecond()).getOverrideAsset("", "png");
        if (path != null) {
            String extension = path.substring(path.lastIndexOf(".") + 1);
            String resourceLocation = OptifineManager.resolveAsset((ResourcePackFile)citOverride.getFirst(), path, "png");
            return this.getTexture(resourceLocation);
        }
        return null;
    }

    @Override
    public TextureResource getArmorOverrideTextures(String layer, EquipmentSlot heldSlot, ItemStack itemStack, UnaryOperator<String> translateFunction) {
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return null;
        }
        ValuePairs<ResourcePackFile, ArmorProperties> citOverride = this.getCITOverride(heldSlot, itemStack, translateFunction, ArmorProperties.class);
        if (citOverride == null) {
            return null;
        }
        String path = ((ArmorProperties)citOverride.getSecond()).getOverrideAsset(layer, "png");
        if (path == null) {
            path = ((ArmorProperties)citOverride.getSecond()).getOverrideAsset("", "png");
        }
        if (path != null) {
            String extension = path.substring(path.lastIndexOf(".") + 1);
            String resourceLocation = OptifineManager.resolveAsset((ResourcePackFile)citOverride.getFirst(), path, "png");
            return this.getTexture(resourceLocation);
        }
        return null;
    }

    @Override
    public List<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> getEnchantmentGlintOverrideTextures(EquipmentSlot heldSlot, ItemStack itemStack, UnaryOperator<String> translateFunction) {
        HashMap overrideTextures = new HashMap();
        if (itemStack == null || itemStack.getType().equals((Object)Material.AIR)) {
            return this.getCITGlobalProperties().isUseGlint() ? Collections.emptyList() : Collections.singletonList(new ValuePairs((Object)new GeneratedTextureResource(this.manager, BLANK_ENCHANTMENT), (Object)EnchantmentProperties.OpenGLBlending.ADD));
        }
        List<ValuePairs<ResourcePackFile, EnchantmentProperties>> citOverrides = this.getCITOverrides(heldSlot, itemStack, translateFunction, EnchantmentProperties.class);
        ArrayList<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>> result = new ArrayList<ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>>();
        Object2IntOpenHashMap layer = new Object2IntOpenHashMap();
        for (ValuePairs<ResourcePackFile, EnchantmentProperties> citOverride : citOverrides) {
            float intensity;
            EnchantmentProperties enchantmentProperties = (EnchantmentProperties)citOverride.getSecond();
            String path = enchantmentProperties.getOverrideAsset("", "png");
            if (path == null) continue;
            int currentLayer = enchantmentProperties.getLayer();
            ObjectIterator itr = layer.object2IntEntrySet().iterator();
            while (itr.hasNext()) {
                Object2IntMap.Entry entry = (Object2IntMap.Entry)itr.next();
                if (entry.getIntValue() != currentLayer) continue;
                itr.remove();
                result.removeIf(each -> ((TextureResource)each.getFirst()).equals(entry.getKey()));
            }
            String extension = path.substring(path.lastIndexOf(".") + 1);
            String resourceLocation = OptifineManager.resolveAsset((ResourcePackFile)citOverride.getFirst(), path, "png");
            BufferedImage texture = this.getTexture(resourceLocation).getTexture();
            Map stackEnchantments = itemStack.getEnchantments();
            switch (this.getCITGlobalProperties().getMethod()) {
                case AVERAGE: {
                    Enchantment enchantment = null;
                    for (Enchantment enchantment2 : enchantmentProperties.getEnchantments().keySet()) {
                        if (!stackEnchantments.containsKey(enchantment2)) continue;
                        enchantment = enchantment2;
                        break;
                    }
                    if (enchantment == null) {
                        intensity = 0.0f;
                        break;
                    }
                    float sum = 0.0f;
                    for (Integer value : stackEnchantments.values()) {
                        sum += (float)value.intValue();
                    }
                    intensity = (float)((Integer)stackEnchantments.get(enchantment)).intValue() / sum;
                    break;
                }
                case LAYERED: {
                    Enchantment enchantment = null;
                    for (Enchantment enchantment3 : enchantmentProperties.getEnchantments().keySet()) {
                        if (!stackEnchantments.containsKey(enchantment3)) continue;
                        enchantment = enchantment3;
                        break;
                    }
                    if (enchantment == null) {
                        intensity = 0.0f;
                        break;
                    }
                    float max = 0.0f;
                    for (Integer value : stackEnchantments.values()) {
                        if (!((float)value.intValue() > max)) continue;
                        max = value.intValue();
                    }
                    intensity = (float)((Integer)stackEnchantments.get(enchantment)).intValue() / max;
                    break;
                }
                default: {
                    intensity = 1.0f;
                }
            }
            if (intensity == 0.0f) {
                texture = new BufferedImage(texture.getWidth(), texture.getHeight(), 2);
            } else if (intensity < 1.0f) {
                BufferedImage blackImage = new BufferedImage(texture.getWidth(), texture.getHeight(), 2);
                Graphics2D g = blackImage.createGraphics();
                g.setColor(new Color(0, 0, 0, Math.min(255, (int)(255.0f * (1.0f - intensity)))));
                g.fillRect(0, 0, blackImage.getWidth(), blackImage.getHeight());
                g.dispose();
                Graphics2D graphics2D = texture.createGraphics();
                graphics2D.drawImage((Image)blackImage, 0, 0, null);
                graphics2D.dispose();
            }
            texture = ImageUtils.rotateImageByDegrees(texture, enchantmentProperties.getRotation());
            GeneratedTextureResource textureResource = new GeneratedTextureResource(this.manager, texture);
            result.add((ValuePairs<TextureResource, EnchantmentProperties.OpenGLBlending>)new ValuePairs((Object)textureResource, (Object)enchantmentProperties.getBlend()));
            layer.put((Object)textureResource, currentLayer);
        }
        if (result.isEmpty()) {
            return this.getCITGlobalProperties().isUseGlint() ? Collections.emptyList() : Collections.singletonList(new ValuePairs((Object)new GeneratedTextureResource(this.manager, BLANK_ENCHANTMENT), (Object)EnchantmentProperties.OpenGLBlending.ADD));
        }
        result.sort(Comparator.comparing(arg_0 -> OptifineManager.lambda$getEnchantmentGlintOverrideTextures$2((Object2IntMap)layer, arg_0)));
        for (int i = 0; i < result.size(); ++i) {
            if (!((EnchantmentProperties.OpenGLBlending)((ValuePairs)result.get(i)).getSecond()).equals(EnchantmentProperties.OpenGLBlending.REPLACE)) continue;
            for (int u = 0; u < i; ++u) {
                result.remove(u);
            }
            i = 1;
        }
        while (result.size() > this.getCITGlobalProperties().getCap() && !result.isEmpty()) {
            result.remove(0);
        }
        return result;
    }

    public static String resolveAsset(ResourcePackFile currentFile, String path, String extension) {
        String[] sections;
        if (path.startsWith("./")) {
            path = path.substring(2);
        }
        if (!path.toLowerCase().endsWith(extension.toLowerCase())) {
            path = path + "." + extension;
        }
        if (path.contains(":")) {
            sections = path.split(":", 2);
            if (sections[1].indexOf("/") == sections[1].lastIndexOf("/")) {
                if (extension.equalsIgnoreCase("png")) {
                    sections[1] = "textures/" + sections[1];
                } else if (extension.equalsIgnoreCase("json")) {
                    sections[1] = "models/" + sections[1];
                }
            }
            path = "assets/" + sections[0] + "/" + sections[1];
        }
        if (!path.contains("/")) {
            path = currentFile.getParentFile().getChild(path).getRelativePathFrom(currentFile.getPackRootFile());
            path = path.substring(path.indexOf("assets/"));
        }
        if (!path.startsWith("assets/")) {
            String[] section = currentFile.getRelativePathFrom(currentFile.getPackRootFile()).split("/");
            path = section[0] + "/" + section[1] + "/" + path;
        }
        path = new File("temp").toPath().relativize(new File("temp", path).toPath()).toString().replace("\\", "/");
        sections = path.split("/", 3);
        return sections[1] + ":" + sections[2];
    }

    public CITGlobalProperties getRawCITGlobalProperties() {
        return this.citGlobalProperties;
    }

    @Override
    public CITGlobalProperties getCITGlobalProperties() {
        return this.citGlobalProperties == null ? DEFAULT_CIT_GLOBAL_PROPERTIES : this.citGlobalProperties;
    }

    public Map<String, ValuePairs<ResourcePackFile, CITProperties>> getCITOverrides() {
        return this.citOverrides;
    }

    @Override
    public <T extends CITProperties> ValuePairs<ResourcePackFile, T> getCITOverride(EquipmentSlot heldSlot, ItemStack itemStack, UnaryOperator<String> translateFunction, Class<T> type) {
        ValuePairs<ResourcePackFile, CITProperties> result = null;
        int weight = Integer.MIN_VALUE;
        for (ValuePairs<ResourcePackFile, CITProperties> pair : this.citOverrides.values()) {
            CITProperties citProperties = (CITProperties)pair.getSecond();
            if (!type.isInstance(citProperties) || citProperties.getWeight() <= weight || !citProperties.test(heldSlot, itemStack, translateFunction)) continue;
            weight = citProperties.getWeight();
            result = pair;
        }
        return result;
    }

    @Override
    public <T extends CITProperties> List<ValuePairs<ResourcePackFile, T>> getCITOverrides(EquipmentSlot heldSlot, ItemStack itemStack, UnaryOperator<String> translateFunction, Class<T> type) {
        ArrayList<ValuePairs<ResourcePackFile, T>> result = new ArrayList<ValuePairs<ResourcePackFile, T>>();
        for (ValuePairs<ResourcePackFile, CITProperties> pair : this.citOverrides.values()) {
            CITProperties citProperties = (CITProperties)pair.getSecond();
            if (!type.isInstance(citProperties) || !citProperties.test(heldSlot, itemStack, translateFunction)) continue;
            result.add(pair);
        }
        result.sort(Comparator.comparing(each -> ((CITProperties)each.getSecond()).getWeight()));
        return result;
    }

    @Override
    public TextureResource getTexture(String resourceLocation, boolean returnMissingTexture) {
        TextureResource textureResource = this.manager.getTextureManager().getTexture(resourceLocation, false);
        if (textureResource != null) {
            return textureResource;
        }
        ValuePairs<ResourcePackFile, ?> asset = this.assets.get(resourceLocation);
        if (asset != null && asset.getSecond() instanceof TextureResource) {
            return (TextureResource)asset.getSecond();
        }
        if (returnMissingTexture) {
            return TextureManager.getMissingTexture(this.manager);
        }
        return null;
    }

    @Override
    public BlockModel getRawBlockModel(String resourceLocation) {
        BlockModel model = this.manager.getModelManager().getRawBlockModel(resourceLocation);
        if (model != null) {
            return model;
        }
        ValuePairs<ResourcePackFile, ?> asset = this.assets.get(resourceLocation);
        if (asset != null && asset.getSecond() instanceof BlockModel) {
            return (BlockModel)asset.getSecond();
        }
        return null;
    }

    @Override
    public BlockModel resolveBlockModel(String resourceLocation, boolean is1_8, Map<ModelOverride.ModelOverrideType, Float> predicates) {
        BlockModel model = this.getRawBlockModel(resourceLocation);
        if (model == null) {
            return null;
        }
        for (ModelOverride override : model.getOverrides()) {
            if (!override.test(predicates)) continue;
            return this.resolveBlockModel(override.getModel(), is1_8, null);
        }
        while (model.getParent() != null && !model.getRawParent().equals("builtin/generated")) {
            if (model.getRawParent().equals("builtin/entity")) {
                BlockModel builtinModel = this.resolveBlockModel("minecraft:interactivechatdiscordsrvaddon/builtin_entity/" + resourceLocation.substring(resourceLocation.lastIndexOf("/") + 1), is1_8, predicates);
                if (builtinModel == null) break;
                return builtinModel;
            }
            BlockModel parent = this.getRawBlockModel(model.getParent());
            if (parent == null) break;
            for (ModelOverride override : model.getOverrides()) {
                if (!override.test(predicates)) continue;
                return this.resolveBlockModel(override.getModel(), is1_8, null);
            }
            model = model.resolve(parent, is1_8);
        }
        return model.resolve(is1_8);
    }

    private static /* synthetic */ Integer lambda$getEnchantmentGlintOverrideTextures$2(Object2IntMap layer, ValuePairs each) {
        return layer.getOrDefault((Object)each, 0);
    }
}

