/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.Component;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.ComponentIteratorFlag;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.ComponentIteratorType;
import com.loohp.interactivechat.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.ByteTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.CompoundTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.IntTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.ListTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.LongTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.NumberTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.ShortTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.StringTag;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.Tag;
import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.utils.InteractiveChatComponentSerializer;
import com.loohp.interactivechat.utils.ItemNBTUtils;
import com.loohp.interactivechat.utils.NBTParsingUtils;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.BiomePrecipitation;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimeModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimePredicateEnums;
import com.loohp.interactivechatdiscordsrvaddon.utils.ComponentStringUtils;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class ChimeUtils {
    public static String getItemDisplayName(ItemStack itemStack, UnaryOperator<String> translateFunction) {
        if (!itemStack.hasItemMeta() || !itemStack.getItemMeta().hasDisplayName()) {
            return "";
        }
        try {
            String rawStringValue = ((CompoundTag)NBTParsingUtils.fromSNBT((String)ItemNBTUtils.getNMSItemStackJson((ItemStack)itemStack))).getCompoundTag("tag").getCompoundTag("display").getString("Name");
            try {
                Component component = InteractiveChatComponentSerializer.gson().deserialize((Object)rawStringValue);
                return ChimeUtils.componentToString(component, translateFunction);
            }
            catch (Throwable ignore) {
                return rawStringValue;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String componentToString(Component component, UnaryOperator<String> translateFunction) {
        StringBuilder sb = new StringBuilder();
        for (Component each : ComponentStringUtils.resolve(component, translateFunction).iterable(ComponentIteratorType.DEPTH_FIRST, new ComponentIteratorFlag[0])) {
            if (!(each instanceof TextComponent)) continue;
            sb.append(((TextComponent)each).content());
        }
        return sb.toString();
    }

    public static Map<ChimeModelOverride.ChimeModelOverrideType, Object> getAllPredicates(JSONObject predicateJson, String ... preKeys) {
        EnumMap<ChimeModelOverride.ChimeModelOverrideType, Object> map = new EnumMap<ChimeModelOverride.ChimeModelOverrideType, Object>(ChimeModelOverride.ChimeModelOverrideType.class);
        for (Object obj : predicateJson.keySet()) {
            String predicateTypeKey = obj.toString();
            Object value = predicateJson.get((Object)predicateTypeKey);
            String[] keys = new String[preKeys.length + 1];
            System.arraycopy(preKeys, 0, keys, 0, preKeys.length);
            keys[keys.length - 1] = predicateTypeKey;
            ChimeModelOverride.ChimeModelOverrideType type = ChimeModelOverride.ChimeModelOverrideType.fromKeys(keys);
            if (type == null) {
                if (!(value instanceof JSONObject)) continue;
                map.putAll(ChimeUtils.getAllPredicates((JSONObject)value, keys));
                continue;
            }
            Class<?> valueType = type.getValueType();
            if (valueType.equals(String.class)) {
                map.put(type, (Object)value.toString());
                continue;
            }
            if (valueType.equals(Range.class)) {
                map.put(type, ChimeUtils.parseRange(Float.class, value.toString()));
                continue;
            }
            if (valueType.equals(HashPredicate.class)) {
                map.put(type, (Object)HashPredicate.parseType((JSONObject)value));
                continue;
            }
            if (valueType.equals(BiomePrecipitation.class)) {
                map.put(type, (Object)BiomePrecipitation.fromName(value.toString()));
                continue;
            }
            if (valueType.equals(ChimePredicateEnums.ItemInHand.class)) {
                map.put(type, (Object)ChimePredicateEnums.ItemInHand.fromName(value.toString()));
                continue;
            }
            if (valueType.equals(EquipmentSlot.class)) {
                map.put(type, (Object)EquipmentSlot.valueOf((String)value.toString().toUpperCase()));
                continue;
            }
            if (valueType.equals(ChimePredicateEnums.TargetType.class)) {
                map.put(type, (Object)ChimePredicateEnums.TargetType.fromName(value.toString()));
                continue;
            }
            map.put(type, value);
        }
        return map;
    }

    public static boolean matchesJsonObject(JSONObject object, CompoundTag tag) {
        for (Object obj : object.keySet()) {
            String key = obj.toString();
            Object element = object.get((Object)key);
            if (!(element == null ? tag.containsKey(key) : !tag.containsKey(key) || !ChimeUtils.matchesJsonElement(element, tag.get(key)))) continue;
            return false;
        }
        return true;
    }

    public static boolean matchesJsonArray(JSONArray array, ListTag<?> list) {
        block0: for (Object element : array) {
            for (Tag tag : list) {
                if (!ChimeUtils.matchesJsonElement(element, tag)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public static boolean matchesJsonElement(Object element, Tag<?> tag) {
        if (element instanceof JSONObject) {
            return tag instanceof CompoundTag && ChimeUtils.matchesJsonObject((JSONObject)element, (CompoundTag)tag);
        }
        if (element instanceof JSONArray) {
            return tag instanceof ListTag && ChimeUtils.matchesJsonArray((JSONArray)element, (ListTag)tag);
        }
        if (tag instanceof NumberTag) {
            boolean isInt;
            NumberTag number = (NumberTag)tag;
            boolean bl = isInt = tag instanceof ByteTag || tag instanceof ShortTag || tag instanceof IntTag || tag instanceof LongTag;
            if (element instanceof Boolean) {
                return isInt && (Boolean)element == (number.asInt() == 1);
            }
            if (element instanceof Number) {
                if (isInt) {
                    return ((Number)element).longValue() == number.asLong();
                }
                return ((Number)element).doubleValue() == number.asDouble();
            }
            if (element instanceof String) {
                if (isInt) {
                    Range<Long> r = ChimeUtils.parseRange(Long.class, (String)element);
                    return r != null && r.contains((Comparable)Long.valueOf(number.asLong()));
                }
                Range<Double> r = ChimeUtils.parseRange(Double.class, (String)element);
                return r != null && r.contains((Comparable)Double.valueOf(number.asDouble()));
            }
        } else if (tag instanceof StringTag && element instanceof String) {
            return element.equals(((StringTag)tag).getValue());
        }
        return false;
    }

    public static <T extends Comparable<T>> Range<T> parseRange(Class<T> clazz, String s) {
        try {
            if (s.startsWith("<=")) {
                return Range.upTo(ChimeUtils.parseNumber(clazz, s.substring(2)), (BoundType)BoundType.CLOSED);
            }
            if (s.startsWith("<")) {
                return Range.upTo(ChimeUtils.parseNumber(clazz, s.substring(1)), (BoundType)BoundType.OPEN);
            }
            if (s.startsWith(">=")) {
                return Range.downTo(ChimeUtils.parseNumber(clazz, s.substring(2)), (BoundType)BoundType.CLOSED);
            }
            if (s.startsWith(">")) {
                return Range.downTo(ChimeUtils.parseNumber(clazz, s.substring(1)), (BoundType)BoundType.CLOSED);
            }
            if (s.startsWith("[") || s.startsWith("(")) {
                String[] parts = s.split("\\.\\.");
                if (parts.length == 2) {
                    BoundType lt = parts[0].startsWith("[") ? BoundType.CLOSED : BoundType.OPEN;
                    BoundType rt = parts[1].endsWith("[") ? BoundType.CLOSED : BoundType.OPEN;
                    return Range.range(ChimeUtils.parseNumber(clazz, parts[0].substring(1)), (BoundType)lt, ChimeUtils.parseNumber(clazz, parts[1].substring(0, parts[1].length() - 1)), (BoundType)rt);
                }
            } else {
                String[] parts = s.split("\\.\\.");
                if (parts.length == 2) {
                    return Range.closed(ChimeUtils.parseNumber(clazz, parts[0]), ChimeUtils.parseNumber(clazz, parts[1]));
                }
            }
            return Range.singleton(ChimeUtils.parseNumber(clazz, s));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T extends Comparable<T>> T parseNumber(Class<T> clazz, String s) {
        if (clazz == Double.class) {
            return (T)Double.valueOf(s);
        }
        if (clazz == Float.class) {
            return (T)Float.valueOf(s);
        }
        if (clazz == Long.class) {
            return (T)Long.valueOf(s);
        }
        throw new UnsupportedOperationException();
    }

    public static class HashPredicate {
        public String subTag;
        public int modulo;
        public Range<Float> value;

        public HashPredicate(String subTag, int modulo, Range<Float> value) {
            this.subTag = subTag;
            this.modulo = modulo;
            this.value = value;
        }

        public boolean matches(Tag<?> tag) {
            try {
                String[] tags;
                for (String t : tags = this.subTag.split("/")) {
                    if (t.length() == 0) continue;
                    tag = ((CompoundTag)tag).get(t);
                }
                int i = tag.toString().hashCode();
                if ((i %= this.modulo) < 0) {
                    i += this.modulo;
                }
                return this.value.contains((Comparable)Float.valueOf(i));
            }
            catch (Exception exception) {
                return this.value.contains((Comparable)Float.valueOf(-1.0f));
            }
        }

        public static HashPredicate parseType(JSONObject object) {
            int modulo = ((Number)object.get((Object)"modulo")).intValue();
            Range<Float> value = ChimeUtils.parseRange(Float.class, (String)object.get((Object)"value"));
            String subTag = "";
            if (object.containsKey((Object)"tag")) {
                subTag = (String)object.get((Object)"tag");
            }
            return new HashPredicate(subTag, modulo, value);
        }
    }
}

