/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ChimePredicateEnums {

    public static enum TargetType {
        BLOCK,
        ENTITY,
        MISS;


        public static TargetType fromName(String name) {
            for (TargetType targetType : TargetType.values()) {
                if (!targetType.name().equalsIgnoreCase(name)) continue;
                return targetType;
            }
            return null;
        }
    }

    public static enum ItemInHand {
        MAIN("main"),
        OFF("off"),
        EITHER("either"),
        NEITHER("neither", "none");

        private Set<String> names;

        private ItemInHand(String ... names) {
            this.names = new HashSet<String>(Arrays.asList(names));
        }

        public Set<String> getNames() {
            return this.names;
        }

        public static ItemInHand fromName(String name) {
            for (ItemInHand itemInHand : ItemInHand.values()) {
                if (!itemInHand.getNames().stream().anyMatch(each -> each.equalsIgnoreCase(name))) continue;
                return itemInHand;
            }
            return null;
        }
    }
}

