/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime;

import com.google.common.collect.Range;
import com.loohp.interactivechat.libs.io.github.bananapuncher714.nbteditor.NBTEditor;
import com.loohp.interactivechat.libs.net.querz.nbt.tag.CompoundTag;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.objectholders.OfflineICPlayer;
import com.loohp.interactivechat.utils.ItemNBTUtils;
import com.loohp.interactivechat.utils.NBTParsingUtils;
import com.loohp.interactivechatdiscordsrvaddon.objectholders.BiomePrecipitation;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimePredicateEnums;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimeUtils;
import com.loohp.interactivechatdiscordsrvaddon.utils.WorldUtils;
import com.loohp.interactivechatdiscordsrvaddon.wrappers.DimensionManagerWrapper;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.util.RayTraceResult;

public class ChimeModelOverride
extends ModelOverride {
    private Map<ChimeModelOverrideType, Object> chimePredicates;
    private String armorTexture;

    public ChimeModelOverride(Map<ModelOverride.ModelOverrideType, Float> predicates, Map<ChimeModelOverrideType, Object> chimePredicates, String model, String armorTexture) {
        super(predicates, model);
        this.chimePredicates = chimePredicates;
        this.armorTexture = armorTexture;
    }

    public ChimeModelOverride(Map<ModelOverride.ModelOverrideType, Float> predicates, Map<ChimeModelOverrideType, Object> chimePredicates, String model) {
        this(predicates, chimePredicates, model, null);
    }

    public Map<ChimeModelOverrideType, Object> getChimePredicates() {
        return this.chimePredicates;
    }

    public boolean hasArmorTexture() {
        return this.armorTexture != null;
    }

    public String getArmorTexture() {
        return this.armorTexture;
    }

    @Override
    @Deprecated
    public boolean test(Map<ModelOverride.ModelOverrideType, Float> data) {
        if (this.chimePredicates.isEmpty()) {
            return super.test(data);
        }
        return false;
    }

    public boolean test(Map<ModelOverride.ModelOverrideType, Float> data, OfflineICPlayer player, World world, LivingEntity entity, ItemStack itemStack, UnaryOperator<String> translateFunction) {
        if (!super.test(data)) {
            return false;
        }
        for (Map.Entry<ChimeModelOverrideType, Object> entry : this.chimePredicates.entrySet()) {
            if (entry.getKey().test(entry.getValue(), player, world, entity, itemStack, translateFunction)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChimeModelOverride that = (ChimeModelOverride)o;
        return Objects.equals(this.chimePredicates, that.chimePredicates) && Objects.equals(this.armorTexture, that.armorTexture);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.chimePredicates, this.armorTexture);
    }

    public static enum ChimeModelOverrideType {
        COUNT("count", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> value.contains((Comparable)Integer.valueOf(itemStack.getAmount()))),
        DURABILITY("durability", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (itemStack.hasItemMeta() && itemStack.getItemMeta() instanceof Damageable) {
                return value.contains((Comparable)Integer.valueOf(((Damageable)itemStack.getItemMeta()).getDamage()));
            }
            return value.contains((Comparable)Integer.valueOf(0));
        }),
        NBT("nbt", JSONObject.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            String nbt = ItemNBTUtils.getNMSItemStackJson((ItemStack)itemStack);
            CompoundTag compoundTag = (CompoundTag)NBTParsingUtils.fromSNBT((String)nbt);
            if (compoundTag.containsKey("tag")) {
                return ChimeUtils.matchesJsonObject(value, compoundTag.getCompoundTag("tag"));
            }
            return false;
        }),
        NAME("name", String.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            String name = ChimeUtils.getItemDisplayName(itemStack, translateFunction);
            if (value.startsWith("/") && value.endsWith("/")) {
                return Pattern.matches(value.substring(1, value.length() - 1), name);
            }
            return value.equals(name);
        }),
        HASH("hash", ChimeUtils.HashPredicate.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            String nbt = ItemNBTUtils.getNMSItemStackJson((ItemStack)itemStack);
            CompoundTag compoundTag = (CompoundTag)NBTParsingUtils.fromSNBT((String)nbt);
            if (compoundTag.containsKey("tag")) {
                return value.matches((com.loohp.interactivechat.libs.net.querz.nbt.tag.Tag<?>)compoundTag.getCompoundTag("tag"));
            }
            return false;
        }),
        DIMENSION_ID("dimension/id", String.class, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && WorldUtils.getNamespacedKey(world).equals(value)),
        DIMENSION_HAS_SKY_LIGHT("dimension/has_sky_light", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).hasSkyLight() == value.booleanValue()),
        DIMENSION_HAS_CEILING("dimension/has_ceiling", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).hasCeiling() == value.booleanValue()),
        DIMENSION_ULTRAWARM("dimension/ultrawarm", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).ultraWarm() == value.booleanValue()),
        DIMENSION_NATURAL("dimension/natural", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).natural() == value.booleanValue()),
        DIMENSION_HAS_ENDER_DRAGON_FIGHT("dimension/has_ender_dragon_fight", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).createDragonFight() == value.booleanValue()),
        DIMENSION_PIGLIN_SAFE("dimension/piglin_safe", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).piglinSafe() == value.booleanValue()),
        DIMENSION_BED_WORKS("dimension/bed_works", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).bedWorks() == value.booleanValue()),
        DIMENSION_RESPAWN_ANCHOR_WORKS("dimension/respawn_anchor_works", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).respawnAnchorWorks() == value.booleanValue()),
        DIMENSION_HAS_RAIDS("dimension/has_raids", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && new DimensionManagerWrapper(world).hasRaids() == value.booleanValue()),
        WORLD_RAINING("world/raining", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && world.hasStorm() == value.booleanValue()),
        WORLD_THUNDERING("world/thundering", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && world.isThundering() == value.booleanValue()),
        WORLD_BIOME_ID("world/biome/id", String.class, (value, player, world, livingEntity, itemStack, translateFunction) -> world != null && livingEntity != null && world.getBiome(livingEntity.getLocation()).getKey().toString().equals(value)),
        WORLD_BIOME_PRECIPITATION("world/biome/precipitation", BiomePrecipitation.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (world == null || livingEntity == null) {
                return false;
            }
            return WorldUtils.getPrecipitation(livingEntity.getLocation()).equals(value);
        }),
        WORLD_BIOME_TEMPERATURE("world/biome/temperature", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (world == null || livingEntity == null) {
                return false;
            }
            Location location = livingEntity.getLocation();
            try {
                return value.contains((Comparable)Double.valueOf(world.getTemperature(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
            }
            catch (Throwable e) {
                return value.contains((Comparable)Double.valueOf(world.getTemperature(location.getBlockX(), location.getBlockZ())));
            }
        }),
        WORLD_BIOME_DOWNFALL("world/biome/downfall", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (world == null || livingEntity == null) {
                return false;
            }
            Location location = livingEntity.getLocation();
            try {
                return value.contains((Comparable)Double.valueOf(world.getHumidity(location.getBlockX(), location.getBlockY(), location.getBlockZ())));
            }
            catch (Throwable e) {
                return value.contains((Comparable)Double.valueOf(world.getHumidity(location.getBlockX(), location.getBlockZ())));
            }
        }),
        ENTITY_NBT("entity/nbt", JSONObject.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (livingEntity == null) {
                return false;
            }
            String nbt = NBTEditor.getNBTCompound((Object)livingEntity, (Object[])new Object[0]).toJson();
            CompoundTag compoundTag = (CompoundTag)NBTParsingUtils.fromSNBT((String)nbt);
            return ChimeUtils.matchesJsonObject(value, compoundTag);
        }),
        ENTITY_X("entity/x", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> livingEntity != null && value.contains((Comparable)Double.valueOf(livingEntity.getLocation().getX()))),
        ENTITY_Y("entity/y", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> livingEntity != null && value.contains((Comparable)Double.valueOf(livingEntity.getLocation().getY()))),
        ENTITY_Z("entity/z", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> livingEntity != null && value.contains((Comparable)Double.valueOf(livingEntity.getLocation().getZ()))),
        ENTITY_LIGHT("entity/light", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> livingEntity != null && value.contains((Comparable)Byte.valueOf(livingEntity.getLocation().getBlock().getLightLevel()))),
        ENTITY_BLOCK_LIGHT("entity/block_light", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> livingEntity != null && value.contains((Comparable)Byte.valueOf(livingEntity.getLocation().getBlock().getLightFromBlocks()))),
        ENTITY_SKY_LIGHT("entity/sky_light", Range.class, (value, player, world, livingEntity, itemStack, translateFunction) -> livingEntity != null && value.contains((Comparable)Byte.valueOf(livingEntity.getLocation().getBlock().getLightFromSky()))),
        ENTITY_CAN_SEE_SKY("entity/can_see_sky", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (livingEntity == null) {
                return false;
            }
            Location location = livingEntity.getEyeLocation();
            return (double)livingEntity.getWorld().getHighestBlockYAt(location) <= location.getY() == value;
        }),
        ENTITY_HAND("entity/hand", ChimePredicateEnums.ItemInHand.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (livingEntity == null) {
                if (player == null) {
                    return false;
                }
                boolean mainhand = Objects.equals(player.getEquipment().getItemInMainHand(), itemStack);
                boolean offhand = Objects.equals(player.getEquipment().getItemInOffHand(), itemStack);
                switch (value) {
                    case MAIN: {
                        return mainhand;
                    }
                    case OFF: {
                        return offhand;
                    }
                    case EITHER: {
                        return mainhand || offhand;
                    }
                    case NEITHER: {
                        return !mainhand && !offhand;
                    }
                }
            } else {
                boolean mainhand = Objects.equals(livingEntity.getEquipment().getItemInMainHand(), itemStack);
                boolean offhand = Objects.equals(livingEntity.getEquipment().getItemInOffHand(), itemStack);
                switch (value) {
                    case MAIN: {
                        return mainhand;
                    }
                    case OFF: {
                        return offhand;
                    }
                    case EITHER: {
                        return mainhand || offhand;
                    }
                    case NEITHER: {
                        return !mainhand && !offhand;
                    }
                }
            }
            return false;
        }),
        ENTITY_SLOT("entity/slot", EquipmentSlot.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (livingEntity == null) {
                if (player == null) {
                    return false;
                }
                switch (value) {
                    case HEAD: {
                        return Objects.equals(player.getEquipment().getHelmet(), itemStack);
                    }
                    case CHEST: {
                        return Objects.equals(player.getEquipment().getChestplate(), itemStack);
                    }
                    case LEGS: {
                        return Objects.equals(player.getEquipment().getLeggings(), itemStack);
                    }
                    case FEET: {
                        return Objects.equals(player.getEquipment().getBoots(), itemStack);
                    }
                }
            } else {
                switch (value) {
                    case HEAD: {
                        return Objects.equals(livingEntity.getEquipment().getHelmet(), itemStack);
                    }
                    case CHEST: {
                        return Objects.equals(livingEntity.getEquipment().getChestplate(), itemStack);
                    }
                    case LEGS: {
                        return Objects.equals(livingEntity.getEquipment().getLeggings(), itemStack);
                    }
                    case FEET: {
                        return Objects.equals(livingEntity.getEquipment().getBoots(), itemStack);
                    }
                }
            }
            return false;
        }),
        ENTITY_TARGET("entity/target", ChimePredicateEnums.TargetType.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (!(livingEntity instanceof Player)) {
                return false;
            }
            RayTraceResult result = livingEntity.rayTraceBlocks(5.0, FluidCollisionMode.NEVER);
            switch (value) {
                case BLOCK: {
                    return result.getHitBlock() != null;
                }
                case ENTITY: {
                    return result.getHitEntity() != null;
                }
                case MISS: {
                    return result.getHitEntity() == null && result.getHitBlock() == null;
                }
            }
            return false;
        }),
        ENTITY_TARGET_BLOCK_ID("entity/target_block/id", String.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            RayTraceResult result;
            if (livingEntity == null) {
                return false;
            }
            if (!value.contains(":")) {
                value = "minecraft:" + value;
            }
            if ((result = livingEntity.rayTraceBlocks(5.0, FluidCollisionMode.NEVER)).getHitBlock() == null) {
                return value.equals("minecraft:air");
            }
            Material material = result.getHitBlock().getType();
            if (value.startsWith("#")) {
                value = value.substring(1);
                for (Tag tag : Bukkit.getTags((String)"blocks", Material.class)) {
                    if (!value.equals(tag.getKey().toString())) continue;
                    return tag.isTagged((Keyed)material);
                }
                return false;
            }
            return value.equals(material.getKey().toString());
        }),
        ENTITY_TARGET_BLOCK_CAN_MINE("entity/target_block/can_mine", Boolean.TYPE, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (livingEntity == null) {
                return false;
            }
            RayTraceResult result = livingEntity.rayTraceBlocks(5.0, FluidCollisionMode.NEVER);
            if (result.getHitBlock() == null) {
                return false;
            }
            return result.getHitBlock().isPreferredTool(itemStack);
        }),
        ENTITY_TARGET_ENTITY_ID("entity/target_entity/id", String.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            RayTraceResult result;
            if (livingEntity == null) {
                return false;
            }
            if (!value.contains(":")) {
                value = "minecraft:" + value;
            }
            if ((result = livingEntity.rayTraceBlocks(5.0, FluidCollisionMode.NEVER)).getHitEntity() == null) {
                return false;
            }
            return result.getHitEntity().getType().getKey().toString().equals(value);
        }),
        ENTITY_TARGET_ENTITY_NBT("entity/target_entity/nbt", JSONObject.class, (value, player, world, livingEntity, itemStack, translateFunction) -> {
            if (livingEntity == null) {
                return false;
            }
            RayTraceResult result = livingEntity.rayTraceBlocks(5.0, FluidCollisionMode.NEVER);
            if (result.getHitEntity() == null) {
                return false;
            }
            String nbt = NBTEditor.getNBTCompound((Object)result.getHitEntity(), (Object[])new Object[0]).toJson();
            CompoundTag compoundTag = (CompoundTag)NBTParsingUtils.fromSNBT((String)nbt);
            return ChimeUtils.matchesJsonObject(value, compoundTag);
        });

        private String key;
        private String[] sectionedKeys;
        private Class<?> valueType;
        private ChimeOverridePredicate<Object> predicate;

        private <T> ChimeModelOverrideType(String key, Class<T> valueType, ChimeOverridePredicate<T> predicate) {
            this.key = key;
            this.sectionedKeys = key.split("/");
            this.valueType = valueType;
            this.predicate = predicate;
        }

        public String getKey() {
            return this.key;
        }

        public Class<?> getValueType() {
            return this.valueType;
        }

        public ChimeOverridePredicate<Object> getPredicate() {
            return this.predicate;
        }

        public boolean test(Object value, OfflineICPlayer player, World world, LivingEntity entity, ItemStack itemStack, UnaryOperator<String> translateFunction) {
            try {
                return this.predicate.test(value, player, world, entity, itemStack, translateFunction);
            }
            catch (Throwable e) {
                return false;
            }
        }

        public static ChimeModelOverrideType fromKeys(String ... keys) {
            for (ChimeModelOverrideType type : ChimeModelOverrideType.values()) {
                if (!ChimeModelOverrideType.keysMatch(type.sectionedKeys, keys)) continue;
                return type;
            }
            return null;
        }

        private static boolean keysMatch(String[] source, String[] target) {
            if (source.length != target.length) {
                return false;
            }
            for (int i = 0; i < source.length; ++i) {
                if (source[i].equalsIgnoreCase(target[i])) continue;
                return false;
            }
            return true;
        }

        public static ChimeModelOverrideType fromKey(String key) {
            String[] sections = key.split("/");
            return ChimeModelOverrideType.fromKeys(sections);
        }
    }

    @FunctionalInterface
    public static interface ChimeOverridePredicate<T> {
        public boolean test(T var1, OfflineICPlayer var2, World var3, LivingEntity var4, ItemStack var5, UnaryOperator<String> var6) throws Throwable;
    }
}

