/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime;

import com.loohp.interactivechat.libs.org.apache.commons.io.input.BOMInputStream;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechat.objectholders.OfflineICPlayer;
import com.loohp.interactivechatdiscordsrvaddon.resources.CustomItemTextureRegistry;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.BlockModel;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.IModelManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.ModManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimeBlockModel;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimeItemTextureResolver;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimeModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.IChimeManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.ITextureManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.textures.TextureResource;
import com.loohp.interactivechatdiscordsrvaddon.utils.TriFunction;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.bukkit.World;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class ChimeManager
extends ModManager
implements IChimeManager {
    public static final String MOD_NAME = "Chime";
    public static final List<String> ASSETS_FOLDERS = Collections.singletonList("overrides");
    public static final TriFunction<IModelManager, String, JSONObject, ChimeBlockModel> CHIME_MODEL_PARSING_FUNCTION = (manager, key, json) -> ChimeBlockModel.fromJson(manager, key, json);
    private List<String> overrideLocations = new ArrayList<String>();
    private Map<String, TextureResource> textures = new HashMap<String, TextureResource>();
    private Map<String, ChimeBlockModel> models = new HashMap<String, ChimeBlockModel>();

    public ChimeManager(ResourceManager manager) {
        super(manager, MOD_NAME, ASSETS_FOLDERS);
        manager.getModelManager().setModelParsingFunction(CHIME_MODEL_PARSING_FUNCTION);
        if (manager.hasResourceRegistry("CustomItemTextureRegistry")) {
            manager.getResourceRegistry("CustomItemTextureRegistry", CustomItemTextureRegistry.class).appendResolver(new ChimeItemTextureResolver(this));
        }
    }

    @Override
    protected void loadDirectory(String namespace, ResourcePackFile root, Object ... meta) {
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException(root.getAbsolutePath() + " is not a directory.");
        }
        this.overrideLocations.add(root.getName() + "/");
        JSONParser parser = new JSONParser();
        HashMap<String, ChimeBlockModel> models = new HashMap<String, ChimeBlockModel>();
        HashMap<String, TextureResource> textures = new HashMap<String, TextureResource>();
        Collection<ResourcePackFile> files = root.listFilesRecursively(new String[]{"json", "png"});
        for (ResourcePackFile file : files) {
            try {
                String name = file.getName();
                String relativePath = file.getRelativePathFrom(root);
                String key = namespace + ":" + root.getName() + "/" + relativePath;
                key = key.substring(0, key.lastIndexOf("."));
                if (name.endsWith(".json")) {
                    InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
                    JSONObject rootJson = (JSONObject)parser.parse((Reader)reader);
                    reader.close();
                    rootJson.remove((Object)"textures");
                    String parent = namespace + ":" + relativePath;
                    if (parent.contains(".")) {
                        parent = parent.substring(0, parent.lastIndexOf("."));
                    }
                    rootJson.put((Object)"parent", (Object)parent);
                    ChimeBlockModel model = CHIME_MODEL_PARSING_FUNCTION.apply(this, key, rootJson);
                    models.put(key, model);
                    continue;
                }
                if (!name.endsWith(".png")) continue;
                textures.put(key, new TextureResource((ITextureManager)this, key, file, true));
            }
            catch (Exception e) {
                new ResourceLoadingException("Unable to load block model " + file.getAbsolutePath(), e).printStackTrace();
            }
        }
        this.models.putAll(models);
        this.textures.putAll(textures);
    }

    @Override
    protected void filterResources(Pattern namespace, Pattern path) {
        Iterator<String> itr = this.textures.keySet().iterator();
        while (itr.hasNext()) {
            String namespacedKey = itr.next();
            String assetNamespace = namespacedKey.substring(0, namespacedKey.indexOf(":"));
            String assetKey = namespacedKey.substring(namespacedKey.indexOf(":") + 1);
            if (!assetKey.contains(".")) {
                assetKey = assetKey + ".png";
            }
            if (!namespace.matcher(assetNamespace).matches() || !path.matcher(assetKey).matches()) continue;
            itr.remove();
        }
        Iterator<String> itr2 = this.models.keySet().iterator();
        while (itr2.hasNext()) {
            String namespacedKey = itr2.next();
            String assetNamespace = namespacedKey.substring(0, namespacedKey.indexOf(":"));
            String assetKey = namespacedKey.substring(namespacedKey.indexOf(":") + 1);
            if (!assetKey.contains(".")) {
                assetKey = assetKey + ".json";
            }
            if (!namespace.matcher(assetNamespace).matches() || !path.matcher(assetKey).matches()) continue;
            itr2.remove();
        }
    }

    @Override
    protected void reload() {
    }

    public BlockModel getRawBlockModel(String resourceLocation, boolean checkOverride) {
        if (checkOverride) {
            for (String overrideLocation : this.overrideLocations) {
                String overrideResourceLocation = resourceLocation.substring(0, resourceLocation.indexOf(":") + 1) + overrideLocation + resourceLocation.substring(resourceLocation.indexOf(":") + 1);
                BlockModel model = this.models.get(overrideResourceLocation);
                if (model == null) continue;
                return model;
            }
        }
        return this.manager.getModelManager().getRawBlockModel(resourceLocation);
    }

    @Override
    public BlockModel getRawBlockModel(String resourceLocation) {
        return this.getRawBlockModel(resourceLocation, false);
    }

    public BlockModel resolveBlockModel(String resourceLocation, boolean is1_8, Map<ModelOverride.ModelOverrideType, Float> predicates, OfflineICPlayer player, World world, LivingEntity entity, ItemStack itemStack, UnaryOperator<String> translateFunction) {
        BlockModel model = this.getRawBlockModel(resourceLocation, true);
        if (model == null) {
            return null;
        }
        for (ModelOverride override : model.getOverrides()) {
            if (!(override instanceof ChimeModelOverride ? ((ChimeModelOverride)override).test(predicates, player, world, entity, itemStack, translateFunction) : override.test(predicates))) continue;
            return this.resolveBlockModel(override.getModel(), is1_8, null);
        }
        while (model.getParent() != null && !model.getRawParent().equals("builtin/generated")) {
            if (model.getRawParent().equals("builtin/entity")) {
                BlockModel builtinModel = this.resolveBlockModel("minecraft:interactivechatdiscordsrvaddon/builtin_entity/" + resourceLocation.substring(resourceLocation.lastIndexOf("/") + 1), is1_8, predicates);
                if (builtinModel == null) break;
                return builtinModel;
            }
            BlockModel parent = this.getRawBlockModel(model.getParent());
            if (parent == null) break;
            for (ModelOverride override : model.getOverrides()) {
                if (!(override instanceof ChimeModelOverride ? ((ChimeModelOverride)override).test(predicates, player, world, entity, itemStack, translateFunction) : override.test(predicates))) continue;
                return this.resolveBlockModel(override.getModel(), is1_8, null);
            }
            model = model.resolve(parent, is1_8);
        }
        return model.resolve(is1_8);
    }

    @Override
    @Deprecated
    public BlockModel resolveBlockModel(String resourceLocation, boolean is1_8, Map<ModelOverride.ModelOverrideType, Float> predicates) {
        BlockModel model = this.getRawBlockModel(resourceLocation);
        if (model == null) {
            return null;
        }
        for (ModelOverride override : model.getOverrides()) {
            if (!override.test(predicates)) continue;
            return this.resolveBlockModel(override.getModel(), is1_8, null);
        }
        while (model.getParent() != null && !model.getRawParent().equals("builtin/generated")) {
            if (model.getRawParent().equals("builtin/entity")) {
                BlockModel builtinModel = this.resolveBlockModel("minecraft:interactivechatdiscordsrvaddon/builtin_entity/" + resourceLocation.substring(resourceLocation.lastIndexOf("/") + 1), is1_8, predicates);
                if (builtinModel == null) break;
                return builtinModel;
            }
            BlockModel parent = this.getRawBlockModel(model.getParent());
            if (parent == null) break;
            for (ModelOverride override : model.getOverrides()) {
                if (!override.test(predicates)) continue;
                return this.resolveBlockModel(override.getModel(), is1_8, null);
            }
            model = model.resolve(parent, is1_8);
        }
        return model.resolve(is1_8);
    }

    @Override
    public TextureResource getTexture(String resourceLocation, boolean returnMissingTexture) {
        TextureResource textureResource;
        if (!resourceLocation.contains(":")) {
            resourceLocation = "minecraft:" + resourceLocation;
        }
        if (resourceLocation.endsWith(".png")) {
            resourceLocation = resourceLocation.substring(0, resourceLocation.length() - 4);
        }
        if ((textureResource = this.textures.get(resourceLocation)) != null) {
            return textureResource;
        }
        String key = resourceLocation.substring(resourceLocation.indexOf(":") + 1);
        if (key.startsWith("textures/")) {
            resourceLocation = resourceLocation.substring(0, resourceLocation.indexOf(":") + 1) + key.substring(9);
        }
        return this.manager.getTextureManager().getTexture(resourceLocation, returnMissingTexture);
    }

    @Override
    public TextureResource getArmorOverrideTextures(String layer, ItemStack itemStack, OfflineICPlayer player, World world, LivingEntity entity, UnaryOperator<String> translateFunction) {
        for (String overrideLocation : this.overrideLocations) {
            String resourceKey = "minecraft:" + overrideLocation + "armor/" + layer;
            BlockModel model = this.getRawBlockModel(resourceKey, true);
            if (model == null || !(model instanceof ChimeBlockModel)) {
                return null;
            }
            for (ChimeModelOverride override : ((ChimeBlockModel)model).getChimeOverrides()) {
                if (!override.hasArmorTexture() || !override.test(null, player, world, entity, itemStack, translateFunction)) continue;
                return this.getTexture(override.getArmorTexture());
            }
        }
        return null;
    }
}

