/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime;

import com.loohp.interactivechat.libs.org.json.simple.JSONArray;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.BlockModel;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.Coordinates3D;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.IModelManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelAxis;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelDisplay;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelElement;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelFace;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelGUILight;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.TextureUV;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimeModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.resources.mods.chime.ChimeUtils;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ChimeBlockModel
extends BlockModel {
    public static ChimeBlockModel fromJson(IModelManager manager, String resourceLocation, JSONObject rootJson) {
        String parent = (String)rootJson.getOrDefault((Object)"parent", null);
        boolean ambientocclusion = (Boolean)rootJson.getOrDefault((Object)"ambientocclusion", (Object)true);
        ModelGUILight guiLight = rootJson.containsKey((Object)"gui_light") ? ModelGUILight.fromKey((String)rootJson.get((Object)"gui_light")) : null;
        EnumMap<ModelDisplay.ModelDisplayPosition, ModelDisplay> display = new EnumMap<ModelDisplay.ModelDisplayPosition, ModelDisplay>(ModelDisplay.ModelDisplayPosition.class);
        JSONObject displayJson = (JSONObject)rootJson.get((Object)"display");
        if (displayJson != null) {
            for (Object obj : displayJson.keySet()) {
                String displayKey = obj.toString();
                JSONArray rotationArray = (JSONArray)((JSONObject)displayJson.get((Object)displayKey)).get((Object)"rotation");
                JSONArray translationArray = (JSONArray)((JSONObject)displayJson.get((Object)displayKey)).get((Object)"translation");
                JSONArray scaleArray = (JSONArray)((JSONObject)displayJson.get((Object)displayKey)).get((Object)"scale");
                Coordinates3D rotation = rotationArray == null ? new Coordinates3D(0.0, 0.0, 0.0) : new Coordinates3D(((Number)rotationArray.get(0)).doubleValue(), ((Number)rotationArray.get(1)).doubleValue(), ((Number)rotationArray.get(2)).doubleValue());
                Coordinates3D translation = translationArray == null ? new Coordinates3D(0.0, 0.0, 0.0) : new Coordinates3D(((Number)translationArray.get(0)).doubleValue(), ((Number)translationArray.get(1)).doubleValue(), ((Number)translationArray.get(2)).doubleValue());
                Coordinates3D scale = scaleArray == null ? new Coordinates3D(1.0, 1.0, 1.0) : new Coordinates3D(((Number)scaleArray.get(0)).doubleValue(), ((Number)scaleArray.get(1)).doubleValue(), ((Number)scaleArray.get(2)).doubleValue());
                ModelDisplay.ModelDisplayPosition displayPos = ModelDisplay.ModelDisplayPosition.fromKey(displayKey);
                display.put(displayPos, new ModelDisplay(displayPos, rotation, translation, scale));
            }
        }
        HashMap<String, String> texture = new HashMap<String, String>();
        JSONObject textureJson = (JSONObject)rootJson.get((Object)"textures");
        if (textureJson != null) {
            for (Object obj : textureJson.keySet()) {
                String textureKey = obj.toString();
                texture.put(textureKey, textureJson.get((Object)textureKey).toString());
            }
        }
        ArrayList<ModelElement> elements = new ArrayList<ModelElement>();
        JSONArray elementsArray = (JSONArray)rootJson.get((Object)"elements");
        if (elementsArray != null) {
            for (Object obj : elementsArray) {
                ModelElement.ModelElementRotation rotation;
                JSONObject elementJson = (JSONObject)obj;
                String name = (String)elementJson.get((Object)"name");
                JSONArray fromArray = (JSONArray)elementJson.get((Object)"from");
                JSONArray toArray = (JSONArray)elementJson.get((Object)"to");
                Coordinates3D from = new Coordinates3D(((Number)fromArray.get(0)).doubleValue(), ((Number)fromArray.get(1)).doubleValue(), ((Number)fromArray.get(2)).doubleValue());
                Coordinates3D to = new Coordinates3D(((Number)toArray.get(0)).doubleValue(), ((Number)toArray.get(1)).doubleValue(), ((Number)toArray.get(2)).doubleValue());
                JSONObject rotationJson = (JSONObject)elementJson.get((Object)"rotation");
                if (rotationJson == null) {
                    rotation = null;
                } else {
                    JSONArray originArray = (JSONArray)rotationJson.get((Object)"origin");
                    Coordinates3D origin = originArray == null ? new Coordinates3D(0.0, 0.0, 0.0) : new Coordinates3D(((Number)originArray.get(0)).doubleValue(), ((Number)originArray.get(1)).doubleValue(), ((Number)originArray.get(2)).doubleValue());
                    ModelAxis axis = ModelAxis.valueOf(rotationJson.get((Object)"axis").toString().toUpperCase());
                    double angle = ((Number)rotationJson.get((Object)"angle")).doubleValue();
                    boolean rescale = (Boolean)rotationJson.getOrDefault((Object)"rescale", (Object)false);
                    rotation = new ModelElement.ModelElementRotation(origin, axis, angle, rescale);
                }
                boolean shade = (Boolean)elementJson.getOrDefault((Object)"shade", (Object)true);
                EnumMap<ModelFace.ModelFaceSide, ModelFace> face = new EnumMap<ModelFace.ModelFaceSide, ModelFace>(ModelFace.ModelFaceSide.class);
                JSONObject facesJson = (JSONObject)elementJson.get((Object)"faces");
                if (facesJson != null) {
                    for (Object obj1 : facesJson.keySet()) {
                        String faceKey = obj1.toString();
                        ModelFace.ModelFaceSide side = ModelFace.ModelFaceSide.fromKey(faceKey);
                        JSONObject faceJson = (JSONObject)facesJson.get((Object)faceKey);
                        JSONArray uvArray = (JSONArray)faceJson.get((Object)"uv");
                        TextureUV uv = uvArray == null ? null : new TextureUV(((Number)uvArray.get(0)).doubleValue(), ((Number)uvArray.get(1)).doubleValue(), ((Number)uvArray.get(2)).doubleValue(), ((Number)uvArray.get(3)).doubleValue());
                        String faceTexture = (String)faceJson.get((Object)"texture");
                        Object cullfaceObj = faceJson.get((Object)"cullface");
                        ModelFace.ModelFaceSide cullface = cullfaceObj != null && cullfaceObj instanceof String ? ModelFace.ModelFaceSide.fromKey((String)cullfaceObj) : side;
                        int faceRotation = ((Number)faceJson.getOrDefault((Object)"rotation", (Object)0)).intValue();
                        int faceTintindex = ((Number)faceJson.getOrDefault((Object)"tintindex", (Object)-1)).intValue();
                        face.put(side, new ModelFace(side, uv, faceTexture, cullface, faceRotation, faceTintindex));
                    }
                }
                elements.add(new ModelElement(name, from, to, rotation, shade, face));
            }
        }
        ArrayList<ChimeModelOverride> overrides = new ArrayList<ChimeModelOverride>();
        JSONArray overridesArray = (JSONArray)rootJson.get((Object)"overrides");
        if (overridesArray != null) {
            ListIterator itr = overridesArray.listIterator(overridesArray.size());
            while (itr.hasPrevious()) {
                JSONObject overrideJson = (JSONObject)itr.previous();
                JSONObject predicateJson = (JSONObject)overrideJson.get((Object)"predicate");
                EnumMap<ModelOverride.ModelOverrideType, Float> predicates = new EnumMap<ModelOverride.ModelOverrideType, Float>(ModelOverride.ModelOverrideType.class);
                for (Object obj1 : predicateJson.keySet()) {
                    String predicateTypeKey = obj1.toString();
                    ModelOverride.ModelOverrideType type = ModelOverride.ModelOverrideType.fromKey(predicateTypeKey);
                    if (type == null) continue;
                    Object value = predicateJson.get((Object)predicateTypeKey);
                    predicates.put(type, Float.valueOf(((Number)value).floatValue()));
                }
                Map<ChimeModelOverride.ChimeModelOverrideType, Object> chimePredicates = ChimeUtils.getAllPredicates(predicateJson, new String[0]);
                String model = (String)overrideJson.get((Object)"model");
                if (overrideJson.containsKey((Object)"texture")) {
                    String armorTexture = (String)overrideJson.get((Object)"texture");
                    overrides.add(new ChimeModelOverride(predicates, chimePredicates, model, armorTexture));
                    continue;
                }
                overrides.add(new ChimeModelOverride(predicates, chimePredicates, model));
            }
        }
        return new ChimeBlockModel(manager, resourceLocation, parent, ambientocclusion, guiLight, (Map<ModelDisplay.ModelDisplayPosition, ModelDisplay>)display, (Map<String, String>)texture, (List<ModelElement>)elements, (List<ChimeModelOverride>)overrides);
    }

    public ChimeBlockModel(IModelManager manager, String resourceLocation, String parent, boolean ambientocclusion, ModelGUILight guiLight, Map<ModelDisplay.ModelDisplayPosition, ModelDisplay> display, Map<String, String> textures, List<ModelElement> elements, List<ChimeModelOverride> overrides) {
        super(manager, resourceLocation, parent, ambientocclusion, guiLight, display, textures, elements, overrides);
    }

    public List<ChimeModelOverride> getChimeOverrides() {
        return this.getOverrides();
    }
}

