/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.models;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class ModelOverride {
    private Map<ModelOverrideType, Float> predicates;
    private String model;

    private static float floatValueOr(Float value, float fallback) {
        return value == null ? fallback : value.floatValue();
    }

    public ModelOverride(Map<ModelOverrideType, Float> predicates, String model) {
        this.predicates = Collections.unmodifiableMap(predicates);
        this.model = model;
    }

    public Map<ModelOverrideType, Float> getPredicates() {
        return this.predicates;
    }

    public String getRawModel() {
        return this.model;
    }

    public String getModel() {
        return this.model == null ? null : (this.model.contains(":") ? this.model : "minecraft:" + this.model);
    }

    public boolean test(Map<ModelOverrideType, Float> data) {
        if (data == null) {
            data = Collections.emptyMap();
        }
        for (Map.Entry<ModelOverrideType, Float> entry : this.predicates.entrySet()) {
            float valueComparing;
            float value;
            if (entry.getValue() == null || !((value = ModelOverride.floatValueOr(data.get((Object)entry.getKey()), Float.NEGATIVE_INFINITY)) < (valueComparing = entry.getValue().floatValue()))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelOverride that = (ModelOverride)o;
        return Objects.equals(this.predicates, that.predicates) && Objects.equals(this.model, that.model);
    }

    public int hashCode() {
        return Objects.hash(this.predicates, this.model);
    }

    public static enum ModelOverrideType {
        ANGLE,
        BLOCKING,
        BROKEN,
        CAST,
        COOLDOWN,
        DAMAGE,
        DAMAGED,
        FILLED,
        LEFTHANDED,
        PULL,
        PULLING,
        CHARGED,
        FIREWORK,
        THROWING,
        TIME,
        LEVEL,
        CUSTOM_MODEL_DATA;


        public static ModelOverrideType fromKey(String key) {
            for (ModelOverrideType type : ModelOverrideType.values()) {
                if (!key.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
            return null;
        }
    }
}

