/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.models;

import com.loohp.interactivechat.libs.org.apache.commons.io.input.BOMInputStream;
import com.loohp.interactivechat.libs.org.json.simple.JSONObject;
import com.loohp.interactivechat.libs.org.json.simple.parser.JSONParser;
import com.loohp.interactivechatdiscordsrvaddon.resources.AbstractManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceLoadingException;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourceManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.ResourcePackFile;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.BlockModel;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.IModelManager;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelOverride;
import com.loohp.interactivechatdiscordsrvaddon.utils.TriFunction;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

public class ModelManager
extends AbstractManager
implements IModelManager {
    public static final TriFunction<IModelManager, String, JSONObject, BlockModel> DEFAULT_MODEL_PARSING_FUNCTION = (manager, key, json) -> BlockModel.fromJson(manager, key, json);
    public static final String CACHE_KEY = "ModelManager";
    public static final String BLOCK_ENTITY_BASE = "builtin/entity";
    public static final String ITEM_BASE = "builtin/generated";
    public static final String ITEM_BASE_LAYER = "layer";
    private Map<String, BlockModel> models = new HashMap<String, BlockModel>();
    private TriFunction<IModelManager, String, JSONObject, ? extends BlockModel> modelParsingFunction = DEFAULT_MODEL_PARSING_FUNCTION;

    public ModelManager(ResourceManager manager) {
        super(manager);
    }

    @Override
    protected void loadDirectory(String namespace, ResourcePackFile root, Object ... meta) {
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException(root.getAbsolutePath() + " is not a directory.");
        }
        JSONParser parser = new JSONParser();
        HashMap<String, BlockModel> models = new HashMap<String, BlockModel>();
        Collection<ResourcePackFile> files = root.listFilesRecursively(new String[]{"json"});
        for (ResourcePackFile file : files) {
            try {
                String key = namespace + ":" + file.getRelativePathFrom(root);
                key = key.substring(0, key.lastIndexOf("."));
                InputStreamReader reader = new InputStreamReader((InputStream)new BOMInputStream(file.getInputStream()), StandardCharsets.UTF_8);
                JSONObject rootJson = (JSONObject)parser.parse((Reader)reader);
                reader.close();
                BlockModel model = this.modelParsingFunction.apply(this, key, rootJson);
                models.put(key, model);
            }
            catch (Exception e) {
                new ResourceLoadingException("Unable to load block model " + file.getAbsolutePath(), e).printStackTrace();
            }
        }
        this.models.putAll(models);
    }

    @Override
    protected void filterResources(Pattern namespace, Pattern path) {
        Iterator<String> itr = this.models.keySet().iterator();
        while (itr.hasNext()) {
            String namespacedKey = itr.next();
            String assetNamespace = namespacedKey.substring(0, namespacedKey.indexOf(":"));
            String assetKey = namespacedKey.substring(namespacedKey.indexOf(":") + 1);
            if (!assetKey.contains(".")) {
                assetKey = assetKey + ".json";
            }
            if (!namespace.matcher(assetNamespace).matches() || !path.matcher(assetKey).matches()) continue;
            itr.remove();
        }
    }

    @Override
    protected void reload() {
    }

    public TriFunction<IModelManager, String, JSONObject, ? extends BlockModel> getModelParsingFunction() {
        return this.modelParsingFunction;
    }

    public void setModelParsingFunction(TriFunction<IModelManager, String, JSONObject, ? extends BlockModel> modelParsingFunction) {
        this.modelParsingFunction = modelParsingFunction;
    }

    @Override
    public BlockModel getRawBlockModel(String resourceLocation) {
        return this.models.get(resourceLocation);
    }

    public Map<String, BlockModel> getRawBlockModelMapping() {
        return Collections.unmodifiableMap(this.models);
    }

    @Override
    public BlockModel resolveBlockModel(String resourceLocation, boolean is1_8, Map<ModelOverride.ModelOverrideType, Float> predicates) {
        BlockModel model = this.models.get(resourceLocation);
        if (model == null) {
            return null;
        }
        for (ModelOverride override : model.getOverrides()) {
            if (!override.test(predicates)) continue;
            return this.resolveBlockModel(override.getModel(), is1_8, null);
        }
        while (model.getParent() != null && !model.getRawParent().equals(ITEM_BASE)) {
            if (model.getRawParent().equals(BLOCK_ENTITY_BASE)) {
                BlockModel builtinModel = this.resolveBlockModel("minecraft:interactivechatdiscordsrvaddon/builtin_entity/" + resourceLocation.substring(resourceLocation.lastIndexOf("/") + 1), is1_8, predicates);
                if (builtinModel == null) break;
                return builtinModel;
            }
            BlockModel parent = this.models.get(model.getParent());
            if (parent == null) break;
            for (ModelOverride override : model.getOverrides()) {
                if (!override.test(predicates)) continue;
                return this.resolveBlockModel(override.getModel(), is1_8, null);
            }
            model = model.resolve(parent, is1_8);
        }
        return model.resolve(is1_8);
    }
}

