/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.models;

import com.loohp.interactivechatdiscordsrvaddon.resources.models.TextureUV;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ModelFace {
    private ModelFaceSide side;
    private TextureUV uv;
    private String texture;
    private ModelFaceSide cullface;
    private int rotation;
    private int tintindex;

    public ModelFace(ModelFaceSide side, TextureUV uv, String texture, ModelFaceSide cullface, int rotation, int tintindex) {
        this.side = side;
        this.uv = uv;
        this.texture = texture;
        this.cullface = cullface;
        this.rotation = rotation;
        this.tintindex = tintindex;
    }

    public ModelFaceSide getSide() {
        return this.side;
    }

    public TextureUV getUV() {
        return this.uv;
    }

    public String getRawTexture() {
        return this.texture;
    }

    public String getTexture() {
        if (this.texture.startsWith("#")) {
            return this.texture;
        }
        return this.texture == null ? null : (this.texture.contains(":") ? this.texture : "minecraft:" + this.texture);
    }

    public ModelFace cloneWithNewTexture(String texture) {
        return new ModelFace(this.side, this.uv, texture, this.cullface, this.rotation, this.tintindex);
    }

    public ModelFaceSide getCullface() {
        return this.cullface;
    }

    public int getRotation() {
        return this.rotation;
    }

    public int getTintindex() {
        return this.tintindex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelFace modelFace = (ModelFace)o;
        return this.rotation == modelFace.rotation && this.tintindex == modelFace.tintindex && this.side == modelFace.side && Objects.equals(this.uv, modelFace.uv) && Objects.equals(this.texture, modelFace.texture) && this.cullface == modelFace.cullface;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.side, this.uv, this.texture, this.cullface, this.rotation, this.tintindex});
    }

    public static enum ModelFaceSide {
        UP(new String[0]),
        DOWN("BOTTOM"),
        NORTH(new String[0]),
        EAST(new String[0]),
        SOUTH(new String[0]),
        WEST(new String[0]);

        private Set<String> aliases;

        public static ModelFaceSide fromKey(String key) {
            for (ModelFaceSide face : ModelFaceSide.values()) {
                if (!key.equalsIgnoreCase(face.toString()) && !face.aliases.stream().anyMatch(each -> each.equalsIgnoreCase(key))) continue;
                return face;
            }
            return null;
        }

        private ModelFaceSide(String ... aliases) {
            this.aliases = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(aliases)));
        }

        public Set<String> getAliases() {
            return this.aliases;
        }
    }
}

