/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.interactivechatdiscordsrvaddon.resources.models;

import com.loohp.interactivechatdiscordsrvaddon.resources.models.Coordinates3D;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelAxis;
import com.loohp.interactivechatdiscordsrvaddon.resources.models.ModelFace;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class ModelElement {
    private String name;
    private Coordinates3D from;
    private Coordinates3D to;
    private ModelElementRotation rotation;
    private boolean shade;
    private Map<ModelFace.ModelFaceSide, ModelFace> face;

    public ModelElement(String name, Coordinates3D from, Coordinates3D to, ModelElementRotation rotation, boolean shade, Map<ModelFace.ModelFaceSide, ModelFace> face) {
        this.name = name;
        this.from = from;
        this.to = to;
        this.rotation = rotation;
        this.shade = shade;
        this.face = Collections.unmodifiableMap(face);
    }

    public String getName() {
        return this.name;
    }

    public Coordinates3D getFrom() {
        return this.from;
    }

    public Coordinates3D getTo() {
        return this.to;
    }

    public ModelElementRotation getRotation() {
        return this.rotation;
    }

    public boolean isShade() {
        return this.shade;
    }

    public Map<ModelFace.ModelFaceSide, ModelFace> getFaces() {
        return this.face;
    }

    public ModelFace getFace(ModelFace.ModelFaceSide side) {
        return this.face.get((Object)side);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModelElement that = (ModelElement)o;
        return this.shade == that.shade && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.rotation, that.rotation) && Objects.equals(this.face, that.face);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.rotation, this.shade, this.face);
    }

    public static class ModelElementRotation {
        private Coordinates3D origin;
        private ModelAxis axis;
        private double angle;
        private boolean rescale;

        public ModelElementRotation(Coordinates3D origin, ModelAxis axis, double angle, boolean rescale) {
            this.origin = origin;
            this.axis = axis;
            this.angle = angle;
            this.rescale = rescale;
        }

        public Coordinates3D getOrigin() {
            return this.origin;
        }

        public ModelAxis getAxis() {
            return this.axis;
        }

        public double getAngle() {
            return this.angle;
        }

        public boolean isRescale() {
            return this.rescale;
        }
    }
}

